/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueOps;
import org.junit.Assert;
import org.junit.Test;

public class TestNodeValueOps {
    @Test
    public void nv_add_1() {
        TestNodeValueOps.testAdd("12", "13", "'25'^^xsd:integer");
    }

    @Test
    public void nv_add_2() {
        TestNodeValueOps.testAdd("'12'^^xsd:decimal", "13", "'25.0'^^xsd:decimal");
    }

    @Test
    public void nv_add_3() {
        TestNodeValueOps.testAdd("'12.0'^^xsd:decimal", "13", "'25.0'^^xsd:decimal");
    }

    @Test
    public void nv_add_4() {
        TestNodeValueOps.testAdd("12e0", "13", "25.0e0");
    }

    @Test
    public void nv_add_10() {
        TestNodeValueOps.testAdd("'12'", "'13'", "'1213'");
    }

    @Test
    public void nv_add_20() {
        TestNodeValueOps.testAdd("'PT1H'^^xsd:duration", "'PT1H'^^xsd:duration", "'PT2H'^^xsd:duration");
    }

    @Test
    public void nv_add_21() {
        TestNodeValueOps.testAdd("'PT1H'^^xsd:dayTimeDuration", "'PT1H'^^xsd:dayTimeDuration", "'PT2H'^^xsd:dayTimeDuration");
    }

    @Test
    public void nv_add_22() {
        try {
            TestNodeValueOps.testAdd("'P1Y'^^xsd:yearMonthDuration", "'PT4H'^^xsd:dayTimeDuration", "'P1YT4H'^^xsd:duration");
        }
        catch (NullPointerException ex) {
            if (TestNodeValueOps.isProbablyIBMJVM()) {
                Log.warn(this, "TestNodeValueOps.nv_add_22 - IBM JVM - reported issue in the support for xsd:xsd:yearMonthDuration/xsd:dayTimeDuration");
            }
            throw ex;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static boolean isProbablyIBMJVM() {
        return System.getProperty("java.vm.name", "").contains("IBM");
    }

    @Test
    public void nv_add_23() {
        TestNodeValueOps.testAdd("'2000-01-01'^^xsd:date", "'P1Y'^^xsd:duration", "'2001-01-01'^^xsd:date");
    }

    @Test
    public void nv_add_24() {
        TestNodeValueOps.testAdd("'2000-01-01T00:00:00Z'^^xsd:dateTime", "'P1Y1M'^^xsd:yearMonthDuration", "'2001-02-01T00:00:00Z'^^xsd:dateTime");
    }

    @Test
    public void nv_add_25() {
        TestNodeValueOps.testAdd("'2000-01-01T00:00:00Z'^^xsd:dateTime", "'P1Y1M1DT1H1M1.1S'^^xsd:duration", "'2001-02-02T01:01:01.1Z'^^xsd:dateTime");
    }

    @Test
    public void nv_add_26() {
        TestNodeValueOps.testAdd("'00:00:00'^^xsd:time", "'PT1H2M3.4S'^^xsd:duration", "'01:02:03.4'^^xsd:time");
    }

    @Test(expected=ExprEvalException.class)
    public void nv_add_50() {
        TestNodeValueOps.testAdd("'12'", "13");
    }

    @Test(expected=ExprEvalException.class)
    public void nv_add_51() {
        TestNodeValueOps.testAdd("'12'", "'PT1H'^^xsd:duration");
    }

    @Test(expected=ExprEvalException.class)
    public void nv_add_52() {
        TestNodeValueOps.testAdd("'2012-04-05'^^xsd:date", "'2012-04-05'^^xsd:date");
    }

    @Test
    public void nv_sub_1() {
        TestNodeValueOps.testSub("12", "13", "-1");
    }

    @Test
    public void nv_sub_2() {
        TestNodeValueOps.testSub("12", "13.0", "-1.0");
    }

    @Test
    public void nv_sub_3() {
        TestNodeValueOps.testSub("12e0", "13.0", "-1.0e0");
    }

    @Test
    public void nv_sub_20() {
        TestNodeValueOps.testSub("'PT2H'^^xsd:duration", "'PT1H'^^xsd:duration", "'PT1H'^^xsd:duration");
    }

    @Test
    public void nv_sub_21() {
        TestNodeValueOps.testSub("'PT2H'^^xsd:dayTimeDuration", "'PT1H'^^xsd:dayTimeDuration", "'PT1H'^^xsd:dayTimeDuration");
    }

    @Test
    public void nv_sub_22() {
        try {
            TestNodeValueOps.testSub("'P2Y'^^xsd:yearMonthDuration", "'P1Y'^^xsd:yearMonthDuration", "'P1Y'^^xsd:yearMonthDuration");
        }
        catch (NullPointerException ex) {
            if (TestNodeValueOps.isProbablyIBMJVM()) {
                Log.warn(this, "TestNodeValueOps.nv_sub_22 - IBM JVM - reported issue in the support for xsd:xsd:yearMonthDuration/xsd:dayTimeDuration");
            }
            throw ex;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void nv_sub_23() {
        TestNodeValueOps.testSub("'P3D'^^xsd:dayTimeDuration", "'PT4H'^^xsd:dayTimeDuration", "'P2DT20H'^^xsd:dayTimeDuration");
    }

    @Test
    public void nv_sub_30() {
        TestNodeValueOps.testSub("'2000-01-01'^^xsd:date", "'P1Y'^^xsd:duration", "'1999-01-01'^^xsd:date");
    }

    @Test
    public void nv_sub_31() {
        TestNodeValueOps.testSub("'2000-01-01T00:00:00Z'^^xsd:dateTime", "'P1Y1M'^^xsd:yearMonthDuration", "'1998-12-01T00:00:00Z'^^xsd:dateTime");
    }

    @Test
    public void nv_sub_32() {
        TestNodeValueOps.testSub("'2000-01-01T00:00:00Z'^^xsd:dateTime", "'P1Y1M1DT1H1M1.1S'^^xsd:duration", "'1998-11-29T22:58:58.9Z'^^xsd:dateTime");
    }

    @Test
    public void nv_sub_33() {
        TestNodeValueOps.testSub("'10:11:12'^^xsd:time", "'PT1H2M3.4S'^^xsd:duration", "'09:09:08.6'^^xsd:time");
    }

    @Test(expected=ExprEvalException.class)
    public void nv_sub_50() {
        TestNodeValueOps.testSub("'12'", "'13'");
    }

    @Test
    public void nv_mult_1() {
        TestNodeValueOps.testMult("12", "13", "156");
    }

    @Test
    public void nv_mult_2() {
        TestNodeValueOps.testMult("-12", "13.0", "-156.0");
    }

    @Test
    public void nv_mult_3() {
        TestNodeValueOps.testMult("'PT1H2M'^^xsd:duration", "2", "'PT2H4M'^^xsd:dayTimeDuration");
    }

    @Test
    public void nv_div_1() {
        TestNodeValueOps.testDiv("12", "2", "6.0");
    }

    @Test
    public void nv_div_2() {
        TestNodeValueOps.testDiv("12", "2e0", "6.0e0");
    }

    static void testAdd(String s1, String s2, String s3) {
        NodeValue nv3 = NodeValue.parse(s3);
        NodeValue nv = TestNodeValueOps.testAdd(s1, s2);
        Assert.assertEquals((Object)nv3, (Object)nv);
    }

    static NodeValue testAdd(String s1, String s2) {
        NodeValue nv1 = NodeValue.parse(s1);
        NodeValue nv2 = NodeValue.parse(s2);
        return NodeValueOps.additionNV(nv1, nv2);
    }

    static void testSub(String s1, String s2, String s3) {
        NodeValue nv3 = NodeValue.parse(s3);
        NodeValue nv = TestNodeValueOps.testSub(s1, s2);
        Assert.assertEquals((Object)nv3, (Object)nv);
    }

    static NodeValue testSub(String s1, String s2) {
        NodeValue nv1 = NodeValue.parse(s1);
        NodeValue nv2 = NodeValue.parse(s2);
        return NodeValueOps.subtractionNV(nv1, nv2);
    }

    static void testMult(String s1, String s2, String s3) {
        NodeValue nv3 = NodeValue.parse(s3);
        NodeValue nv = TestNodeValueOps.testMult(s1, s2);
        Assert.assertEquals((Object)nv3, (Object)nv);
    }

    static NodeValue testMult(String s1, String s2) {
        NodeValue nv1 = NodeValue.parse(s1);
        NodeValue nv2 = NodeValue.parse(s2);
        return NodeValueOps.multiplicationNV(nv1, nv2);
    }

    static void testDiv(String s1, String s2, String s3) {
        NodeValue nv3 = NodeValue.parse(s3);
        NodeValue nv = TestNodeValueOps.testDiv(s1, s2);
        Assert.assertEquals((Object)nv3, (Object)nv);
    }

    static NodeValue testDiv(String s1, String s2) {
        NodeValue nv1 = NodeValue.parse(s1);
        NodeValue nv2 = NodeValue.parse(s2);
        return NodeValueOps.divisionNV(nv1, nv2);
    }
}

