/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.TimeZone;
import org.apache.jena.JenaRuntime;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprNotComparableException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestNodeValue {
    static final double doubleAccuracy = 1.0E-8;
    static boolean warningSetting;

    @BeforeClass
    public static void beforeClass() {
        warningSetting = NodeValue.VerboseWarnings;
        NodeValue.VerboseWarnings = false;
    }

    @AfterClass
    public static void afterClass() {
        NodeValue.VerboseWarnings = warningSetting;
    }

    @Test
    public void testInt1() {
        NodeValue v = NodeValue.makeInteger(5L);
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        Assert.assertFalse((String)("Is a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testInt2() {
        NodeValue v = NodeValue.makeNodeInteger(5L);
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testInt3() {
        NodeValue v1 = NodeValue.makeNodeInteger(5L);
        NodeValue v2 = NodeValue.makeInteger(5L);
        Assert.assertTrue((String)("Not same integer: " + v1 + " & " + v2), (boolean)v1.getInteger().equals(v2.getInteger()));
    }

    @Test
    public void testFloat1() {
        NodeValue v = NodeValue.makeFloat(5.0f);
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not a float: " + v), (boolean)v.isFloat());
        Assert.assertTrue((String)("Float not a double: " + v), (boolean)v.isDouble());
        Assert.assertFalse((String)("No node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testFloat2() {
        NodeValue v = NodeValue.makeNodeFloat(5.0f);
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not a float: " + v), (boolean)v.isDouble());
        Assert.assertTrue((String)("Float not a double: " + v), (boolean)v.isDouble());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testFloat3() {
        NodeValue v1 = NodeValue.makeNodeFloat(5.7f);
        NodeValue v2 = NodeValue.makeFloat(5.7f);
        Assert.assertTrue((String)("Not same float: " + v1 + " & " + v2), (v1.getFloat() == v2.getFloat() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Not same float as double: " + v1 + " & " + v2), (v1.getDouble() == v2.getDouble() ? 1 : 0) != 0);
    }

    @Test
    public void testDouble1() {
        NodeValue v = NodeValue.makeDouble(5.0);
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        Assert.assertFalse((String)("No node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testDouble2() {
        NodeValue v = NodeValue.makeNodeDouble(5.0);
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testDouble3() {
        NodeValue v1 = NodeValue.makeNodeDouble(5.7);
        NodeValue v2 = NodeValue.makeDouble(5.7);
        Assert.assertTrue((String)("Not same double: " + v1 + " & " + v2), (v1.getDouble() == v2.getDouble() ? 1 : 0) != 0);
    }

    @Test
    public void testDecimal1() {
        NodeValue v = NodeValue.makeDecimal(new BigDecimal("1.3"));
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not a double: " + v), (boolean)v.isDecimal());
        Assert.assertFalse((String)("Is a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testDecimal2() {
        NodeValue v = NodeValue.makeNodeDecimal("1.3");
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not a double: " + v), (boolean)v.isDecimal());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testDecimal3() {
        NodeValue v1 = NodeValue.makeDecimal(new BigDecimal("1.3"));
        NodeValue v2 = NodeValue.makeNodeDecimal("1.3");
        Assert.assertTrue((String)("Not same decimal: " + v1 + " & " + v2), (v1.getDecimal().compareTo(v2.getDecimal()) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)("Not same decimal by equals: " + v1 + " & " + v2), (Object)v1, (Object)v2);
    }

    @Test
    public void testDateTime1() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(0L);
        cal.set(2005, 1, 18, 20, 39, 10);
        NodeValue v = NodeValue.makeDateTime(cal);
        Assert.assertTrue((String)("Not a dateTime: " + v), (boolean)v.isDateTime());
        Assert.assertFalse((String)("A date: " + v), (boolean)v.isDate());
    }

    @Test
    public void testDateTime2() {
        NodeValue v = NodeValue.makeNodeDateTime("2005-02-18T20:39:10Z");
        Assert.assertTrue((String)("Not a dateTime: " + v), (boolean)v.isDateTime());
        Assert.assertFalse((String)("A date: " + v), (boolean)v.isDate());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testDateTime3() {
        NodeValue v1 = NodeValue.makeDateTime("2005-02-18T20:39:10Z");
        NodeValue v2 = NodeValue.makeNodeDateTime("2005-02-18T20:39:10Z");
        Assert.assertEquals((String)"Not Calendar.equals: ", (Object)v1.getDateTime(), (Object)v2.getDateTime());
    }

    @Test
    public void testDateTime4() {
        GregorianCalendar cal1 = new GregorianCalendar();
        ((Calendar)cal1).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal1.setTimeInMillis(0L);
        cal1.set(2005, 1, 18, 20, 39, 10);
        NodeValue v = NodeValue.makeNode("2005-02-18T20:39:10Z", XSDDatatype.XSDdateTime);
        Assert.assertTrue((String)("Not a dateTime: " + v), (boolean)v.isDateTime());
        Assert.assertFalse((String)("A date: " + v), (boolean)v.isDate());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        GregorianCalendar cal2 = v.getDateTime().toGregorianCalendar();
        Assert.assertEquals((String)("Not equal: " + v), (long)0L, (long)cal1.compareTo(cal2));
    }

    @Test
    public void testDateTime5() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNode("2005-02-18", XSDDatatype.XSDdateTime);
            Assert.assertFalse((String)("Date!: " + v), (boolean)v.isDate());
            Assert.assertFalse((String)("Datetime!: " + v), (boolean)v.isDateTime());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    @Test
    public void testDateTime6() {
        NodeValue v0 = NodeValue.makeDateTime("2005-02-18T20:39:10Z");
        NodeValue v1 = NodeValue.makeDateTime("2005-02-18T20:39:10.0Z");
        NodeValue v2 = NodeValue.makeDateTime("2005-02-18T20:39:10.00Z");
        NodeValue v3 = NodeValue.makeDateTime("2005-02-18T20:39:10.000Z");
        Assert.assertEquals((String)"Not Calendar.equals: ", (Object)v0.getDateTime(), (Object)v1.getDateTime());
        Assert.assertEquals((String)"Not Calendar.equals: ", (Object)v0.getDateTime(), (Object)v2.getDateTime());
        Assert.assertEquals((String)"Not Calendar.equals: ", (Object)v0.getDateTime(), (Object)v3.getDateTime());
    }

    @Test
    public void testDateTime7() {
        NodeValue v0 = NodeValue.makeDateTime("2005-02-18T20:39:10Z");
        NodeValue v1 = NodeValue.makeDateTime("2005-02-18T20:39:10.001Z");
        Assert.assertNotSame((String)"Calendar.equals: ", (Object)v0.getDateTime(), (Object)v1.getDateTime());
    }

    @Test
    public void testDateTime8() {
        NodeValue v0 = NodeValue.makeDateTime("2005-02-18T20:39:10-05:00");
        NodeValue v1 = NodeValue.makeDateTime("2005-02-18T17:39:10.000-08:00");
        Assert.assertEquals((String)"Not Calendar.equals: ", (Object)v0.getDateTime(), (Object)v1.getDateTime());
    }

    @Test
    public void testDateTimeStamp1() {
        Node n = SSE.parseNode("'2000-01-01T00:00:00+00:00'^^xsd:dateTimeStamp");
        NodeValue nv = NodeValue.makeNode(n);
        Assert.assertTrue((boolean)nv.isDateTime());
        Assert.assertFalse((boolean)nv.isDate());
    }

    @Test
    public void testDate1() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(0L);
        cal.set(2005, 1, 18, 0, 0, 0);
        NodeValue v = NodeValue.makeDate(cal);
        Assert.assertTrue((String)("Not a date: " + v), (boolean)v.isDate());
        Assert.assertFalse((String)("A dateTime: " + v), (boolean)v.isDateTime());
    }

    @Test
    public void testDate2() {
        NodeValue v = NodeValue.makeNodeDate("2005-02-18");
        Assert.assertTrue((String)("Not a date: " + v), (boolean)v.isDate());
        Assert.assertFalse((String)("A dateTime: " + v), (boolean)v.isDateTime());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testDate3() {
        NodeValue v1 = NodeValue.makeDate("2005-02-18+01:00");
        NodeValue v2 = NodeValue.makeNodeDate("2005-02-18+01:00");
        Assert.assertEquals((String)"Not Calendar.equals: ", (Object)v1.getDateTime(), (Object)v2.getDateTime());
    }

    @Test
    public void testDate4() {
        GregorianCalendar cal1 = new GregorianCalendar();
        ((Calendar)cal1).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal1.setTimeInMillis(0L);
        cal1.set(2005, 1, 18, 0, 0, 0);
        NodeValue v = NodeValue.makeNode("2005-02-18Z", XSDDatatype.XSDdate);
        Assert.assertTrue((String)("Not a date: " + v), (boolean)v.isDate());
        Assert.assertFalse((String)("A dateTime: " + v), (boolean)v.isDateTime());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        GregorianCalendar cal2 = v.getDateTime().toGregorianCalendar();
        Assert.assertEquals((String)("Not equal: " + v), (long)0L, (long)cal1.compareTo(cal2));
    }

    @Test
    public void testDate5() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNode("2005-02-18T20:39:10Z", XSDDatatype.XSDdate);
            Assert.assertFalse((String)("Datetime!: " + v), (boolean)v.isDateTime());
            Assert.assertFalse((String)("Date!: " + v), (boolean)v.isDate());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    @Test
    public void testNodeInt1() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDinteger);
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeInt2() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDdouble);
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeInt3() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDinteger);
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        Assert.assertEquals((String)"Print form mismatch", (Object)"57", (Object)actualStr);
    }

    @Test
    public void testNodeInt4() {
        NodeValue v = NodeValue.makeNodeInteger(18L);
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        Assert.assertEquals((String)"Print form mismatch", (Object)"18", (Object)actualStr);
    }

    @Test
    public void testNodeInt5() {
        NodeValue v = NodeValue.makeNodeInteger("018");
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        Assert.assertEquals((String)"Print form mismatch", (Object)"018", (Object)actualStr);
    }

    @Test
    public void testNodeInt6() {
        NodeValue v = NodeValue.makeNodeInteger(" 18");
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeInt7() {
        NodeValue v = NodeValue.makeNodeInteger(" 18 ");
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeInt8() {
        NodeValue v = NodeValue.makeNodeInteger("1 8");
        Assert.assertFalse((String)("A number!: " + v), (boolean)v.isNumber());
        Assert.assertFalse((String)("An integer!: " + v), (boolean)v.isInteger());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeFloat1() {
        NodeValue v = NodeValue.makeNode("57.0", XSDDatatype.XSDfloat);
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not a float: " + v), (boolean)v.isFloat());
        Assert.assertTrue((String)("Not a double(float): " + v), (boolean)v.isDouble());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        Assert.assertEquals((String)"Print form mismatch", (Object)("\"57.0\"^^<" + XSDDatatype.XSDfloat.getURI() + ">"), (Object)actualStr);
    }

    @Test
    public void testNodeDouble1() {
        NodeValue v = NodeValue.makeNode("57.0e0", XSDDatatype.XSDdouble);
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        Assert.assertEquals((String)"Print form mismatch", (Object)"57.0e0", (Object)actualStr);
    }

    @Test
    public void testNodeDouble2() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDdouble);
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        Assert.assertEquals((String)"Print form mismatch", (Object)("\"57\"^^<" + XSDDatatype.XSDdouble.getURI() + ">"), (Object)actualStr);
    }

    @Test
    public void testNodeDouble3() {
        NodeValue v = NodeValue.makeNode("057.0e0", XSDDatatype.XSDdouble);
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        Assert.assertEquals((String)"Print form mismatch", (Object)"057.0e0", (Object)actualStr);
    }

    @Test
    public void testNodeDouble4() {
        NodeValue v = NodeValue.makeNode(" 057.0e0 ", XSDDatatype.XSDdouble);
        Assert.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        Assert.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeBool1() {
        NodeValue v = NodeValue.makeNode("true", XSDDatatype.XSDboolean);
        Assert.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        Assert.assertTrue((String)("Not satisfied: " + v), (boolean)v.getBoolean());
    }

    @Test
    public void testNodeBool2() {
        NodeValue v = NodeValue.makeNode("false", XSDDatatype.XSDboolean);
        Assert.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        Assert.assertFalse((String)("Satisfied: " + v), (boolean)v.getBoolean());
    }

    @Test
    public void testNodeBool3() {
        NodeValue v = NodeValue.makeBoolean(true);
        Assert.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        Assert.assertTrue((String)("Not true: " + v), (boolean)v.getBoolean());
        Assert.assertTrue((String)("Not true: " + v), (boolean)XSDFuncOp.booleanEffectiveValue(v));
    }

    @Test
    public void testNodeBool4() {
        NodeValue v = NodeValue.makeBoolean(false);
        Assert.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        Assert.assertFalse((String)("Not false: " + v), (boolean)v.getBoolean());
        Assert.assertFalse((String)("Not false: " + v), (boolean)XSDFuncOp.booleanEffectiveValue(v));
    }

    static NodeValue make(String str2) {
        Node n = NodeFactoryExtra.parseNode(str2);
        NodeValue nv = NodeValue.makeNode(n);
        return nv;
    }

    @Test
    public void gregorian_01() {
        NodeValue nv = TestNodeValue.make("'1999'^^xsd:gYear");
        Assert.assertTrue((boolean)nv.isGYear());
        Assert.assertFalse((boolean)nv.isGYearMonth());
        Assert.assertFalse((boolean)nv.isGMonth());
        Assert.assertFalse((boolean)nv.isGMonthDay());
        Assert.assertFalse((boolean)nv.isGDay());
    }

    @Test
    public void gregorian_02() {
        NodeValue nv = TestNodeValue.make("'1999-01'^^xsd:gYearMonth");
        Assert.assertFalse((boolean)nv.isGYear());
        Assert.assertTrue((boolean)nv.isGYearMonth());
        Assert.assertFalse((boolean)nv.isGMonth());
        Assert.assertFalse((boolean)nv.isGMonthDay());
        Assert.assertFalse((boolean)nv.isGDay());
    }

    @Test
    public void gregorian_03() {
        NodeValue nv = TestNodeValue.make("'--01'^^xsd:gMonth");
        Assert.assertFalse((boolean)nv.isGYear());
        Assert.assertFalse((boolean)nv.isGYearMonth());
        Assert.assertTrue((boolean)nv.isGMonth());
        Assert.assertFalse((boolean)nv.isGMonthDay());
        Assert.assertFalse((boolean)nv.isGDay());
    }

    @Test
    public void gregorian_04() {
        NodeValue nv = TestNodeValue.make("'--01-30'^^xsd:gMonthDay");
        Assert.assertFalse((boolean)nv.isGYear());
        Assert.assertFalse((boolean)nv.isGYearMonth());
        Assert.assertFalse((boolean)nv.isGMonth());
        Assert.assertTrue((boolean)nv.isGMonthDay());
        Assert.assertFalse((boolean)nv.isGDay());
    }

    @Test
    public void gregorian_05() {
        NodeValue nv = TestNodeValue.make("'---30'^^xsd:gDay");
        Assert.assertFalse((boolean)nv.isGYear());
        Assert.assertFalse((boolean)nv.isGYearMonth());
        Assert.assertFalse((boolean)nv.isGMonth());
        Assert.assertFalse((boolean)nv.isGMonthDay());
        Assert.assertTrue((boolean)nv.isGDay());
    }

    @Test
    public void langString_01() {
        NodeValue nv = TestNodeValue.make("''@en");
        Assert.assertFalse((boolean)nv.isString());
        Assert.assertTrue((boolean)nv.isLangString());
        Assert.assertEquals((Object)"en", (Object)nv.getLang());
        Assert.assertEquals((Object)"", (Object)nv.getString());
        Assert.assertEquals((Object)"", (Object)nv.asString());
    }

    @Test
    public void langString_02() {
        NodeValue nv = TestNodeValue.make("'not empty'@cy");
        Assert.assertFalse((boolean)nv.isString());
        Assert.assertTrue((boolean)nv.isLangString());
        Assert.assertEquals((Object)"cy", (Object)nv.getLang());
        Assert.assertEquals((Object)"not empty", (Object)nv.getString());
        Assert.assertEquals((Object)"not empty", (Object)nv.asString());
    }

    @Test
    public void testBadLexcial1() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNodeInteger("abc");
            Assert.assertFalse((String)("Good integer: " + v), (boolean)v.isInteger());
            Assert.assertFalse((String)("Good number: " + v), (boolean)v.isNumber());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    @Test
    public void testBadLexcial2() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNodeInteger("1.8");
            Assert.assertFalse((String)("Good integer: " + v), (boolean)v.isInteger());
            Assert.assertFalse((String)("Good number: " + v), (boolean)v.isNumber());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    @Test
    public void testBadLexcial3() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeDateTime("2005-10-34T00:00:01Z");
            Assert.assertFalse((String)("Good date: " + v), (boolean)v.isDateTime());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadLexcial4() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            String s = "2005-10-14T 09:30:23+01:00";
            NodeValue.VerboseWarnings = false;
            NodeValue v1 = NodeValue.makeDateTime(s);
            Assert.assertFalse((String)("Good date: " + v1), (boolean)v1.isDateTime());
            s = s.replaceAll(" ", "");
            NodeValue v2 = NodeValue.makeDateTime(s);
            Assert.assertTrue((String)("Bad date: " + v2), (boolean)v2.isDateTime());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    @Test
    public void testEBV1() {
        Assert.assertTrue((String)"Not a boolean", (boolean)NodeValue.TRUE.isBoolean());
        Assert.assertTrue((String)"Not true", (boolean)NodeValue.TRUE.getBoolean());
        Assert.assertTrue((String)"Not true", (boolean)XSDFuncOp.booleanEffectiveValue(NodeValue.TRUE));
    }

    @Test
    public void testEBV2() {
        Assert.assertTrue((String)"Not a boolean", (boolean)NodeValue.FALSE.isBoolean());
        Assert.assertFalse((String)"Not false", (boolean)NodeValue.FALSE.getBoolean());
        Assert.assertFalse((String)"Not false", (boolean)XSDFuncOp.booleanEffectiveValue(NodeValue.FALSE));
    }

    @Test
    public void testEBV3() {
        NodeValue v = NodeValue.makeInteger(1L);
        Assert.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        Assert.assertTrue((String)("Not EBV true: " + v), (boolean)XSDFuncOp.booleanEffectiveValue(v));
    }

    @Test
    public void testEBV4() {
        NodeValue v = NodeValue.makeInteger(0L);
        Assert.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        try {
            v.getBoolean();
            Assert.fail((String)"getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        Assert.assertFalse((String)("Not EBV false: " + v), (boolean)XSDFuncOp.booleanEffectiveValue(v));
    }

    @Test
    public void testEBV5() {
        NodeValue v = NodeValue.makeString("xyz");
        Assert.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        try {
            v.getBoolean();
            Assert.fail((String)"getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Not EBV true: " + v), (boolean)XSDFuncOp.booleanEffectiveValue(v));
    }

    @Test
    public void testEBV6() {
        NodeValue v = NodeValue.makeString("");
        Assert.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        try {
            v.getBoolean();
            Assert.fail((String)"getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        Assert.assertFalse((String)("Not EBV false: " + v), (boolean)XSDFuncOp.booleanEffectiveValue(v));
    }

    @Test
    public void testEBV7() {
        Node x = NodeFactory.createLiteral("", "en");
        NodeValue v = NodeValue.makeNode(x);
        Assert.assertFalse((String)("Not EBV false: " + v), (boolean)XSDFuncOp.booleanEffectiveValue(v));
    }

    @Test
    public void testEBV8() {
        Node x = NodeFactory.createLiteral("not empty", "en");
        NodeValue v = NodeValue.makeNode(x);
        Assert.assertTrue((String)("Not EBV true: " + v), (boolean)XSDFuncOp.booleanEffectiveValue(v));
    }

    static boolean ebvDouble(double d) {
        return XSDFuncOp.booleanEffectiveValue(NodeValue.makeDouble(d));
    }

    @Test
    public void testEBV9() {
        Assert.assertTrue((boolean)TestNodeValue.ebvDouble(0.01));
        Assert.assertFalse((boolean)TestNodeValue.ebvDouble(0.0));
        Assert.assertFalse((boolean)TestNodeValue.ebvDouble(-0.0));
        Assert.assertFalse((boolean)TestNodeValue.ebvDouble(Double.NaN));
        Assert.assertTrue((boolean)TestNodeValue.ebvDouble(Double.MIN_NORMAL));
        Assert.assertTrue((boolean)TestNodeValue.ebvDouble(Double.MIN_VALUE));
        Assert.assertTrue((boolean)TestNodeValue.ebvDouble(Double.MAX_VALUE));
        Assert.assertTrue((boolean)TestNodeValue.ebvDouble(Double.POSITIVE_INFINITY));
        Assert.assertTrue((boolean)TestNodeValue.ebvDouble(Double.NEGATIVE_INFINITY));
        Node x = NodeFactory.createLiteral("NaN", XSDDatatype.XSDdouble);
        NodeValue v = NodeValue.makeNode(x);
        Assert.assertFalse((boolean)XSDFuncOp.booleanEffectiveValue(v));
    }

    static boolean ebvFloat(float f) {
        return XSDFuncOp.booleanEffectiveValue(NodeValue.makeFloat(f));
    }

    @Test
    public void testEBV10() {
        Assert.assertTrue((boolean)TestNodeValue.ebvFloat(0.01f));
        Assert.assertFalse((boolean)TestNodeValue.ebvFloat(0.0f));
        Assert.assertFalse((boolean)TestNodeValue.ebvFloat(-0.0f));
        Assert.assertFalse((boolean)TestNodeValue.ebvFloat(Float.NaN));
        Assert.assertTrue((boolean)TestNodeValue.ebvFloat(Float.MIN_NORMAL));
        Assert.assertTrue((boolean)TestNodeValue.ebvFloat(Float.MIN_VALUE));
        Assert.assertTrue((boolean)TestNodeValue.ebvFloat(Float.MAX_VALUE));
        Assert.assertTrue((boolean)TestNodeValue.ebvFloat(Float.POSITIVE_INFINITY));
        Assert.assertTrue((boolean)TestNodeValue.ebvFloat(Float.NEGATIVE_INFINITY));
        Node x = NodeFactory.createLiteral("NaN", XSDDatatype.XSDfloat);
        NodeValue v = NodeValue.makeNode(x);
        Assert.assertFalse((boolean)XSDFuncOp.booleanEffectiveValue(v));
    }

    private static boolean filterEBV(NodeValue nv) {
        try {
            return XSDFuncOp.booleanEffectiveValue(nv);
        }
        catch (ExprEvalException ex) {
            return false;
        }
    }

    @Test
    public void testFloatDouble1() {
        NodeValue v1 = NodeValue.makeNodeDouble("1.5");
        NodeValue v2 = NodeValue.makeNode("1.5", XSDDatatype.XSDfloat);
        Assert.assertTrue((String)"Should be equal: 1.5 float and 1.5 double", (boolean)NodeValue.sameAs(v1, v2));
    }

    @Test
    public void testFloatDouble5() {
        NodeValue v1 = NodeValue.makeNodeDouble("1.3");
        NodeValue v2 = NodeValue.makeNode("1.3", XSDDatatype.XSDfloat);
        Assert.assertFalse((String)"Should not be equal: 1.3 float and 1.3 double", (boolean)NodeValue.sameAs(v1, v2));
    }

    @Test
    public void testString1() {
        NodeValue v = NodeValue.makeString("string");
        Assert.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        Assert.assertFalse((String)("Is a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeString1() {
        NodeValue v = NodeValue.makeNode("string", null, (String)null);
        Assert.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    @Test
    public void testNodeString2() {
        NodeValue v = NodeValue.makeNode("string", null, (String)null);
        Assert.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        Assert.assertEquals((String)"Print form mismatch", (Object)"\"string\"", (Object)actualStr);
    }

    @Test
    public void testNodeString3() {
        NodeValue v = NodeValue.makeNode("string", XSDDatatype.XSDstring);
        Assert.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        Assert.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        String rightAnswer = JenaRuntime.isRDF11 ? "\"string\"" : "\"string\"^^<" + XSDDatatype.XSDstring.getURI() + ">";
        Assert.assertEquals((String)"Print form mismatch", (Object)rightAnswer, (Object)actualStr);
    }

    @Test
    public void testNodeSortKey1() {
        NodeValue nv = NodeValue.makeSortKey("Wagen", "de");
        Assert.assertTrue((String)("Not a sort key: " + nv), (boolean)nv.isSortKey());
        String actualStr = nv.asQuotedString();
        String rightAnswer = "\"Wagen\"";
        Assert.assertEquals((String)"Print form mismatch", (Object)rightAnswer, (Object)actualStr);
    }

    @Test
    public void testNodeSortKey2() {
        String[] unordered = new String[]{"Broager", "\u00c5kirkeby", "B\u00f8rkop", "\u00c6r\u00f8sk\u00f8bing", "Br\u00e6dstrup", "Wandsbek"};
        Object[] ordered = new String[]{"Broager", "Br\u00e6dstrup", "B\u00f8rkop", "Wandsbek", "\u00c6r\u00f8sk\u00f8bing", "\u00c5kirkeby"};
        String collation2 = "da";
        LinkedList<NodeValue> nodeValues = new LinkedList<NodeValue>();
        for (String string : unordered) {
            nodeValues.add(NodeValue.makeSortKey(string, "da"));
        }
        nodeValues.sort(new Comparator<NodeValue>(){

            @Override
            public int compare(NodeValue o1, NodeValue o2) {
                return NodeValue.compare(o1, o2);
            }
        });
        LinkedList<String> result = new LinkedList<String>();
        for (NodeValue nv : nodeValues) {
            String s = nv.getNode().getLiteralLexicalForm();
            result.add(s);
        }
        Assert.assertArrayEquals((Object[])ordered, (Object[])result.toArray(new String[0]));
    }

    @Test
    public void testNodeSortKey3() {
        String[] unordered = new String[]{"Broager", "\u00c5kirkeby", "B\u00f8rkop", "\u00c6r\u00f8sk\u00f8bing", "Br\u00e6dstrup", "Wandsbek"};
        Object[] ordered = new String[]{"\u00c6r\u00f8sk\u00f8bing", "\u00c5kirkeby", "Br\u00e6dstrup", "Broager", "B\u00f8rkop", "Wandsbek"};
        String collation2 = "en-NZ";
        LinkedList<NodeValue> nodeValues = new LinkedList<NodeValue>();
        for (String string : unordered) {
            nodeValues.add(NodeValue.makeSortKey(string, "en-NZ"));
        }
        nodeValues.sort(new Comparator<NodeValue>(){

            @Override
            public int compare(NodeValue o1, NodeValue o2) {
                return NodeValue.compare(o1, o2);
            }
        });
        LinkedList<String> result = new LinkedList<String>();
        for (NodeValue nv : nodeValues) {
            String s = nv.getNode().getLiteralLexicalForm();
            result.add(s);
        }
        Assert.assertArrayEquals((Object[])ordered, (Object[])result.toArray(new String[0]));
    }

    @Test
    public void testNodeSortKey4() {
        String collation2 = "fi";
        Object[] ordered = new String[]{"tsahurin kieli", "t\u0161ekin kieli", "tulun kieli", "t\u00f6yht\u00f6hyypp\u00e4"};
        String queryString = "PREFIX skos: <http://www.w3.org/2004/02/skos/core#>\nPREFIX arq: <http://jena.apache.org/ARQ/function#>\nSELECT ?label WHERE {\n   VALUES ?label { \"tulun kieli\"@es \"t\u0161ekin kieli\" \"tsahurin kieli\"@en \"t\u00f6yht\u00f6hyypp\u00e4\"@fi }\n}\nORDER BY arq:collation(\"fi\", ?label)";
        Model model = ModelFactory.createDefaultModel();
        Query query2 = QueryFactory.create("PREFIX skos: <http://www.w3.org/2004/02/skos/core#>\nPREFIX arq: <http://jena.apache.org/ARQ/function#>\nSELECT ?label WHERE {\n   VALUES ?label { \"tulun kieli\"@es \"t\u0161ekin kieli\" \"tsahurin kieli\"@en \"t\u00f6yht\u00f6hyypp\u00e4\"@fi }\n}\nORDER BY arq:collation(\"fi\", ?label)");
        LinkedList<String> result = new LinkedList<String>();
        try (QueryExecution qExec = QueryExecutionFactory.create(query2, model);){
            ResultSet results = qExec.execSelect();
            while (results.hasNext()) {
                QuerySolution solution = results.nextSolution();
                result.add(solution.getLiteral(solution.varNames().next()).getLexicalForm());
            }
        }
        Assert.assertArrayEquals((Object[])ordered, (Object[])result.toArray(new String[0]));
    }

    @Test
    public void testNodeSortKey5() {
        String collation2 = "en-BZ";
        Object[] ordered = new String[]{"t\u00f6yht\u00f6hyypp\u00e4", "tsahurin kieli", "t\u0161ekin kieli", "tulun kieli"};
        String queryString = "PREFIX skos: <http://www.w3.org/2004/02/skos/core#>\nPREFIX arq: <http://jena.apache.org/ARQ/function#>\nSELECT ?label WHERE {\n   VALUES ?label { \"tulun kieli\"@es \"t\u0161ekin kieli\" \"tsahurin kieli\"@en \"t\u00f6yht\u00f6hyypp\u00e4\"@fi }\n}\nORDER BY arq:collation(\"en-BZ\", ?label)";
        Model model = ModelFactory.createDefaultModel();
        Query query2 = QueryFactory.create("PREFIX skos: <http://www.w3.org/2004/02/skos/core#>\nPREFIX arq: <http://jena.apache.org/ARQ/function#>\nSELECT ?label WHERE {\n   VALUES ?label { \"tulun kieli\"@es \"t\u0161ekin kieli\" \"tsahurin kieli\"@en \"t\u00f6yht\u00f6hyypp\u00e4\"@fi }\n}\nORDER BY arq:collation(\"en-BZ\", ?label)");
        LinkedList<String> result = new LinkedList<String>();
        try (QueryExecution qExec = QueryExecutionFactory.create(query2, model);){
            ResultSet results = qExec.execSelect();
            while (results.hasNext()) {
                QuerySolution solution = results.nextSolution();
                result.add(solution.getLiteral(solution.varNames().next()).getLexicalForm());
            }
        }
        Assert.assertArrayEquals((Object[])ordered, (Object[])result.toArray(new String[0]));
    }

    @Test
    public void testSameValue1() {
        NodeValue nv1 = NodeValue.makeInteger(5L);
        NodeValue nv2 = NodeValue.makeInteger(7L);
        Assert.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs(nv1, nv2));
        Assert.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeInteger(5L);
        Assert.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs(nv1, nv3));
        Assert.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs(nv1, nv3));
    }

    @Test
    public void testSameValue2() {
        NodeValue nv1 = NodeValue.makeInteger(5L);
        NodeValue nv2 = NodeValue.makeNodeInteger(7L);
        Assert.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs(nv1, nv2));
        Assert.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeNodeInteger(5L);
        Assert.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs(nv1, nv3));
        Assert.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs(nv1, nv3));
    }

    @Test
    public void testSameValue3() {
        NodeValue nv1 = NodeValue.makeDecimal("1.5");
        NodeValue nv2 = NodeValue.makeDecimal("1.6");
        Assert.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs(nv1, nv2));
        Assert.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeDecimal("1.50");
        Assert.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs(nv1, nv3));
        Assert.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs(nv1, nv3));
    }

    @Test
    public void testSameValue4() {
        NodeValue nv1 = NodeValue.makeDecimal("3");
        NodeValue nv2 = NodeValue.makeInteger(4L);
        Assert.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs(nv1, nv2));
        Assert.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeInteger(3L);
        Assert.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs(nv1, nv3));
        Assert.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs(nv1, nv3));
    }

    @Test
    public void testSameValue5() {
        NodeValue nv1 = NodeValue.makeDecimal("-1.5");
        NodeValue nv2 = NodeValue.makeDouble(1.5);
        Assert.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs(nv1, nv2));
        Assert.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeDouble(-1.5);
        Assert.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs(nv1, nv3));
        Assert.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs(nv1, nv3));
    }

    @Test
    public void testSameValue6() {
        NodeValue nv1 = NodeValue.makeNodeInteger(17L);
        NodeValue nv2 = NodeValue.makeDouble(34.0);
        Assert.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs(nv1, nv2));
        Assert.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeDouble(17.0);
        Assert.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs(nv1, nv3));
        Assert.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs(nv1, nv3));
    }

    @Test
    public void testSameValue7() {
        NodeValue nv1 = NodeValue.makeBoolean(true);
        NodeValue nv2 = NodeValue.makeString("a");
        Assert.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs(nv1, nv2));
        Assert.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs(nv1, nv2));
        NodeValue nv3 = NodeValue.makeNodeBoolean(true);
        Assert.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs(nv1, nv3));
        Assert.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs(nv1, nv3));
    }

    @Test
    public void testLang1() {
        Node n1 = NodeFactory.createLiteral("xyz", "en");
        NodeValue nv1 = NodeValue.makeNode(n1);
        Node n2 = NodeFactory.createLiteral("xyz", "en");
        NodeValue nv2 = NodeValue.makeNode(n2);
        Assert.assertTrue((boolean)NodeValue.sameAs(nv1, nv2));
    }

    @Test
    public void testLang2() {
        Node n1 = NodeFactory.createLiteral("xyz", "en");
        NodeValue nv1 = NodeValue.makeNode(n1);
        Node n2 = NodeFactory.createLiteral("xyz", "EN");
        NodeValue nv2 = NodeValue.makeNode(n2);
        Assert.assertTrue((boolean)NodeValue.sameAs(nv1, nv2));
        Assert.assertFalse((boolean)nv1.equals(nv2));
    }

    @Test
    public void testLang3() {
        Node n1 = NodeFactory.createLiteral("xyz", "en");
        NodeValue nv1 = NodeValue.makeNode(n1);
        Node n2 = NodeFactory.createLiteral("xyz", "en");
        NodeValue nv2 = NodeValue.makeNode(n2);
        Assert.assertFalse((boolean)NodeValue.notSameAs(nv1, nv2));
    }

    @Test
    public void testLang4() {
        Node n1 = NodeFactory.createLiteral("xyz", "en");
        NodeValue nv1 = NodeValue.makeNode(n1);
        Node n2 = NodeFactory.createLiteral("xyz", "EN");
        NodeValue nv2 = NodeValue.makeNode(n2);
        Assert.assertFalse((boolean)NodeValue.notSameAs(nv1, nv2));
        Assert.assertFalse((boolean)nv1.equals(nv2));
    }

    @Test
    public void testEquals1() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeInteger(1L);
        Assert.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    @Test
    public void testEquals2() {
        NodeValue nv1 = NodeValue.makeNodeInteger(1L);
        NodeValue nv2 = NodeValue.makeInteger(1L);
        Assert.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    @Test
    public void testEquals3() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeNodeInteger(1L);
        Assert.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    @Test
    public void testEquals4() {
        NodeValue nv1 = NodeValue.makeNode(NodeFactory.createURI("http://example"));
        NodeValue nv2 = NodeValue.makeNode(NodeFactory.createURI("http://example"));
        Assert.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    @Test
    public void testNotEquals1() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeInteger(2L);
        Assert.assertFalse((String)"NodeValue.equals()", (boolean)nv1.equals(nv2));
    }

    @Test
    public void testNotEquals2() {
        NodeValue nv1 = NodeValue.makeNodeInteger(1L);
        NodeValue nv2 = NodeValue.makeNodeString("1");
        Assert.assertFalse((String)"NodeValue.equals()", (boolean)nv1.equals(nv2));
    }

    @Test
    public void testNotEquals3() {
        NodeValue nv1 = NodeValue.makeNode(NodeFactory.createURI("http://example"));
        NodeValue nv2 = NodeValue.makeNode(NodeFactory.createLiteral("http://example"));
        Assert.assertFalse((String)"NodeValue.equals()", (boolean)nv1.equals(nv2));
    }

    @Test
    public void testTripleTerms1() {
        Node n1 = SSE.parseNode("<<:s :p 123>>");
        Node n2 = SSE.parseNode("<<:s :p 456>>");
        NodeValue nv1 = NodeValue.makeNode(n1);
        NodeValue nv2 = NodeValue.makeNode(n2);
        int xa = NodeValue.compare(nv1, nv2);
        Assert.assertEquals((long)-1L, (long)xa);
        int xb = NodeValue.compare(nv2, nv1);
        Assert.assertEquals((long)1L, (long)xb);
    }

    @Test(expected=ExprNotComparableException.class)
    public void testTripleTerms2() {
        Node n1 = SSE.parseNode("<<:s :p 123>>");
        Node n2 = SSE.parseNode("<<:s :p 'abc'>>");
        NodeValue nv1 = NodeValue.makeNode(n1);
        NodeValue nv2 = NodeValue.makeNode(n2);
        NodeValue.compare(nv1, nv2);
    }

    @Test
    public void testTripleTerms3() {
        Node n1 = SSE.parseNode("<<:s :p 123>>");
        Node n2 = SSE.parseNode("<<:s :p 'abc'>>");
        NodeValue nv1 = NodeValue.makeNode(n1);
        NodeValue nv2 = NodeValue.makeNode(n2);
        int x = NodeValue.compareAlways(nv1, nv2);
        Assert.assertEquals((long)-1L, (long)x);
    }
}

