/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.JenaRuntime;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprTypeException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;
import org.junit.Assert;
import org.junit.Test;

public class TestNodeFunctions {
    private static final double accuracyExact = 0.0;
    private static final double accuracyClose = 1.0E-6;

    @Test
    public void testSameTerm1() {
        Node n1 = NodeFactory.createLiteral("xyz");
        Node n2 = NodeFactory.createLiteral("xyz");
        Assert.assertTrue((boolean)NodeFunctions.sameTerm(n1, n2));
    }

    @Test
    public void testSameTerm2() {
        Node n1 = NodeFactory.createLiteral("xyz");
        Node n2 = NodeFactory.createLiteral("abc");
        Assert.assertFalse((boolean)NodeFunctions.sameTerm(n1, n2));
    }

    @Test
    public void testSameTerm3() {
        Node n1 = NodeFactory.createLiteral("xyz");
        Node n2 = NodeFactory.createURI("xyz");
        Assert.assertFalse((boolean)NodeFunctions.sameTerm(n1, n2));
    }

    @Test
    public void testSameTerm4() {
        Node n1 = NodeFactory.createLiteral("xyz");
        Node n2 = NodeFactory.createLiteral("xyz", XSDDatatype.XSDstring);
        if (JenaRuntime.isRDF11) {
            Assert.assertTrue((boolean)NodeFunctions.sameTerm(n1, n2));
        } else {
            Assert.assertFalse((boolean)NodeFunctions.sameTerm(n1, n2));
        }
    }

    @Test
    public void testSameTerm5() {
        Node n1 = NodeFactory.createLiteral("xyz", "en");
        Node n2 = NodeFactory.createLiteral("xyz");
        Assert.assertFalse((boolean)NodeFunctions.sameTerm(n1, n2));
    }

    @Test
    public void testSameTerm6() {
        Node n1 = NodeFactory.createLiteral("xyz", "en");
        Node n2 = NodeFactory.createLiteral("xyz", "EN");
        Assert.assertTrue((boolean)NodeFunctions.sameTerm(n1, n2));
    }

    @Test
    public void testRDFtermEquals1() {
        Node n1 = NodeFactory.createURI("xyz");
        Node n2 = NodeFactory.createLiteral("xyz");
        Assert.assertFalse((boolean)NodeFunctions.rdfTermEquals(n1, n2));
    }

    @Test
    public void testRDFtermEquals2() {
        Node n1 = NodeFactory.createLiteral("xyz", "en");
        Node n2 = NodeFactory.createLiteral("xyz", "EN");
        Assert.assertTrue((boolean)NodeFunctions.rdfTermEquals(n1, n2));
    }

    @Test(expected=ExprEvalException.class)
    public void testRDFtermEquals3() {
        Node n1 = NodeFactory.createLiteral("xyz");
        Node n2 = NodeFactory.createLiteral("xyz", "en");
        NodeFunctions.rdfTermEquals(n1, n2);
    }

    @Test(expected=ExprEvalException.class)
    public void testRDFtermEquals4() {
        Node n1 = NodeFactory.createLiteral("123", XSDDatatype.XSDinteger);
        Node n2 = NodeFactory.createLiteral("456", XSDDatatype.XSDinteger);
        Assert.assertTrue((boolean)NodeFunctions.rdfTermEquals(n1, n2));
    }

    @Test
    public void testRDFtermEquals5() {
        Node n1 = SSE.parseNode("<<:s :p 123>>");
        Node n2 = SSE.parseNode("<<:s :p 123>>");
        Assert.assertTrue((boolean)NodeFunctions.rdfTermEquals(n1, n2));
    }

    @Test
    public void testRDFtermEquals6() {
        Node n1 = SSE.parseNode("<<:s :p1 123>>");
        Node n2 = SSE.parseNode("<<:s :p2 123>>");
        Assert.assertFalse((boolean)NodeFunctions.rdfTermEquals(n1, n2));
    }

    @Test(expected=ExprEvalException.class)
    public void testRDFtermEquals7() {
        Node n1 = SSE.parseNode("<<:s :p <<:a :b 'abc'>>>>");
        Node n2 = SSE.parseNode("<<:s :p <<:a :b 123>>>>");
        NodeFunctions.rdfTermEquals(n1, n2);
    }

    @Test(expected=ExprEvalException.class)
    public void testRDFtermEquals8() {
        Node n1 = SSE.parseNode("<<:s :p 123>>");
        Node n2 = SSE.parseNode("<<:s :p 'xyz'>>");
        Assert.assertFalse((boolean)NodeFunctions.rdfTermEquals(n1, n2));
        Assert.assertFalse((boolean)NodeFunctions.rdfTermEquals(n2, n1));
    }

    @Test
    public void testRDFtermEquals9() {
        Node n1 = SSE.parseNode("<<:s :p 123>>");
        Node n2 = SSE.parseNode("'xyz'");
        Assert.assertFalse((boolean)NodeFunctions.rdfTermEquals(n1, n2));
        Assert.assertFalse((boolean)NodeFunctions.rdfTermEquals(n2, n1));
    }

    @Test
    public void testStr1() {
        NodeValue nv = NodeValue.makeNodeInteger(56L);
        NodeValue s = NodeFunctions.str(nv);
        Assert.assertEquals((Object)"56", (Object)s.getString());
    }

    @Test
    public void testStr2() {
        NodeValue nv = NodeValue.makeInteger(56L);
        NodeValue s = NodeFunctions.str(nv);
        Assert.assertEquals((Object)"56", (Object)s.getString());
    }

    @Test
    public void testStr3() {
        NodeValue nv = NodeValue.makeNode("abc", "fr", (String)null);
        NodeValue s = NodeFunctions.str(nv);
        Assert.assertEquals((Object)"abc", (Object)s.getString());
    }

    @Test(expected=ExprTypeException.class)
    public void testStr4() {
        Node n = NodeFactory.createBlankNode();
        String s = NodeFunctions.str(n);
    }

    @Test
    public void testDatatype1() {
        NodeValue nv = NodeValue.makeInteger(5L);
        Node n = nv.asNode();
        Node r = NodeFunctions.datatype(n);
        Assert.assertEquals((Object)XSD.integer.asNode(), (Object)r);
    }

    @Test
    public void testDatatype2() {
        NodeValue nv = NodeValue.makeInteger(5L);
        NodeValue r = NodeFunctions.datatype(nv);
        NodeValue e2 = NodeValue.makeNode(XSD.integer.asNode());
        Assert.assertEquals((Object)e2, (Object)r);
    }

    @Test
    public void testDatatype3() {
        NodeValue nv = NodeValue.makeString("abc");
        NodeValue r = NodeFunctions.datatype(nv);
        NodeValue e2 = NodeValue.makeNode(XSD.xstring.asNode());
        Assert.assertEquals((Object)e2, (Object)r);
    }

    @Test
    public void testDatatype4() {
        NodeValue nv = NodeValue.makeNode("abc", "fr", (String)null);
        NodeValue r = NodeFunctions.datatype(nv);
        NodeValue e2 = NodeValue.makeNode(NodeConst.rdfLangString);
        Assert.assertEquals((Object)e2, (Object)r);
    }

    @Test(expected=ExprTypeException.class)
    public void testDatatype5() {
        NodeValue nv = NodeValue.makeNode(NodeFactory.createURI("http://example"));
        NodeValue r = NodeFunctions.datatype(nv);
    }

    @Test(expected=ExprTypeException.class)
    public void testDatatype6() {
        NodeValue nv = NodeValue.makeNode(NodeFactory.createBlankNode());
        NodeValue r = NodeFunctions.datatype(nv);
    }

    @Test
    public void testLang1() {
        Node n = NodeFactory.createLiteral("abc", "en-gb");
        Assert.assertEquals((Object)"en-gb", (Object)NodeFunctions.lang(n));
    }

    @Test
    public void testLang2() {
        NodeValue nv = NodeValue.makeNode("abc", "en", (String)null);
        NodeValue r = NodeFunctions.lang(nv);
        NodeValue e2 = NodeValue.makeString("en");
        Assert.assertEquals((Object)e2, (Object)r);
    }

    @Test
    public void testLang3() {
        NodeValue nv = NodeValue.makeInteger(5L);
        NodeValue r = NodeFunctions.lang(nv);
        NodeValue e2 = NodeValue.makeString("");
        Assert.assertEquals((Object)e2, (Object)r);
    }

    @Test
    public void testLang4() {
        NodeValue nv = NodeValue.makeNode(NodeFactory.createLiteral("simple"));
        NodeValue r = NodeFunctions.lang(nv);
        NodeValue e2 = NodeValue.makeString("");
        Assert.assertEquals((Object)e2, (Object)r);
    }

    @Test(expected=ExprTypeException.class)
    public void testLang5() {
        NodeValue nv = NodeValue.makeNode(NodeFactory.createURI("http://example/"));
        NodeValue r = NodeFunctions.lang(nv);
    }

    @Test
    public void testLangMatches1() {
        NodeValue nv = NodeValue.makeString("en");
        NodeValue pat = NodeValue.makeString("en");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
        Assert.assertFalse((boolean)NodeValue.FALSE.equals(r));
    }

    @Test
    public void testLangMatches2() {
        NodeValue nv = NodeValue.makeString("en");
        NodeValue pat = NodeValue.makeString("fr");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
        Assert.assertFalse((boolean)NodeValue.TRUE.equals(r));
    }

    @Test
    public void testLangMatches3() {
        NodeValue nv = NodeValue.makeString("en-gb");
        NodeValue pat = NodeValue.makeString("en-gb");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testLangMatches4() {
        NodeValue nv = NodeValue.makeString("en-gb");
        NodeValue pat = NodeValue.makeString("en");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testLangMatches5() {
        NodeValue nv = NodeValue.makeString("abc");
        NodeValue pat = NodeValue.makeString("*");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testLangMatches6() {
        NodeValue nv = NodeValue.makeString("x-y-z");
        NodeValue pat = NodeValue.makeString("x");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testLangMatches7() {
        NodeValue nv = NodeValue.makeString("x");
        NodeValue pat = NodeValue.makeString("x-y-z");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    @Test
    public void testLangMatches8() {
        NodeValue nv = NodeValue.makeString("");
        NodeValue pat = NodeValue.makeString("*");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    @Test
    public void testLangMatches9() {
        NodeValue nv = NodeValue.makeString("");
        NodeValue pat = NodeValue.makeString("");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testLangMatches10() {
        NodeValue nv = NodeValue.makeString("en");
        NodeValue pat = NodeValue.makeString("");
        NodeValue r = NodeFunctions.langMatches(nv, pat);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    @Test
    public void testIsIRI_1() {
        NodeValue nv = NodeValue.makeNode(NodeFactory.createURI("http://example/"));
        NodeValue r = NodeFunctions.isIRI(nv);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testIsIRI_2() {
        NodeValue nv = NodeValue.makeNode(NodeFactory.createLiteral("http://example/"));
        NodeValue r = NodeFunctions.isIRI(nv);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    @Test
    public void testIsBlank1() {
        NodeValue nv = NodeValue.makeNode(NodeFactory.createBlankNode());
        NodeValue r = NodeFunctions.isBlank(nv);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testIsBlank2() {
        NodeValue nv = NodeValue.makeNode(NodeFactory.createLiteral("xyz"));
        NodeValue r = NodeFunctions.isBlank(nv);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    @Test
    public void testIsBlank3() {
        NodeValue nv = NodeValue.makeNode(NodeFactory.createURI("http://example/"));
        NodeValue r = NodeFunctions.isBlank(nv);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    @Test
    public void testIsLiteral1() {
        NodeValue nv = NodeValue.makeNode(NodeFactory.createLiteral("xyz"));
        NodeValue r = NodeFunctions.isLiteral(nv);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testIsLiteral2() {
        NodeValue nv = NodeValue.makeNode(NodeFactory.createURI("http://example/"));
        NodeValue r = NodeFunctions.isLiteral(nv);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    @Test
    public void testCheckAndGetStringLiteral1() {
        NodeValue nv = NodeValue.makeNode("abc", XSDDatatype.XSDstring);
        Node n = NodeFunctions.checkAndGetStringLiteral("Test", nv);
        Assert.assertEquals((Object)"abc", (Object)n.getLiteralLexicalForm());
    }

    @Test
    public void testCheckAndGetStringLiteral2() {
        NodeValue nv = NodeValue.makeNode("abc", XSDDatatype.XSDnormalizedString);
        Node n = NodeFunctions.checkAndGetStringLiteral("Test", nv);
        Assert.assertEquals((Object)"abc", (Object)n.getLiteralLexicalForm());
    }

    @Test
    public void testCheckAndGetStringLiteral3() {
        NodeValue nv = NodeValue.makeString("abc");
        Node n = NodeFunctions.checkAndGetStringLiteral("Test", nv);
        Assert.assertEquals((Object)"abc", (Object)n.getLiteralLexicalForm());
    }

    @Test(expected=ExprEvalException.class)
    public void testCheckAndGetStringLiteral4() {
        NodeValue nv = NodeValue.makeNode("abc", RDF.dtLangString);
        Node n = NodeFunctions.checkAndGetStringLiteral("Test", nv);
        Assert.assertEquals((Object)"abc", (Object)n.getLiteralLexicalForm());
    }
}

