/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.LibTestExpr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderBinding;
import org.apache.jena.sparql.util.ExprUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestExpressions3 {
    @Test
    public void bound_01() {
        TestExpressions3.eval("BOUND(?x)", "(?x 1)", true);
    }

    @Test
    public void bound_02() {
        TestExpressions3.eval("BOUND(?x)", "(?y 1)", false);
    }

    @Test
    public void bound_03() {
        TestExpressions3.evalExpr("(bound 1)", "(?y 1)", true);
    }

    @Test
    public void bound_04() {
        TestExpressions3.evalExpr("(bound 1)", "()", true);
    }

    @Test
    public void bound_05() {
        TestExpressions3.evalExpr("(bound ?x)", "(?y 1)", false);
    }

    @Test
    public void bound_06() {
        TestExpressions3.evalExpr("(bound ?x)", "(?x 1)", true);
    }

    @Test
    public void bound_07() {
        TestExpressions3.evalExpr("(bound (+ ?x 1))", "(?y 1)", false);
    }

    @Test
    public void bound_08() {
        TestExpressions3.evalExpr("(bound (+ ?y 1))", "(?y 1)", true);
    }

    private static void eval(String string, String bindingStr, boolean expected) {
        Binding binding = TestExpressions3.binding(bindingStr);
        Expr expr = ExprUtils.parse(string);
        NodeValue nv = expr.eval(binding, LibTestExpr.createTest());
        boolean b = XSDFuncOp.booleanEffectiveValue(nv);
        Assert.assertEquals((String)string, (Object)expected, (Object)b);
    }

    private static void evalExpr(String exprString, String bindingStr, boolean expected) {
        Binding binding = TestExpressions3.binding(bindingStr);
        Expr expr = SSE.parseExpr(exprString);
        NodeValue nv = expr.eval(binding, LibTestExpr.createTest());
        boolean b = XSDFuncOp.booleanEffectiveValue(nv);
        Assert.assertEquals((String)exprString, (Object)expected, (Object)b);
    }

    private static Binding binding(String bindingStr) {
        if (bindingStr == null || bindingStr.matches("\\s*\\(\\s*\\)\\s*")) {
            return null;
        }
        Item item = SSE.parse("(binding " + bindingStr + ")");
        Binding binding = BuilderBinding.build(item);
        return binding;
    }
}

