/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.util.ExprUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestExprLib {
    @Test
    public void safeEqualityNot_01() {
        TestExprLib.testSafeEquality("123", false);
    }

    @Test
    public void safeEqualityNot_02() {
        TestExprLib.testSafeEquality("?x != <y>", false);
    }

    @Test
    public void safeEqualityNot_03() {
        TestExprLib.testSafeEquality("<x> = <y>", false);
    }

    @Test
    public void safeSameTerm_01() {
        TestExprLib.testSafeEquality("sameTerm(?x, <x>)", true);
    }

    @Test
    public void safeSameTerm_02() {
        TestExprLib.testSafeEquality("sameTerm(<x>, ?x)", true);
    }

    @Test
    public void safeSameTerm_03() {
        TestExprLib.testSafeEquality("sameTerm(?x, 'xyz')", false, true, true);
    }

    @Test
    public void safeSameTerm_04() {
        TestExprLib.testSafeEquality("sameTerm(?x, 'xyz')", true, false, false);
    }

    @Test
    public void safeSameTerm_05() {
        TestExprLib.testSafeEquality("sameTerm(?x, 'xyz'^^xsd:string)", false, true, true);
    }

    @Test
    public void safeSameTerm_06() {
        TestExprLib.testSafeEquality("sameTerm(?x, 'xyz'^^xsd:string)", true, false, false);
    }

    @Test
    public void safeSameTerm_07() {
        TestExprLib.testSafeEquality("sameTerm(?x, 'xyz'@en)", true, true, true);
    }

    @Test
    public void safeSameTerm_08() {
        TestExprLib.testSafeEquality("sameTerm(?x, 'xyz'@en)", true, false, false);
    }

    @Test
    public void safeSameTerm_09() {
        TestExprLib.testSafeEquality("sameTerm(?x, 123)", false, true, true);
    }

    @Test
    public void safeSameTerm_10() {
        TestExprLib.testSafeEquality("sameTerm(?x, 123)", true, false, false);
    }

    @Test
    public void safeSameTerm_11() {
        TestExprLib.testSafeEquality("sameTerm(?x, 'foo'^^<http://example>)", true, false, false);
    }

    @Test
    public void safeSameTerm_12() {
        TestExprLib.testSafeEquality("sameTerm(?x, 'foo'^^<http://example>)", true, true, true);
    }

    @Test
    public void safeEquality_01() {
        TestExprLib.testSafeEquality("?x = <x>", true);
    }

    @Test
    public void safeEquality_02() {
        TestExprLib.testSafeEquality("<x> = ?x", true);
    }

    @Test
    public void safeEquality_03() {
        TestExprLib.testSafeEquality("?x = 'xyz'", true, true, true);
    }

    @Test
    public void safeEquality_04() {
        TestExprLib.testSafeEquality("?x = 'xyz'", false, false, true);
    }

    @Test
    public void safeEquality_05() {
        TestExprLib.testSafeEquality("?x = 'xyz'^^xsd:string", true, true, true);
    }

    @Test
    public void safeEquality_06() {
        TestExprLib.testSafeEquality("?x = 'xyz'^^xsd:string", false, false, true);
    }

    @Test
    public void safeEquality_07() {
        TestExprLib.testSafeEquality("?x = 'xyz'@en", true, true, true);
    }

    @Test
    public void safeEquality_08() {
        TestExprLib.testSafeEquality("?x = 'xyz'@en", true, false, false);
    }

    @Test
    public void safeEquality_09() {
        TestExprLib.testSafeEquality("?x = 123", true, true, true);
    }

    @Test
    public void safeEquality_10() {
        TestExprLib.testSafeEquality("?x = 123", false, true, false);
    }

    @Test
    public void safeEquality_11() {
        TestExprLib.testSafeEquality("?x = 'foo'^^<http://example>", true, false, false);
    }

    @Test
    public void safeEquality_12() {
        TestExprLib.testSafeEquality("?x = 'foo'^^<http://example>", true, true, true);
    }

    private static void testSafeEquality(String string, boolean b) {
        Expr expr = ExprUtils.parse(string);
        Assert.assertEquals((String)string, (Object)b, (Object)ExprLib.isAssignmentSafeEquality(expr));
    }

    private static void testSafeEquality(String string, boolean b, boolean graphString, boolean graphNumber) {
        Expr expr = ExprUtils.parse(string);
        Assert.assertEquals((String)string, (Object)b, (Object)ExprLib.isAssignmentSafeEquality(expr, graphString, graphNumber));
    }
}

