/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorFactory;
import org.apache.jena.sparql.expr.aggregate.AggCustom;
import org.apache.jena.sparql.expr.aggregate.AggregateRegistry;
import org.apache.jena.sparql.expr.aggregate.AggregatorFactory;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.sse.SSE;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestCustomAggregates {
    public static final String aggIRI = "http://example.test/agg";
    public static final String aggIRI2 = "http://example.test/aggUnRegistered";
    static AccumulatorFactory myAccumulatorFactory = new AccumulatorFactory(){

        @Override
        public Accumulator createAccumulator(AggCustom agg, boolean distinct) {
            return new MyAccumulator(agg, distinct);
        }
    };

    @BeforeClass
    public static void setup() {
        AggregateRegistry.register(aggIRI, myAccumulatorFactory, NodeConst.nodeMinusOne);
    }

    @AfterClass
    public static void clearup() {
        AggregateRegistry.unregister(aggIRI);
    }

    @Test
    public void customAgg_1() {
        Assert.assertTrue((boolean)AggregateRegistry.isRegistered(aggIRI));
    }

    @Test
    public void customAgg_2() {
        Assert.assertFalse((boolean)AggregateRegistry.isRegistered(aggIRI2));
    }

    @Test
    public void customAgg_10() {
        String qs = "SELECT (AGG <http://example.test/agg>(?o) AS ?x) {?s ?p ?o } GROUP BY ?s";
        Query q = QueryFactory.create(qs, Syntax.syntaxARQ);
        String qs2 = q.serialize(Syntax.syntaxARQ);
        Query q2 = QueryFactory.create(qs2, Syntax.syntaxARQ);
        Assert.assertEquals((Object)q, (Object)q2);
    }

    @Test
    public void customAgg_11() {
        String qs = "SELECT (<http://example.test/agg>(?o) AS ?x) {?s ?p ?o } GROUP BY ?s";
        Query q = QueryFactory.create(qs);
        String qs2 = q.serialize();
        Query q2 = QueryFactory.create(qs2);
        Assert.assertEquals((Object)q, (Object)q2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void customAgg_12() {
        LogCtl.setError(AggregatorFactory.class);
        try {
            String qs = "SELECT (AGG <http://example.test/aggUnRegistered>(?o) AS ?x) {?s ?p ?o } GROUP BY ?s";
            Query q = QueryFactory.create(qs, Syntax.syntaxARQ);
            String qs2 = q.serialize(Syntax.syntaxARQ);
            Query q2 = QueryFactory.create(qs2, Syntax.syntaxARQ);
            Assert.assertEquals((Object)q, (Object)q2);
        }
        finally {
            LogCtl.setInfo(AggregatorFactory.class);
        }
    }

    @Test
    public void customAgg_20() {
        Graph g = SSE.parseGraph("(graph (:s :p :o) (:s :p 1))");
        Model m = ModelFactory.createModelForGraph(g);
        String qs = "SELECT (<http://example.test/agg>(?o) AS ?x) {?s ?p ?o } GROUP BY ?s";
        Query q = QueryFactory.create(qs, Syntax.syntaxARQ);
        try (QueryExecution qExec = QueryExecutionFactory.create(q, m);){
            ResultSet rs = qExec.execSelect();
            QuerySolution soln = rs.nextSolution();
            Assert.assertFalse((boolean)rs.hasNext());
            int v = soln.getLiteral("x").getInt();
            Assert.assertEquals((long)1L, (long)v);
        }
    }

    @Test
    public void customAgg_21() {
        Graph g = SSE.parseGraph("(graph (:s :p :o) (:s :p 1))");
        Model m = ModelFactory.createModelForGraph(g);
        String qs = "SELECT (<http://example.test/agg>(?o) AS ?x) {?s ?p ?o FILTER (false) }";
        Query q = QueryFactory.create(qs, Syntax.syntaxARQ);
        try (QueryExecution qExec = QueryExecutionFactory.create(q, m);){
            ResultSet rs = qExec.execSelect();
            QuerySolution soln = rs.nextSolution();
            Assert.assertFalse((boolean)rs.hasNext());
            int v = soln.getLiteral("x").getInt();
            Assert.assertEquals((long)-1L, (long)v);
        }
    }

    @Test
    public void customAgg_22() {
        Graph g = SSE.parseGraph("(graph (:s :p :o) (:s :p 1))");
        Model m = ModelFactory.createModelForGraph(g);
        String qs = "SELECT (<http://example.test/agg>(?o) AS ?x) {?s ?p ?o FILTER (false) } GROUP BY ?s";
        Query q = QueryFactory.create(qs, Syntax.syntaxARQ);
        try (QueryExecution qExec = QueryExecutionFactory.create(q, m);){
            ResultSet rs = qExec.execSelect();
            Assert.assertFalse((boolean)rs.hasNext());
        }
    }

    @Test
    public void customAgg_23() {
        String qs = "SELECT (<http://example.test/agg>(?o) AS ?x) {?s ?p ?o }";
        Query q = QueryFactory.create(qs, Syntax.syntaxARQ);
        Op op = Algebra.compile(q);
        String x = StrUtils.strjoinNL("(project (?x)", "   (extend ((?x ?.0))", "       (group () ((?.0 (agg <http://example.test/agg> ?o)))", "         (bgp (triple ?s ?p ?o)))))");
        Op op2 = SSE.parseOp(x);
        Assert.assertEquals((Object)op2, (Object)op);
    }

    static class MyAccumulator
    implements Accumulator {
        int count = 0;
        private AggCustom agg;

        MyAccumulator(AggCustom agg, boolean ignored) {
            this.agg = agg;
        }

        @Override
        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            ExprList exprList = this.agg.getExprList();
            for (Expr expr : exprList) {
                try {
                    NodeValue nv = expr.eval(binding, functionEnv);
                    if (!nv.isLiteral()) continue;
                    ++this.count;
                }
                catch (ExprEvalException exprEvalException) {}
            }
        }

        @Override
        public NodeValue getValue() {
            return NodeValue.makeInteger(this.count);
        }
    }
}

