/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.function.Predicate;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.FunctionEnvBase;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.junit.Assert;

public class LibTestExpr {
    private static PrefixMapping pmap = new PrefixMappingImpl();

    public static void testExpr(String exprExpected, String expectedResult) {
        NodeValue actual = LibTestExpr.eval(exprExpected);
        NodeValue expected = LibTestExpr.eval(expectedResult);
        Assert.assertEquals((String)exprExpected, (Object)expected, (Object)actual);
    }

    public static Expr parse(String exprString) {
        return ExprUtils.parse(exprString, pmap);
    }

    public static FunctionEnv createTest() {
        Context cxt = ARQ.getContext().copy();
        cxt.set(ARQConstants.sysCurrentTime, NodeFactoryExtra.nowAsDateTime());
        return new FunctionEnvBase(cxt);
    }

    public static NodeValue eval(String exprString) {
        Expr expr = LibTestExpr.parse(exprString);
        NodeValue result = expr.eval(null, new FunctionEnvBase());
        return result;
    }

    public static void test(String exprStr, String exprStrExpected) {
        Expr expr = LibTestExpr.parse(exprStrExpected);
        NodeValue rExpected = expr.eval(null, LibTestExpr.createTest());
        LibTestExpr.test(exprStr, rExpected);
    }

    public static void testSSE(String functionExprStr, String exprStrExpected) {
        Expr expected = SSE.parseExpr(exprStrExpected);
        NodeValue vExpected = expected.eval(null, LibTestExpr.createTest());
        Expr actual = SSE.parseExpr(functionExprStr);
        NodeValue vActual = expected.eval(null, LibTestExpr.createTest());
        Assert.assertTrue((String)("Expected = " + expected + " : Actual = " + actual), (boolean)LibTestExpr.sameValueSameDatatype(vExpected, vActual));
    }

    public static void test(String exprString, Node result) {
        NodeValue expected = NodeValue.makeNode(result);
        LibTestExpr.test(exprString, expected);
    }

    public static void test(String exprStr, NodeValue expected) {
        Expr expr = LibTestExpr.parse(exprStr);
        NodeValue actual = expr.eval(null, LibTestExpr.createTest());
        Assert.assertTrue((String)("Expected = " + expected + " : Actual = " + actual), (boolean)LibTestExpr.sameValueSameDatatype(expected, actual));
    }

    private static boolean sameValueSameDatatype(NodeValue nv1, NodeValue nv2) {
        if (!NodeValue.sameAs(nv1, nv2)) {
            return false;
        }
        Node n1 = nv1.asNode();
        Node n2 = nv2.asNode();
        if (!n1.isLiteral() || !n2.isLiteral()) {
            return true;
        }
        return nv1.asNode().getLiteralDatatype().equals(nv2.asNode().getLiteralDatatype());
    }

    public static void test(String exprStr) {
        LibTestExpr.test(exprStr, NodeValue.TRUE);
    }

    public static void test(String exprStr, Predicate<NodeValue> test) {
        Expr expr = LibTestExpr.parse(exprStr);
        NodeValue r = expr.eval(null, LibTestExpr.createTest());
        Assert.assertTrue((String)exprStr, (boolean)test.test(r));
    }

    public static void testDouble(String exprString, String result, double delta) {
        Node r = NodeFactoryExtra.parseNode(result);
        LibTestExpr.testDouble(exprString, r, delta);
    }

    public static void testDouble(String exprString, Node result, double delta) {
        Expr expr = LibTestExpr.parse(exprString);
        NodeValue actual = expr.eval(null, new FunctionEnvBase());
        NodeValue expected = NodeValue.makeNode(result);
        if (NodeValue.sameAs(expected, actual)) {
            return;
        }
        LibTestExpr.testDouble(exprString, expected.getDouble(), delta);
    }

    public static void testDouble(String exprString, double expected, double delta) {
        Expr expr = ExprUtils.parse(exprString, pmap);
        NodeValue actual = expr.eval(null, new FunctionEnvBase());
        Assert.assertTrue((String)("Not a double: " + actual), (boolean)actual.isDouble());
        double result = actual.getDouble();
        if (Double.isInfinite(expected)) {
            Assert.assertTrue((String)("Expected INF: Got " + result), (boolean)Double.isInfinite(result));
            return;
        }
        if (Double.isNaN(expected)) {
            Assert.assertTrue((String)("Expected NaN: Got " + result), (boolean)Double.isNaN(result));
            return;
        }
        double difference = Math.abs(result - expected);
        Assert.assertTrue((String)("Values not within given delta " + delta + ": Expected = " + expected + " : Actual = " + actual), (difference <= delta ? 1 : 0) != 0);
    }

    public static void testError(String exprString) {
        Expr expr = ExprUtils.parse(exprString, pmap);
        expr.eval(null, new FunctionEnvBase());
    }

    static {
        pmap.setNsPrefixes(ARQConstants.getGlobalPrefixMap());
        pmap.setNsPrefix("lfn", "http://www.dotnetrdf.org/leviathan#");
    }
}

