/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.join.JoinKey;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.resultset.ResultSetCompare;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;

public abstract class AbstractTestJoin
extends Assert {
    protected static Table table0() {
        return AbstractTestJoin.parseTableInt("(table)");
    }

    protected static Table table1() {
        return AbstractTestJoin.parseTableInt("(table (row))");
    }

    protected static Table tableD1() {
        return AbstractTestJoin.parseTableInt("(table", "   (row (?a 1) (?b 2))", "   (row (?a 1) (?b 3))", "   (row (?a 1) (?b 2))", ")");
    }

    protected static Table tableD2() {
        return AbstractTestJoin.parseTableInt("(table", "   (row (?a 0) (?d 8))", "   (row (?a 1) (?c 9))", ")");
    }

    protected static Table tableD3() {
        return AbstractTestJoin.parseTableInt("(table", "   (row (?a 1) (?c 9) (?b 2))", "   (row (?a 1) (?c 9) (?b 3))", "   (row (?a 1) (?c 9) (?b 2))", ")");
    }

    protected static Table tableD3_LJ() {
        return AbstractTestJoin.parseTableInt("(table", "   (row (?d 8) (?a 0))", "   (row (?a 1) (?c 9) (?b 2))", "   (row (?a 1) (?c 9) (?b 3))", "   (row (?a 1) (?c 9) (?b 2))", ")");
    }

    protected static Table tableD4() {
        return AbstractTestJoin.parseTableInt("(table", "   (row (?a 1) (?b 2))", "   (row (?a 1) (?b 3))", "   (row (?a 4) (?b 4))", "   (row (?a 4) (?b 5))", ")");
    }

    protected static Table tableD5() {
        return AbstractTestJoin.parseTableInt("(table", "   (row (?a 4) (?c 4))", "   (row (?a 4) (?c 5))", "   (row (?a 6) (?c 5))", ")");
    }

    protected static Table tableD6() {
        return AbstractTestJoin.parseTableInt("(table", "   (row (?a 1) (?c 2))", "   (row (?a 1) (?c 3))", "   (row (?a 4) (?c 4))", "   (row (?a 4) (?c 5))", ")");
    }

    protected static Table tableD4x5() {
        return AbstractTestJoin.parseTableInt("(table", "   (row (?a 4) (?c 4) (?b 4))", "   (row (?a 4) (?c 4) (?b 5))", "   (row (?a 4) (?c 5) (?b 4))", "   (row (?a 4) (?c 5) (?b 5))", ")");
    }

    protected static Table tableD4x5_LJ() {
        return AbstractTestJoin.parseTableInt("(table", "   (row (?a 4) (?c 4) (?b 4))", "   (row (?a 4) (?c 4) (?b 5))", "   (row (?a 4) (?c 5) (?b 4))", "   (row (?a 4) (?c 5) (?b 5))", "   (row (?b 2) (?a 1))", "   (row (?b 3) (?a 1))", ")");
    }

    protected static Table tableD5x4_LJ() {
        return AbstractTestJoin.parseTableInt("(table", "   (row (?a 4) (?c 4) (?b 4))", "   (row (?a 4) (?c 4) (?b 5))", "   (row (?a 4) (?c 5) (?b 4))", "   (row (?a 4) (?c 5) (?b 5))", "   (row (?a 6) (?c 5))", ")");
    }

    protected static Table tableD4x6() {
        return AbstractTestJoin.parseTableInt("(table", "   (row (?a 1) (?c 2) (?b 2))", "   (row (?a 1) (?c 2) (?b 3))", "   (row (?a 1) (?c 3) (?b 2))", "   (row (?a 1) (?c 3) (?b 3))", "   (row (?a 4) (?c 4) (?b 4))", "   (row (?a 4) (?c 4) (?b 5))", "   (row (?a 4) (?c 5) (?b 4))", "   (row (?a 4) (?c 5) (?b 5))", ")");
    }

    protected static Table tableD8() {
        return AbstractTestJoin.parseTableInt("(table", "  (row (?x 10))", "  (row (?z 11))", ")");
    }

    protected static Table tableD8x2() {
        return AbstractTestJoin.parseTableInt("(table", "  (row (?a 0) (?d 8) (?z 11))", "  (row (?a 0) (?d 8) (?x 10))", "  (row (?a 1) (?c 9) (?z 11))", "  (row (?a 1) (?c 9) (?x 10))", ")");
    }

    protected static Table tableL1() {
        return AbstractTestJoin.parseTableInt("(table", "  (row (?a 0) (?d 8))", "  (row (?a 3) (?d 9))", ")");
    }

    protected static Table tableL2() {
        return AbstractTestJoin.parseTableInt("(table", "  (row (?a 0) (?z 11))", "  (row (?a 1) (?c 9) (?z 11))", ")");
    }

    protected static Table table1LJ2() {
        return AbstractTestJoin.parseTableInt("(table", "  (row (?a 0) (?d 8) (?z 11))", "  (row (?a 3) (?d 9))", ")");
    }

    protected static Table tableL4() {
        return AbstractTestJoin.parseTableInt("(table", "  (row (?a 0) (?z 11))", "  (row (?a 0) (?z 12))", "  (row               (?r 99))", "  (row        (?c 9) (?z 11))", ")");
    }

    protected static Table tableL5() {
        return AbstractTestJoin.parseTableInt("(table", "  (row (?a 0) (?d 8))", "  (row (?a 1) (?c 9) (?z 11))", ")");
    }

    protected static Table table4LJ5() {
        return AbstractTestJoin.parseTableInt("(table", "  (row (?a 0) (?d 8) (?z 11))", "  (row (?a 0) (?d 8) (?z 12))", "  (row (?a 0) (?d 8) (?r 99))", "  (row (?a 1) (?c 9) (?z 11) (?r 99))", "  (row (?a 0) (?d 8) (?c 9) (?z 11))", "  (row (?a 1) (?c 9) (?z 11))", ")");
    }

    protected static Table tableS1() {
        return AbstractTestJoin.parseTableInt("(table", "  (row (?z <http://example/z1>) (?x <http://example/x>) (?w 'w11-1'))", "  (row (?z <http://example/z4>) (?x <http://example/x>)))");
    }

    protected static Table tableS2() {
        return AbstractTestJoin.parseTableInt("(table (row (?x <http://example/x>) (?w <http://example/z1>)))");
    }

    protected static Table tableS1J2() {
        return AbstractTestJoin.parseTableInt("(table", "  (row (?z <http://example/z4>) (?x <http://example/x>) (?w <http://example/z1>) ))");
    }

    protected static Table parseTableInt(String ... strings) {
        String x = StrUtils.strjoinNL(strings);
        return SSE.parseTable(x);
    }

    protected void testJoin(String var, Table left, Table right, Table tableOut) {
        this.testJoin(var, left, right, null, tableOut);
    }

    protected void testJoin(String var, Table left, Table right, String conditions, Table tableOut) {
        JoinKey joinKey;
        if (var != null) {
            if (var.startsWith("?")) {
                var = var.substring(1);
            }
            joinKey = JoinKey.create(Var.alloc(var));
        } else {
            joinKey = null;
        }
        ExprList exprs = null;
        if (conditions != null) {
            exprs = SSE.parseExprList(conditions);
        }
        this.executeTest(joinKey, left, right, exprs, tableOut);
    }

    protected void testJoinWithKey(JoinKey joinKey, Table left, Table right, Table tableOut) {
        this.executeTest(joinKey, left, right, null, tableOut);
    }

    protected void testJoinWithKey(JoinKey joinKey, Table left, Table right, ExprList conditions, Table tableOut) {
        this.executeTest(joinKey, left, right, conditions, tableOut);
    }

    protected abstract void executeTest(JoinKey var1, Table var2, Table var3, ExprList var4, Table var5);

    private List<Binding> toList(Table table) {
        return Iter.toList(table.rows());
    }

    protected void executeTestJoin(String msg, JoinKey joinKey, Table left, Table right, ExprList conditions, Table expectedResults) {
        Table x1 = this.joinMaterialize(joinKey, left, right, conditions);
        AbstractTestJoin.assertNotNull((String)("Null table from join (" + msg + ")"), (Object)x1);
        AbstractTestJoin.check("Results not equal (" + msg + ")", joinKey, left, right, conditions, expectedResults, x1);
    }

    private Table joinMaterialize(JoinKey joinKey, Table left, Table right, ExprList conditions) {
        QueryIterator qIter = this.join(joinKey, left, right, conditions);
        return TableFactory.create(qIter);
    }

    public abstract QueryIterator join(JoinKey var1, Table var2, Table var3, ExprList var4);

    private static void check(String msg, JoinKey joinKey, Table left, Table right, ExprList conditions, Table expected, Table actual) {
        boolean b = AbstractTestJoin.equalTables(expected, actual);
        if (!b) {
            AbstractTestJoin.print(msg, joinKey, left, right, conditions, expected, actual);
        }
        AbstractTestJoin.assertTrue((String)msg, (boolean)b);
    }

    protected static void print(String msg, JoinKey joinKey, Table left, Table right, ExprList conditions, Table expected, Table actual) {
        System.err.flush();
        System.out.flush();
        IndentedWriter out = IndentedWriter.stderr;
        out.println("Test :    " + msg);
        out.println("Joinkey:  " + joinKey);
        AbstractTestJoin.print(out, "Left:", left);
        AbstractTestJoin.print(out, "Right:", right);
        if (conditions != null) {
            out.println("Conditions: " + conditions);
        }
        AbstractTestJoin.print(out, "Expected:", expected);
        AbstractTestJoin.print(out, "Actual:", actual);
        out.println();
        out.flush();
    }

    protected static void print(IndentedWriter out, String label, Table table) {
        out.println(label);
        out.incIndent();
        out.println(table.toString());
        out.decIndent();
    }

    private static boolean equalTables(Table table1, Table table2) {
        ResultSet rs1 = ResultSetFactory.create(table1.iterator(null), table1.getVarNames());
        ResultSet rs2 = ResultSetFactory.create(table2.iterator(null), table2.getVarNames());
        return ResultSetCompare.equalsByTerm(rs1, rs2);
    }
}

