/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.GraphPlain;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingComparator;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterSort;
import org.apache.jena.sparql.engine.iterator.QueryIteratorBase;
import org.apache.jena.sparql.engine.main.OpExecutor;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.Context;
import org.junit.Assert;
import org.junit.Test;

public class TestSortedDataBagCancellation {
    static final Binding b1 = BindingFactory.binding(Var.alloc("v1"), NodeFactory.createLiteral("alpha"));
    static final Binding b2 = BindingFactory.binding(Var.alloc("v2"), NodeFactory.createLiteral("beta"));
    static final Binding b3 = BindingFactory.binding(Var.alloc("v3"), NodeFactory.createLiteral("gamma"));
    static final Binding b4 = BindingFactory.binding(Var.alloc("v4"), NodeFactory.createLiteral("delta"));
    final Context params = new Context();
    final OpExecutorFactory factory = new OpExecutorFactory(){

        @Override
        public OpExecutor create(ExecutionContext ec) {
            throw new UnsupportedOperationException();
        }
    };
    final Graph activeGraph = GraphPlain.plain();
    final DatasetGraph dataset = DatasetGraphFactory.create();
    final List<SortCondition> conditions = new ArrayList<SortCondition>();
    final ExecutionContext ec = new ExecutionContext(this.params, this.activeGraph, this.dataset, this.factory);
    final BindingComparator base_bc = new BindingComparator(this.conditions, this.ec);
    final SpecialBindingComparator bc = new SpecialBindingComparator(this.base_bc, this.ec);
    QueryIteratorItems baseIter = new QueryIteratorItems();
    QueryIterSort qs;

    public TestSortedDataBagCancellation() {
        this.baseIter.bindings.add(b1);
        this.baseIter.bindings.add(b2);
        this.baseIter.bindings.add(b3);
        this.baseIter.bindings.add(b4);
        this.qs = new QueryIterSort((QueryIterator)this.baseIter, this.bc, this.ec);
    }

    @Test
    public void testIteratesToCompletion() {
        int count = 0;
        count = this.bc.count;
        Assert.assertEquals((long)0L, (long)count);
        HashSet<Binding> results = new HashSet<Binding>();
        Assert.assertTrue((boolean)this.qs.hasNext());
        Assert.assertTrue((this.bc.count >= count ? 1 : 0) != 0);
        count = this.bc.count;
        results.add(this.qs.next());
        Assert.assertTrue((boolean)this.qs.hasNext());
        Assert.assertTrue((this.bc.count >= count ? 1 : 0) != 0);
        count = this.bc.count;
        results.add(this.qs.next());
        Assert.assertTrue((boolean)this.qs.hasNext());
        Assert.assertTrue((this.bc.count >= count ? 1 : 0) != 0);
        count = this.bc.count;
        results.add(this.qs.next());
        Assert.assertTrue((boolean)this.qs.hasNext());
        Assert.assertTrue((this.bc.count >= count ? 1 : 0) != 0);
        count = this.bc.count;
        results.add(this.qs.next());
        Assert.assertFalse((boolean)this.qs.hasNext());
        HashSet<Binding> expected = new HashSet<Binding>();
        expected.add(b1);
        expected.add(b2);
        expected.add(b3);
        expected.add(b4);
        Assert.assertEquals(expected, results);
    }

    @Test
    public void testIteratesWithCancellation() {
        int count = 0;
        count = this.bc.count;
        Assert.assertEquals((long)0L, (long)count);
        HashSet<Binding> results = new HashSet<Binding>();
        Assert.assertTrue((boolean)this.qs.hasNext());
        Assert.assertTrue((this.bc.count >= count ? 1 : 0) != 0);
        count = this.bc.count;
        results.add(this.qs.next());
        this.qs.cancel();
        try {
            this.bc.noMoreCalls();
            while (this.qs.hasNext()) {
                this.qs.next();
            }
        }
        catch (QueryCancelledException qe) {
            Assert.assertTrue((boolean)this.qs.db.isCancelled());
            return;
        }
        Assert.fail((String)"query was not cancelled");
    }

    static class SpecialBindingComparator
    extends BindingComparator {
        final BindingComparator base;
        int count = 0;
        boolean trapCompare = false;

        public SpecialBindingComparator(BindingComparator base, ExecutionContext ec) {
            super(base.getConditions(), ec);
            this.base = base;
        }

        public void noMoreCalls() {
            this.trapCompare = true;
        }

        @Override
        public int compare(Binding x, Binding y) {
            if (this.trapCompare) {
                throw new RuntimeException("compare() no longer allowed.");
            }
            ++this.count;
            return this.base.compare(x, y);
        }
    }

    private static final class QueryIteratorItems
    extends QueryIteratorBase {
        List<Binding> bindings = new ArrayList<Binding>();
        int index = 0;

        private QueryIteratorItems() {
        }

        @Override
        public void output(IndentedWriter out, SerializationContext sCxt) {
            out.write("a QueryIteratorItems");
        }

        @Override
        protected boolean hasNextBinding() {
            return this.index < this.bindings.size();
        }

        @Override
        protected Binding moveToNextBinding() {
            ++this.index;
            return this.bindings.get(this.index - 1);
        }

        @Override
        protected void closeIterator() {
        }

        @Override
        protected void requestCancel() {
        }
    }
}

