/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.jena.atlas.data.DataBagExaminer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.SortCondition;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQNotImplemented;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingComparator;
import org.apache.jena.sparql.engine.iterator.QueryIterSort;
import org.apache.jena.sparql.engine.iterator.QueryIterTopN;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.Context;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQueryIterSort {
    private static final String LETTERS = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM";
    private Random random;
    private List<Binding> unsorted;
    private BindingComparator comparator;
    private CallbackIterator iterator;

    @Before
    public void setup() {
        this.random = new Random();
        Var[] vars = new Var[]{Var.alloc("1"), Var.alloc("2"), Var.alloc("3"), Var.alloc("4"), Var.alloc("5"), Var.alloc("6"), Var.alloc("7"), Var.alloc("8"), Var.alloc("9"), Var.alloc("0")};
        this.unsorted = new ArrayList<Binding>();
        for (int i = 0; i < 500; ++i) {
            this.unsorted.add(this.randomBinding(vars));
        }
        ArrayList<SortCondition> conditions = new ArrayList<SortCondition>();
        conditions.add(new SortCondition(new ExprVar("8"), 1));
        this.comparator = new BindingComparator(conditions);
        this.iterator = new CallbackIterator(this.unsorted.iterator(), 25, null);
        this.iterator.setCallback(new Callback(){

            @Override
            public void call() {
                throw new QueryCancelledException();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoSpill() {
        this.iterator.setCallback(() -> {});
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context2 = new Context();
        ExecutionContext executionContext = new ExecutionContext(context2, null, null, null);
        try (QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, this.comparator, executionContext);){
            Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.hasNext();
            Assert.assertEquals((long)500L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanAfterClose() {
        this.iterator.setCallback(() -> {});
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context2 = new Context();
        context2.set(ARQ.spillToDiskThreshold, 10L);
        ExecutionContext executionContext = new ExecutionContext(context2, null, null, null);
        try (QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, this.comparator, executionContext);){
            Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.hasNext();
            Assert.assertEquals((long)500L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)49L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
        }
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
    }

    @Test
    public void testCloseClosesSourceIterator() {
        Context context2 = new Context();
        ExecutionContext ec = new ExecutionContext(context2, null, null, null);
        QueryIterSort qis = new QueryIterSort((QueryIterator)this.iterator, this.comparator, ec);
        qis.close();
        Assert.assertTrue((String)"source iterator should have been closed", (boolean)this.iterator.isClosed());
    }

    @Test
    public void testExhaustionClosesSourceIterator() {
        this.iterator.setCallback(() -> {});
        Context context2 = new Context();
        ExecutionContext ec = new ExecutionContext(context2, null, null, null);
        QueryIterSort qis = new QueryIterSort((QueryIterator)this.iterator, this.comparator, ec);
        while (qis.hasNext()) {
            qis.next();
        }
        Assert.assertTrue((String)"source iterator should have been closed", (boolean)this.iterator.isClosed());
    }

    @Test
    public void testCancelClosesSourceIterator() {
        Context context2 = new Context();
        ExecutionContext ec = new ExecutionContext(context2, null, null, null);
        QueryIterSort qis = new QueryIterSort((QueryIterator)this.iterator, this.comparator, ec);
        try {
            while (qis.hasNext()) {
                qis.next();
            }
            Assert.fail((String)"query should have been cancelled by trigger");
        }
        catch (QueryCancelledException q) {
            Assert.assertTrue((String)"source iterator should have been closed", (boolean)this.iterator.isClosed());
        }
    }

    @Test
    public void testCleanAfterExhaustion() {
        this.iterator.setCallback(() -> {});
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context2 = new Context();
        context2.set(ARQ.spillToDiskThreshold, 10L);
        ExecutionContext executionContext = new ExecutionContext(context2, null, null, null);
        QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, this.comparator, executionContext);
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
        qIter.hasNext();
        Assert.assertEquals((long)500L, (long)this.iterator.getReturnedElementCount());
        Assert.assertEquals((long)49L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
        while (qIter.hasNext()) {
            qIter.next();
        }
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
        qIter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=QueryCancelledException.class)
    public void testCancelInterruptsInitialisation() {
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context2 = new Context();
        context2.set(ARQ.spillToDiskThreshold, 10L);
        ExecutionContext executionContext = new ExecutionContext(context2, null, null, null);
        QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, this.comparator, executionContext);
        try {
            Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.cancel();
            qIter.hasNext();
        }
        finally {
            Assert.assertTrue((boolean)this.iterator.isCanceled());
            Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.close();
        }
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
    }

    @Test(expected=QueryCancelledException.class)
    public void testCancelInterruptsExternalSortAfterStartingIteration() {
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context2 = new Context();
        context2.set(ARQ.spillToDiskThreshold, 10L);
        ExecutionContext executionContext = new ExecutionContext(context2, null, null, null);
        try (QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, this.comparator, executionContext);){
            Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.hasNext();
        }
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=QueryCancelledException.class)
    public void testCancelInterruptsExternalSortAtStartOfIteration() {
        this.iterator = new CallbackIterator(this.unsorted.iterator(), 25, null);
        this.iterator.setCallback(() -> {});
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context2 = new Context();
        context2.set(ARQ.spillToDiskThreshold, 10L);
        ExecutionContext executionContext = new ExecutionContext(context2, null, null, null);
        QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, this.comparator, executionContext);
        try {
            Assert.assertTrue((boolean)qIter.hasNext());
            Assert.assertEquals((long)49L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            Assert.assertNotNull((Object)qIter.next());
            Assert.assertTrue((boolean)qIter.hasNext());
            qIter.cancel();
            qIter.hasNext();
        }
        finally {
            Assert.assertEquals((long)500L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.close();
        }
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
    }

    @Test
    public void testTopNCloseClosesSource() {
        long numItems = 3L;
        boolean distinct = false;
        Context context2 = new Context();
        ExecutionContext ec = new ExecutionContext(context2, null, null, null);
        QueryIterTopN tn = new QueryIterTopN((QueryIterator)this.iterator, this.comparator, numItems, distinct, ec);
        tn.close();
        Assert.assertTrue((boolean)this.iterator.isClosed());
    }

    @Test
    public void testTopNExhaustionClosesSource() {
        this.iterator.setCallback(() -> {});
        long numItems = 3L;
        boolean distinct = false;
        Context context2 = new Context();
        ExecutionContext ec = new ExecutionContext(context2, null, null, null);
        QueryIterTopN tn = new QueryIterTopN((QueryIterator)this.iterator, this.comparator, numItems, distinct, ec);
        while (tn.hasNext()) {
            tn.next();
        }
        Assert.assertTrue((boolean)this.iterator.isClosed());
    }

    private Binding randomBinding(Var[] vars) {
        BindingBuilder builder = Binding.builder();
        builder.add(vars[0], NodeFactory.createBlankNode());
        builder.add(vars[1], NodeFactory.createURI(this.randomURI()));
        builder.add(vars[2], NodeFactory.createURI(this.randomURI()));
        builder.add(vars[3], NodeFactory.createLiteral(this.randomString(20)));
        builder.add(vars[4], NodeFactory.createBlankNode());
        builder.add(vars[5], NodeFactory.createURI(this.randomURI()));
        builder.add(vars[6], NodeFactory.createURI(this.randomURI()));
        builder.add(vars[7], NodeFactory.createLiteral(this.randomString(5)));
        builder.add(vars[8], NodeFactory.createLiteral("" + this.random.nextInt(), XSDDatatype.XSDinteger));
        builder.add(vars[9], NodeFactory.createBlankNode());
        return builder.build();
    }

    private String randomURI() {
        return String.format("http://%s.example.com/%s", this.randomString(10), this.randomString(10));
    }

    private String randomString(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(LETTERS.charAt(this.random.nextInt(LETTERS.length())));
        }
        return builder.toString();
    }

    public static interface Callback {
        public void call();
    }

    private static class CallbackIterator
    implements QueryIterator {
        int elementsReturned = 0;
        Callback callback;
        int trigger;
        Iterator<Binding> delegate;
        boolean canceled = false;
        boolean closed = false;

        public CallbackIterator(Iterator<Binding> delegate, int trigger, Callback callback) {
            this.delegate = delegate;
            this.callback = callback;
            this.trigger = trigger;
        }

        public void setCallback(Callback callback) {
            this.callback = callback;
        }

        @Override
        public boolean hasNext() {
            boolean has = this.delegate.hasNext();
            if (!has) {
                this.closed = true;
            }
            return has;
        }

        @Override
        public Binding next() {
            if (this.elementsReturned++ >= this.trigger) {
                this.callback.call();
            }
            return this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        public int getReturnedElementCount() {
            return this.elementsReturned;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        @Override
        public Binding nextBinding() {
            if (this.elementsReturned++ >= this.trigger) {
                this.callback.call();
            }
            return this.delegate.next();
        }

        @Override
        public void cancel() {
            this.canceled = true;
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public void output(IndentedWriter out, SerializationContext sCxt) {
            throw new ARQNotImplemented();
        }

        @Override
        public String toString(PrefixMapping pmap) {
            throw new ARQNotImplemented();
        }

        @Override
        public void output(IndentedWriter out) {
            throw new ARQNotImplemented();
        }
    }
}

