/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.index;

import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphZero;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.engine.main.QueryEngineMain;
import org.apache.jena.sparql.engine.ref.QueryEngineRef;
import org.junit.Assert;
import org.junit.Test;

public class TestMinus {
    private static DatasetGraph dsgzero = new DatasetGraphZero();

    @Test
    public void minus_x1() {
        String x1 = StrUtils.strjoinNL("SELECT ?x ?undef {", "  VALUES ( ?x ?undef ) { ( 3 UNDEF ) ( 2 UNDEF ) }", "  MINUS {", "     BIND(2 AS ?x)", "     BIND(1 AS ?undef)", "  }", "}");
        this.test(x1);
    }

    @Test
    public void minus_x2() {
        String x2 = StrUtils.strjoinNL("SELECT ?x ?undef {", "  VALUES ( ?x ?undef ) { ( 99 UNDEF ) }", "  MINUS {", "     BIND(1 AS ?undef)", "  }", "}");
        this.test(x2);
    }

    @Test
    public void minus_x3() {
        String x3 = StrUtils.strjoinNL("SELECT ?x ?undef {", "  VALUES ( ?x ) { ( 3 ) }", "  MINUS {", "     BIND(2 AS ?x)", "     BIND(1 AS ?undef)", "  }", "}");
        this.test(x3);
    }

    private void test(String queryStr) {
        Query ast = QueryFactory.create(queryStr);
        List<Binding> x1 = TestMinus.exec(queryStr, QueryEngineRef.getFactory());
        List<Binding> x2 = TestMinus.exec(queryStr, QueryEngineMain.getFactory());
        boolean b = ListUtils.equalsUnordered(x1, x2);
        Assert.assertTrue((String)"Ref != main", (boolean)b);
    }

    private static List<Binding> exec(String queryStr, QueryEngineFactory factory) {
        Query ast = QueryFactory.create(queryStr);
        return Iter.toList(factory.create(ast, dsgzero, BindingRoot.create(), ARQ.getContext()).iterator());
    }
}

