/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.reasoner.rulesys.Util;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.index.HashIndexTable;
import org.apache.jena.sparql.engine.index.IndexFactory;
import org.apache.jena.sparql.engine.index.IndexTable;
import org.apache.jena.sparql.engine.index.LinearIndex;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestIndexTable {
    private Var[] vars;
    private Set<Var> order1;
    private Set<Var> order2;
    private List<Binding> fData;
    private List<Binding> pData;

    @Before
    public void setup() {
        int i;
        this.vars = new Var[]{Var.alloc("a"), Var.alloc("b"), Var.alloc("c")};
        this.order1 = new LinkedHashSet<Var>();
        this.order2 = new LinkedHashSet<Var>();
        for (i = 0; i < this.vars.length; ++i) {
            this.order1.add(this.vars[i]);
            this.order2.add(this.vars[this.vars.length - i - 1]);
        }
        this.fData = new ArrayList<Binding>();
        this.pData = new ArrayList<Binding>();
        for (i = 10; i <= 100; i += 10) {
            BindingBuilder bindingFull = Binding.builder();
            BindingBuilder bindingPart = Binding.builder();
            for (int b = 0; b < this.vars.length; ++b) {
                bindingFull.add(this.vars[b], Util.makeIntNode(i + b));
                if ((i + b) % 7 == 0) continue;
                bindingPart.add(this.vars[b], Util.makeIntNode(i + b));
            }
            this.fData.add(bindingFull.build());
            this.pData.add(bindingPart.build());
        }
    }

    @Test
    public void testHashIndexTableConstruction() throws Exception {
        new HashIndexTable(this.order1, this.fullData());
        Assert.assertTrue((boolean)(IndexFactory.createIndex(this.order1, this.fullData()) instanceof HashIndexTable));
        Assert.assertTrue((boolean)(IndexFactory.createIndex(this.order1, this.partData()) instanceof LinearIndex));
        try {
            new HashIndexTable(this.order1, this.partData());
            Assert.fail((String)"Index built without failure on partial bindings");
        }
        catch (HashIndexTable.MissingBindingException e2) {
            Map<Var, Integer> map = e2.getMap();
            for (int i = 0; i < this.vars.length; ++i) {
                Assert.assertEquals((Object)i, (Object)map.get(this.vars[i]));
            }
            Set<HashIndexTable.Key> data = e2.getData();
            Assert.assertEquals((long)2L, (long)data.size());
            for (HashIndexTable.Key key : data) {
                Binding b = LinearIndex.toBinding(key, map);
                if (b.size() == 3) {
                    for (int i = 0; i < this.vars.length; ++i) {
                        Assert.assertEquals((Object)b.get(this.vars[i]), (Object)Util.makeIntNode(10 + i));
                    }
                    continue;
                }
                Assert.assertEquals((Object)b.get(this.vars[0]), (Object)Util.makeIntNode(20));
                Assert.assertEquals((Object)b.get(this.vars[2]), (Object)Util.makeIntNode(22));
            }
        }
    }

    @Test
    public void testHashIndexTableData() throws Exception {
        this.testTableData(new HashIndexTable(this.order1, this.fullData()));
        this.testTableData(new HashIndexTable(this.order2, this.fullData()));
    }

    @Test
    public void testLinearIndexTableData() {
        this.testTableData(IndexFactory.createIndex(this.order1, this.partData()));
        this.testTableData(IndexFactory.createIndex(this.order2, this.partData()));
        Set<HashIndexTable.Key> emptyKeys = Collections.emptySet();
        Map<Var, Integer> emptyMapping = Collections.emptyMap();
        this.testTableData(new LinearIndex(this.order1, this.fullData(), emptyKeys, emptyMapping));
        this.testTableData(new LinearIndex(this.order2, this.fullData(), emptyKeys, emptyMapping));
        this.testTableData(new LinearIndex(this.order1, this.partData(), emptyKeys, emptyMapping));
        this.testTableData(new LinearIndex(this.order2, this.partData(), emptyKeys, emptyMapping));
    }

    private void testTableData(IndexTable index) {
        for (Binding b : this.fData) {
            Assert.assertTrue((boolean)index.containsCompatibleWithSharedDomain(b));
        }
        Assert.assertTrue((boolean)index.containsCompatibleWithSharedDomain(TestIndexTable.binding("abcd", 10, 11, 12, 13)));
        Assert.assertTrue((boolean)index.containsCompatibleWithSharedDomain(TestIndexTable.binding("ab", 10, 11)));
        Assert.assertTrue((boolean)index.containsCompatibleWithSharedDomain(TestIndexTable.binding("bc", 11, 12)));
        Assert.assertTrue((boolean)index.containsCompatibleWithSharedDomain(TestIndexTable.binding("ac", 10, 12)));
        Assert.assertTrue((boolean)index.containsCompatibleWithSharedDomain(TestIndexTable.binding("a", 10)));
        Assert.assertTrue((boolean)index.containsCompatibleWithSharedDomain(TestIndexTable.binding("ab", 70, 71)));
        Assert.assertTrue((boolean)index.containsCompatibleWithSharedDomain(TestIndexTable.binding("bc", 71, 72)));
        Assert.assertTrue((boolean)index.containsCompatibleWithSharedDomain(TestIndexTable.binding("ac", 70, 72)));
        Assert.assertTrue((boolean)index.containsCompatibleWithSharedDomain(TestIndexTable.binding("a", 80)));
        Assert.assertFalse((boolean)index.containsCompatibleWithSharedDomain(TestIndexTable.binding("abc", 10, 11, 11)));
        Assert.assertFalse((boolean)index.containsCompatibleWithSharedDomain(TestIndexTable.binding("d", 10)));
        Assert.assertFalse((boolean)index.containsCompatibleWithSharedDomain(TestIndexTable.binding("abc", 10, 21, 32)));
        Assert.assertFalse((boolean)index.containsCompatibleWithSharedDomain(TestIndexTable.binding("xyz", 10, 11, 12)));
    }

    private QueryIterator fullData() {
        return QueryIterPlainWrapper.create(this.fData.iterator());
    }

    private QueryIterator partData() {
        return QueryIterPlainWrapper.create(this.pData.iterator());
    }

    private static Binding binding(String varNames, Integer ... ints) {
        assert (varNames.length() == ints.length);
        BindingBuilder b = Binding.builder();
        for (int s = 0; s < varNames.length(); ++s) {
            b.add(Var.alloc(varNames.substring(s, s + 1)), Util.makeIntNode(ints[s]));
        }
        return b.build();
    }
}

