/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.binding;

import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestBinding {
    private static Node n_1 = SSE.parseNode("'1'");
    private static Node n_2 = SSE.parseNode("'2'");
    private static Node n_3 = SSE.parseNode("'3'");
    private static Node n_4 = SSE.parseNode("'4'");
    private static Node n_5 = SSE.parseNode("'5'");
    private static Node n_6 = SSE.parseNode("'6'");
    private static Node n_a = SSE.parseNode("'A'");
    private static Node n_b = SSE.parseNode("'A'");
    private static Var var1 = Var.alloc("v1");
    private static Var var2 = Var.alloc("v2");
    private static Var var3 = Var.alloc("v3");
    private static Var var4 = Var.alloc("v4");
    private static Var var5 = Var.alloc("v5");
    private static Var var6 = Var.alloc("v6");
    private static Var vp1 = Var.alloc("p1");
    private static Var vp2 = Var.alloc("p2");

    @Test
    public void binding_0() {
        Binding b = BindingFactory.binding();
        Assert.assertEquals((long)0L, (long)b.size());
        Assert.assertTrue((boolean)b.isEmpty());
        Assert.assertEquals((long)0L, (long)Iter.count(b.vars()));
        Binding bx = Binding.builder().build();
        Assert.assertEquals((Object)b, (Object)bx);
    }

    @Test
    public void binding_1() {
        Binding b = BindingFactory.binding(var1, n_1);
        Assert.assertEquals((long)1L, (long)b.size());
        Assert.assertFalse((boolean)b.isEmpty());
        Assert.assertEquals((long)1L, (long)Iter.count(b.vars()));
        Assert.assertTrue((boolean)b.contains(var1));
        Assert.assertEquals((Object)n_1, (Object)b.get(var1));
        Binding bx = Binding.builder().add(var1, n_1).build();
        Assert.assertEquals((Object)b, (Object)bx);
    }

    @Test
    public void binding_2() {
        Binding b = BindingFactory.binding(var1, n_1, var2, n_2);
        Assert.assertEquals((long)2L, (long)b.size());
        Assert.assertFalse((boolean)b.isEmpty());
        Assert.assertEquals((long)2L, (long)Iter.count(b.vars()));
        Binding bx = Binding.builder().add(var1, n_1).add(var2, n_2).build();
        Assert.assertEquals((Object)b, (Object)bx);
    }

    @Test
    public void binding_3() {
        Binding b = BindingFactory.binding(var1, n_1, var2, n_2, var3, n_3);
        Assert.assertEquals((long)3L, (long)b.size());
        Assert.assertFalse((boolean)b.isEmpty());
        Assert.assertEquals((long)3L, (long)Iter.count(b.vars()));
        Binding bx = Binding.builder().add(var1, n_1).add(var2, n_2).add(var3, n_3).build();
        Assert.assertEquals((Object)b, (Object)bx);
    }

    @Test
    public void binding_4() {
        Binding b = BindingFactory.binding(var1, n_1, var2, n_2, var3, n_3, var4, n_4);
        Assert.assertEquals((long)4L, (long)b.size());
        Assert.assertFalse((boolean)b.isEmpty());
        Assert.assertEquals((long)4L, (long)Iter.count(b.vars()));
        Binding bx = Binding.builder().add(var1, n_1).add(var2, n_2).add(var3, n_3).add(var4, n_4).build();
        Assert.assertEquals((Object)b, (Object)bx);
    }

    @Test
    public void binding_5() {
        BindingBuilder builder = Binding.builder();
        Assert.assertEquals((long)0L, (long)builder.snapshot().size());
        builder.toString();
        TestBinding.add(builder, var1, n_1);
        builder.toString();
        Assert.assertEquals((long)1L, (long)builder.snapshot().size());
        TestBinding.add(builder, var2, n_2);
        builder.toString();
        Assert.assertEquals((long)2L, (long)builder.snapshot().size());
        TestBinding.add(builder, var3, n_3);
        builder.toString();
        Assert.assertEquals((long)3L, (long)builder.snapshot().size());
        TestBinding.add(builder, var4, n_4);
        builder.toString();
        Assert.assertEquals((long)4L, (long)builder.snapshot().size());
        TestBinding.add(builder, var5, n_5);
        builder.toString();
        Assert.assertEquals((long)5L, (long)builder.snapshot().size());
        Binding b = builder.build();
        Assert.assertEquals((long)5L, (long)b.size());
        Assert.assertFalse((boolean)b.isEmpty());
        Assert.assertEquals((long)5L, (long)Iter.count(b.vars()));
    }

    @Test
    public void binding_6() {
        Binding parent = BindingFactory.binding(vp1, n_a, vp2, n_b);
        BindingBuilder builder = Binding.builder(parent);
        Assert.assertEquals((long)2L, (long)builder.snapshot().size());
        builder.toString();
        TestBinding.add(builder, var1, n_1);
        builder.toString();
        Assert.assertEquals((long)3L, (long)builder.snapshot().size());
        TestBinding.add(builder, var2, n_2);
        builder.toString();
        Assert.assertEquals((long)4L, (long)builder.snapshot().size());
        TestBinding.add(builder, var3, n_3);
        builder.toString();
        Assert.assertEquals((long)5L, (long)builder.snapshot().size());
        TestBinding.add(builder, var4, n_4);
        builder.toString();
        Assert.assertEquals((long)6L, (long)builder.snapshot().size());
        TestBinding.add(builder, var5, n_5);
        builder.toString();
        Assert.assertEquals((long)7L, (long)builder.snapshot().size());
        TestBinding.add(builder, var6, n_6);
        builder.toString();
        Assert.assertEquals((long)8L, (long)builder.snapshot().size());
        Binding b = builder.build();
        Assert.assertEquals((long)8L, (long)b.size());
        Assert.assertFalse((boolean)b.isEmpty());
        Assert.assertEquals((long)8L, (long)Iter.count(b.vars()));
    }

    @Test
    public void binding_set_1() {
        Binding parent = BindingFactory.binding(vp1, n_a);
        BindingBuilder builder = Binding.builder(parent);
        builder.set(var1, n_1);
        Assert.assertEquals((Object)n_1, (Object)builder.get(var1));
        Assert.assertEquals((Object)n_a, (Object)builder.get(vp1));
        builder.set(var1, n_1);
        Assert.assertEquals((Object)n_1, (Object)builder.get(var1));
        Binding b = builder.build();
        Assert.assertEquals((long)2L, (long)b.size());
        Assert.assertFalse((boolean)b.isEmpty());
        Assert.assertEquals((long)2L, (long)Iter.count(b.vars()));
    }

    @Test
    public void binding_set_2() {
        Binding parent = BindingFactory.binding(vp1, n_a);
        BindingBuilder builder = Binding.builder(parent);
        builder.add(var1, n_1);
        builder.set(var1, n_1);
        Assert.assertEquals((Object)n_1, (Object)builder.get(var1));
        Assert.assertEquals((Object)n_a, (Object)builder.get(vp1));
        builder.set(var1, n_2);
        Binding b = builder.build();
        Assert.assertEquals((long)2L, (long)b.size());
        Assert.assertEquals((Object)n_2, (Object)b.get(var1));
        Assert.assertFalse((boolean)b.isEmpty());
        Assert.assertEquals((long)2L, (long)Iter.count(b.vars()));
    }

    private static void add(BindingBuilder builder, Var var, Node node) {
        builder.add(var, node);
        Assert.assertTrue((boolean)builder.contains(var));
        Assert.assertEquals((Object)node, (Object)builder.get(var));
    }

    private static void set(BindingBuilder builder, Var var, Node node) {
        builder.set(var, node);
        Assert.assertTrue((boolean)builder.contains(var));
        Assert.assertEquals((Object)node, (Object)builder.get(var));
    }

    @Test
    public void binding_access_01() {
        Binding b = BindingFactory.binding(var1, n_1);
        Assert.assertTrue((boolean)b.contains(var1));
        Assert.assertFalse((boolean)b.contains(var2));
        Assert.assertEquals((Object)n_1, (Object)b.get(var1));
        Assert.assertNull((Object)b.get(var2));
    }

    @Test
    public void binding_access_02() {
        Binding parent = BindingFactory.binding(vp1, n_a);
        Binding b = BindingFactory.binding(parent, var1, n_1);
        Assert.assertTrue((boolean)b.contains(var1));
        Assert.assertFalse((boolean)b.contains(var2));
        Assert.assertEquals((Object)n_1, (Object)b.get(var1));
        Assert.assertNull((Object)b.get(var2));
        Assert.assertTrue((boolean)b.contains(vp1));
        Assert.assertEquals((Object)n_a, (Object)b.get(vp1));
    }

    @Test
    public void binding_builder_01() {
        BindingBuilder builder = Binding.builder();
        Assert.assertTrue((boolean)builder.isEmpty());
        Assert.assertFalse((boolean)builder.contains(var1));
        Assert.assertNull((Object)builder.get(var1));
        builder.add(var1, n_1);
        Assert.assertFalse((boolean)builder.isEmpty());
        Assert.assertTrue((boolean)builder.contains(var1));
        Assert.assertEquals((Object)n_1, (Object)builder.get(var1));
    }

    @Test
    public void binding_builder_02() {
        Binding parent = BindingFactory.binding(vp1, n_a);
        BindingBuilder builder = Binding.builder(parent);
        Assert.assertFalse((boolean)builder.isEmpty());
        Assert.assertFalse((boolean)builder.contains(var1));
        Assert.assertNull((Object)builder.get(var1));
        builder.add(var1, n_1);
        Assert.assertFalse((boolean)builder.isEmpty());
        Assert.assertTrue((boolean)builder.contains(var1));
        Assert.assertEquals((Object)n_1, (Object)builder.get(var1));
        Assert.assertTrue((boolean)builder.contains(vp1));
        Assert.assertEquals((Object)n_a, (Object)builder.get(vp1));
    }

    @Test(expected=NullPointerException.class)
    public void binding_bad_01() {
        Binding b = BindingFactory.binding(var1, null);
    }

    @Test(expected=NullPointerException.class)
    public void binding_bad_02() {
        Binding b = BindingFactory.binding(null, n_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void binding_bad_03() {
        Binding b = BindingFactory.binding(var1, n_1, var1, n_2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void binding_bad_04() {
        Binding b = BindingFactory.binding(var1, n_1, var2, n_2, var1, n_3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void binding_bad_05() {
        Binding b = BindingFactory.binding(var1, n_1, var2, n_2, var2, n_3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void binding_bad_06() {
        Binding b = BindingFactory.binding(var1, n_1, var1, n_2, var3, n_3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void binding_bad_07() {
        Binding b = BindingFactory.binding(var1, n_1, var2, n_2, var3, n_3, var1, n_4);
    }

    @Test(expected=NullPointerException.class)
    public void binding_builder_bad_01() {
        BindingBuilder builder = Binding.builder();
        builder.add(var1, null);
    }

    @Test(expected=NullPointerException.class)
    public void binding_builder_bad_02() {
        BindingBuilder builder = Binding.builder();
        builder.add(null, n_1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void binding_builder_bad_03() {
        BindingBuilder builder = Binding.builder();
        builder.add(var1, n_1);
        builder.add(var1, n_1);
    }
}

