/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import java.util.Collections;
import java.util.NoSuchElementException;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.engine.JsonIterator;
import org.junit.Assert;
import org.junit.Test;

public class TestJsonIterator {
    @Test
    public void testIterator() {
        Model model = ModelFactory.createDefaultModel();
        Resource r = model.createResource(AnonId.create("first"));
        Property p = model.getProperty("");
        Literal node = ResourceFactory.createTypedLiteral("123", XSDDatatype.XSDdecimal);
        model.add(r, p, node);
        r = model.createResource(AnonId.create("second"));
        p = model.getProperty("");
        node = ResourceFactory.createTypedLiteral("abc", XSDDatatype.XSDstring);
        model.add(r, p, node);
        r = model.createResource(AnonId.create("third"));
        p = model.getProperty("");
        node = ResourceFactory.createLangLiteral("def", "en");
        model.add(r, p, node);
        Query query2 = QueryFactory.create("JSON { \"s\": ?s , \"p\": ?p , \"o\" : ?o } WHERE { ?s ?p ?o }", Syntax.syntaxARQ);
        try (QueryExecution qexec = QueryExecutionFactory.create(query2, model);){
            JsonIterator execJsonItems = (JsonIterator)qexec.execJsonItems();
            Assert.assertTrue((boolean)execJsonItems.hasNext());
            Assert.assertNotNull((Object)execJsonItems.next());
        }
    }

    @Test(expected=NoSuchElementException.class)
    public void testInitialStates() {
        JsonIterator iterator = new JsonIterator(null, Collections.emptyList());
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.next();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveNotImplemented() {
        JsonIterator iterator = new JsonIterator(null, Collections.emptyList());
        iterator.remove();
    }
}

