/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.DatasetGraphZero;
import org.junit.Assert;
import org.junit.Test;

public class TestJsonEval {
    @Test
    public void json_eval_01() {
        this.test("JSON { 'x' : ?x } WHERE { VALUES ?x { 'X' } }", "[ { 'x' : 'X' } ]");
    }

    @Test
    public void json_eval_02() {
        this.test("JSON { 'x' : ?x } WHERE { VALUES ?x { 'X' 'Y' } }", "[ { 'x' : 'X' } , {'x' : 'Y' }]");
    }

    @Test
    public void json_eval_03() {
        this.test("JSON { 's' : 'FOO' } WHERE { }", "[ { 's' : 'FOO' } ]");
    }

    @Test
    public void json_eval_04() {
        this.test("JSON { 'F' : 'string' } WHERE { }", "[ { 'F' : 'string' } ]");
    }

    @Test
    public void json_eval_05() {
        this.test("JSON { 'x' : 123 } WHERE { }", "[ { 'x' : 123 }]");
    }

    @Test
    public void json_eval_06() {
        this.test("JSON { 'x' : 123.5 } WHERE { }", "[ { 'x' : 123.5 }]");
    }

    @Test
    public void json_eval_07() {
        this.test("JSON { 'x' : -10 } WHERE { }", "[ { 'x' : -10 }]");
    }

    private void test(String queryString, String jsonExpected) {
        Query query2 = QueryFactory.create(queryString, Syntax.syntaxARQ);
        DatasetGraphZero dsg = new DatasetGraphZero();
        Dataset ds = DatasetFactory.wrap(dsg);
        try (QueryExecution qExec = QueryExecutionFactory.create(query2, ds);){
            JsonArray jvGot = qExec.execJson();
            JsonValue jvExpected = JSON.parseAny(jsonExpected);
            Assert.assertEquals((Object)jvExpected, (Object)jvGot);
        }
    }
}

