/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.ext.com.google.common.collect.ImmutableSet;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.mem.AbstractTestTripleTable;
import org.apache.jena.sparql.core.mem.AbstractTestTupleTable;
import org.apache.jena.sparql.core.mem.AbstractTestTupleTableForms;
import org.apache.jena.sparql.core.mem.TripleTable;
import org.apache.jena.sparql.core.mem.TripleTableForm;
import org.apache.jena.sparql.core.mem.TupleSlot;
import org.junit.Test;

public class TestTripleTableForms
extends AbstractTestTupleTableForms<TripleTableForm> {
    private final Map<Set<TupleSlot>, Set<TripleTableForm>> answerKey = new HashMap<Set<TupleSlot>, Set<TripleTableForm>>(){
        {
            this.put(ImmutableSet.of(TupleSlot.SUBJECT), ImmutableSet.of(TripleTableForm.SPO));
            this.put(ImmutableSet.of(TupleSlot.PREDICATE), ImmutableSet.of(TripleTableForm.POS));
            this.put(ImmutableSet.of(TupleSlot.SUBJECT, TupleSlot.PREDICATE), ImmutableSet.of(TripleTableForm.SPO));
            this.put(ImmutableSet.of(TupleSlot.OBJECT), ImmutableSet.of(TripleTableForm.OSP));
            this.put(ImmutableSet.of(TupleSlot.SUBJECT, TupleSlot.OBJECT), ImmutableSet.of(TripleTableForm.OSP));
            this.put(ImmutableSet.of(TupleSlot.PREDICATE, TupleSlot.OBJECT), ImmutableSet.of(TripleTableForm.POS));
            this.put(ImmutableSet.of(TupleSlot.SUBJECT, TupleSlot.PREDICATE, TupleSlot.OBJECT), ImmutableSet.of(TripleTableForm.SPO));
            this.put(ImmutableSet.of(), ImmutableSet.of(TripleTableForm.SPO));
        }
    };

    @Override
    public Stream<Set<TupleSlot>> queryPatterns() {
        return AbstractTestTripleTable.tripleQueryPatterns();
    }

    @Override
    protected Stream<TripleTableForm> tableForms() {
        return TripleTableForm.tableForms();
    }

    @Test
    public void addAndRemoveSomeTriples() {
        this.tableForms().map(TripleTableForm::get).map(table -> new AbstractTestTripleTable((TripleTable)table){
            final /* synthetic */ TripleTable val$table;
            {
                this.val$table = tripleTable;
            }

            @Override
            protected TripleTable table() {
                return this.val$table;
            }

            @Override
            protected Stream<Triple> tuples() {
                return this.val$table.find(Node.ANY, Node.ANY, Node.ANY);
            }
        }).forEach(AbstractTestTupleTable::addAndRemoveSomeTuples);
    }

    @Override
    protected TripleTableForm chooseFrom(Set<TupleSlot> sample) {
        return TripleTableForm.chooseFrom(sample);
    }

    @Override
    protected Map<Set<TupleSlot>, Set<TripleTableForm>> answerKey() {
        return this.answerKey;
    }
}

