/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.ext.com.google.common.collect.ImmutableSet;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.mem.TupleSlot;
import org.apache.jena.sparql.core.mem.TupleTable;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTestTupleTable<TupleType, TupleTableType extends TupleTable<TupleType>> {
    protected static final Set<TupleSlot> allWildcardQuery = ImmutableSet.of();

    protected abstract TupleType testTuple();

    protected abstract TupleTableType table();

    protected abstract Stream<TupleType> tuples();

    protected abstract Stream<Set<TupleSlot>> queryPatterns();

    protected long transactionalCount() {
        this.table().begin(ReadWrite.READ);
        long x = this.rawCount();
        this.table().end();
        return x;
    }

    protected long rawCount() {
        return this.tuples().count();
    }

    @Test
    public void addAndRemoveSomeTuples() {
        Assert.assertEquals((long)0L, (long)this.transactionalCount());
        this.table().begin(ReadWrite.WRITE);
        this.table().add(this.testTuple());
        Assert.assertEquals((long)1L, (long)this.rawCount());
        Set contents = this.tuples().collect(Collectors.toSet());
        Assert.assertEquals(ImmutableSet.of(this.testTuple()), contents);
        this.table().delete(this.testTuple());
        Assert.assertEquals((long)0L, (long)this.rawCount());
        contents = this.tuples().collect(Collectors.toSet());
        Assert.assertTrue((boolean)contents.isEmpty());
        this.table().end();
        Assert.assertEquals((long)0L, (long)this.transactionalCount());
        this.table().begin(ReadWrite.WRITE);
        this.table().add(this.testTuple());
        Assert.assertEquals((long)1L, (long)this.rawCount());
        contents = this.tuples().collect(Collectors.toSet());
        Assert.assertEquals(ImmutableSet.of(this.testTuple()), contents);
        this.table().abort();
        Assert.assertEquals((long)0L, (long)this.transactionalCount());
        this.table().begin(ReadWrite.WRITE);
        this.table().add(this.testTuple());
        Assert.assertEquals((long)1L, (long)this.rawCount());
        contents = this.tuples().collect(Collectors.toSet());
        Assert.assertEquals(ImmutableSet.of(this.testTuple()), contents);
        this.table().commit();
        Assert.assertEquals((long)1L, (long)this.transactionalCount());
        this.table().begin(ReadWrite.WRITE);
        Assert.assertEquals((long)1L, (long)this.rawCount());
        this.table().clear();
        Assert.assertEquals((long)0L, (long)this.rawCount());
        contents = this.tuples().collect(Collectors.toSet());
        Assert.assertTrue((boolean)contents.isEmpty());
        this.table().commit();
        Assert.assertEquals((long)0L, (long)this.transactionalCount());
    }
}

