/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.assembler;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.exceptions.CannotConstructException;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;
import org.apache.jena.sparql.core.assembler.InMemDatasetAssembler;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.IsoMatcher;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;

public class TestInMemDatasetAssembler
extends Assert {
    private Dataset assemble(Resource example) {
        Model model = example.getModel();
        model.setNsPrefix("ja", JA.getURI());
        InMemDatasetAssembler testAssembler = new InMemDatasetAssembler();
        return testAssembler.open(testAssembler, example, Mode.DEFAULT);
    }

    @Test
    public void emptyDataset() {
        Model model = ModelFactory.createDefaultModel();
        Resource empty = model.createResource("test:empty");
        empty.addProperty(RDF.type, DatasetAssemblerVocab.tDatasetTxnMem);
        Dataset dataset = this.assemble(empty);
        TestInMemDatasetAssembler.assertFalse((boolean)dataset.asDatasetGraph().find().hasNext());
    }

    @Test
    public void directDataLinkForDefaultAndNamedGraphs() throws IOException {
        Model model = ModelFactory.createDefaultModel();
        Path triples = Files.createTempFile("simpleExample", ".nt", new FileAttribute[0]);
        Resource triplesURI = model.createResource(IRILib.fileToIRI(triples.toFile()));
        Resource simpleExample = model.createResource("test:simpleExample");
        simpleExample.addProperty(RDF.type, DatasetAssemblerVocab.tDatasetTxnMem);
        simpleExample.addProperty(JA.data, triplesURI);
        Resource namedGraphDef = model.createResource("test:namedGraphDef");
        simpleExample.addProperty(DatasetAssemblerVocab.pNamedGraph, namedGraphDef);
        Resource namedGraphName = model.createResource("test:namedGraphExample");
        namedGraphDef.addProperty(RDF.type, JA.MemoryModel);
        namedGraphDef.addProperty(DatasetAssemblerVocab.pGraphName, namedGraphName);
        namedGraphDef.addProperty(JA.data, triplesURI);
        try (FileOutputStream out = new FileOutputStream(triples.toFile());){
            RDFDataMgr.write((OutputStream)out, model, RDFFormat.NTRIPLES);
        }
        Dataset dataset = this.assemble(simpleExample);
        Model assembledDefaultModel = dataset.getDefaultModel();
        Model assembledNamedModel = dataset.getNamedModel(namedGraphName.getURI());
        for (Model m : new Model[]{assembledDefaultModel, assembledNamedModel}) {
            TestInMemDatasetAssembler.assertTrue((boolean)m.contains(simpleExample, DatasetAssemblerVocab.pNamedGraph, namedGraphDef));
            TestInMemDatasetAssembler.assertTrue((boolean)m.contains(namedGraphDef, DatasetAssemblerVocab.pGraphName, namedGraphName));
            TestInMemDatasetAssembler.assertTrue((boolean)m.contains(simpleExample, JA.data, triplesURI));
        }
        Iterator<Node> graphNodes = dataset.asDatasetGraph().listGraphNodes();
        TestInMemDatasetAssembler.assertTrue((boolean)graphNodes.hasNext());
        TestInMemDatasetAssembler.assertEquals((Object)namedGraphName.asNode(), (Object)graphNodes.next());
        TestInMemDatasetAssembler.assertFalse((boolean)graphNodes.hasNext());
    }

    @Test
    public void directDataQuadsURI() throws IOException {
        Model model = ModelFactory.createDefaultModel();
        Path quads = Files.createTempFile("quadExample", ".nq", new FileAttribute[0]);
        String quadsURIStr = IRILib.fileToIRI(quads.toFile());
        Resource quadsURI = model.createResource(quadsURIStr);
        Resource simpleExample = model.createResource("test:simpleExample");
        simpleExample.addProperty(RDF.type, DatasetAssemblerVocab.tDatasetTxnMem);
        simpleExample.addProperty(JA.data, quadsURI);
        DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
        model.listStatements().mapWith(FrontsTriple::asTriple).mapWith(t -> new Quad(quadsURI.asNode(), (Triple)t)).forEachRemaining(dsg::add);
        try (FileOutputStream out = new FileOutputStream(quads.toFile());){
            RDFDataMgr.write((OutputStream)out, dsg, Lang.NQUADS);
        }
        Dataset dataset = this.assemble(simpleExample);
        Model assembledDefaultModel = dataset.getDefaultModel();
        Model assembledNamedModel = dataset.getNamedModel(quadsURI.getURI());
        TestInMemDatasetAssembler.assertTrue((boolean)assembledDefaultModel.isEmpty());
        TestInMemDatasetAssembler.assertTrue((boolean)assembledNamedModel.contains(assembledNamedModel.createStatement(simpleExample, JA.data, quadsURI)));
    }

    @Test
    public void directDataQuadsString() throws IOException {
        DatasetGraph dsgData = DatasetGraphFactory.createTxnMem();
        dsgData.add(SSE.parseQuad("(_ :s1 :p1 :o1)"));
        dsgData.add(SSE.parseQuad("(:gn :s2 :p2 :o2)"));
        Path quads = Files.createTempFile("quadExample2", ".nq", new FileAttribute[0]);
        String dataFileName = quads.toFile().toURI().toString();
        try (FileOutputStream out = new FileOutputStream(quads.toFile());){
            RDFDataMgr.write((OutputStream)out, dsgData, Lang.NQUADS);
        }
        Model assemblerModel = ModelFactory.createDefaultModel();
        Resource simpleExample2 = assemblerModel.createResource("test:simpleExample2");
        simpleExample2.addProperty(RDF.type, DatasetAssemblerVocab.tDatasetTxnMem);
        simpleExample2.addProperty(JA.data, dataFileName);
        Dataset dataset = this.assemble(simpleExample2);
        TestInMemDatasetAssembler.assertTrue((boolean)IsoMatcher.isomorphic(dsgData, dataset.asDatasetGraph()));
    }

    @Test(expected=CannotConstructException.class)
    public void wrongKindOfAssemblerDefinition() {
        Model model = ModelFactory.createDefaultModel();
        Resource badExample = model.createResource("test:badExample");
        this.assemble(badExample);
    }
}

