/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestGraphView {
    @Test
    public void graphDSG_view_txn_1() {
        DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
        Graph graph = dsg.getDefaultGraph();
        Assert.assertTrue((boolean)(graph instanceof GraphView));
        Assert.assertTrue((boolean)graph.getTransactionHandler().transactionsSupported());
    }

    @Test
    public void graphDSG_view_txn_2() {
        DatasetGraph dsg = DatasetGraphFactory.createGeneral();
        GraphView graph = GraphView.createDefaultGraph(dsg);
        Assert.assertTrue((boolean)(graph instanceof GraphView));
        Assert.assertFalse((boolean)graph.getTransactionHandler().transactionsSupported());
    }

    @Test
    public void graphDSG_view_txn_3() {
        DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
        Graph graph = dsg.getDefaultGraph();
        Triple triple = SSE.parseTriple("(<s> <p> 0)");
        Assert.assertFalse((boolean)graph.contains(triple));
        graph.getTransactionHandler().execute(() -> graph.add(triple));
        graph.getTransactionHandler().execute(() -> Assert.assertTrue((boolean)graph.contains(triple)));
    }
}

