/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.AbstractTestGraphOverDatasetGraph;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestDatasetGraphViewGraphs
extends AbstractTestGraphOverDatasetGraph {
    @Override
    protected DatasetGraph createBaseDSG() {
        return DatasetGraphFactory.create();
    }

    @Override
    protected Graph makeDefaultGraph(DatasetGraph dsg) {
        return GraphView.createDefaultGraph(dsg);
    }

    @Override
    protected Graph makeNamedGraph(DatasetGraph dsg, Node gn) {
        return GraphView.createNamedGraph(dsg, gn);
    }

    @Test
    public void graphDSG_basic_1() {
        Graph g = this.makeDefaultGraph(this.baseDSG);
        Assert.assertTrue((boolean)(g instanceof GraphView));
        GraphView gv = (GraphView)g;
        Assert.assertEquals((Object)this.baseDSG, (Object)gv.getDataset());
        Assert.assertEquals(null, (Object)gv.getGraphName());
    }

    @Test
    public void graphDSG_basic_2() {
        Node gn1 = SSE.parseNode("<g1>");
        Graph g = this.makeNamedGraph(this.baseDSG, gn1);
        Assert.assertTrue((boolean)(g instanceof GraphView));
        GraphView gv = (GraphView)g;
        Assert.assertEquals((Object)this.baseDSG, (Object)gv.getDataset());
        Assert.assertEquals((Object)gn1, (Object)gv.getGraphName());
    }

    @Test
    public void graphDSG_view_union_2() {
        GraphView g = GraphView.createUnionGraph(this.baseDSG);
        Assert.assertTrue((boolean)(g instanceof GraphView));
        long x = Iter.count(g.find(null, null, null));
        Assert.assertEquals((long)2L, (long)x);
    }

    @Test
    public void graphDSG_view_union_3() {
        GraphView g = GraphView.createUnionGraph(this.baseDSG);
        Assert.assertEquals((long)2L, (long)g.size());
    }
}

