/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.AbstractDatasetGraphTests;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestDatasetGraphLink
extends AbstractDatasetGraphTests {
    @Override
    protected DatasetGraph emptyDataset() {
        return DatasetGraphFactory.createGeneral();
    }

    @Test
    public void linkAdd_01() {
        Graph graph = SSE.parseGraph("(graph (:s :p :o))");
        Node g = SSE.parseNode(":g");
        DatasetGraph dsg = this.emptyDataset();
        dsg.addGraph(g, graph);
        graph.clear();
        Assert.assertTrue((boolean)graph.isEmpty());
        Assert.assertTrue((boolean)dsg.getGraph(g).isEmpty());
    }

    @Override
    @Test
    public void emptyGraph_1() {
    }

    @Test
    public void emptyGraph_1_link() {
        DatasetGraph dsg = this.emptyDataset();
        Node gn = NodeFactory.createURI("http://example/g");
        Quad q = SSE.parseQuad("(:g :s :p :o)");
        dsg.add(q);
        List<Node> nodes1 = Iter.toList(dsg.listGraphNodes());
        Assert.assertEquals((long)1L, (long)nodes1.size());
        dsg.delete(q);
        List<Node> nodes2 = Iter.toList(dsg.listGraphNodes());
        Assert.assertEquals((long)1L, (long)nodes2.size());
    }

    @Override
    @Test
    public void emptyGraph_2() {
    }

    @Test
    public void emptyGraph_2_link() {
        DatasetGraph dsg = this.emptyDataset();
        Node gn = NodeFactory.createURI("http://example/g");
        Quad q = SSE.parseQuad("(:g :s :p :o)");
        dsg.add(q);
        Assert.assertTrue((boolean)dsg.containsGraph(gn));
        dsg.delete(q);
        Assert.assertTrue((boolean)dsg.containsGraph(gn));
    }
}

