/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Creator;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphFilteredView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.system.Txn;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestDatasetGraphFilteredView {
    final DatasetGraph basedsg;
    private static String dataStr = StrUtils.strjoinNL("PREFIX : <http://test/>", "", ":s0 :p 0 .", ":g1 { :s1 :p 1 }", ":g2 { :s2 :p 2 , '02' }", ":g3 { :s3 :p 3 , '03' , '003' }", ":g4 { :s4 :p 4 , '04' , '004', '0004' }");
    public static Node s0 = SSE.parseNode("<http://test/s0>");
    public static Node s1 = SSE.parseNode("<http://test/s1>");
    public static Node s2 = SSE.parseNode("<http://test/s2>");
    public static Node s3 = SSE.parseNode("<http://test/s3>");
    public static Node s4 = SSE.parseNode("<http://test/s4>");
    public static Node g1 = SSE.parseNode("<http://test/g1>");
    public static Node g2 = SSE.parseNode("<http://test/g2>");
    public static Node g3 = SSE.parseNode("<http://test/g3>");
    public static Node g4 = SSE.parseNode("<http://test/g4>");

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> data() {
        Creator<DatasetGraph> c1 = DatasetGraphFactory::create;
        Object[] obj1 = new Object[]{"General", c1};
        Creator<DatasetGraph> c2 = DatasetGraphFactory::createTxnMem;
        Object[] obj2 = new Object[]{"TIM", c2};
        return Arrays.asList(obj1, obj2);
    }

    public static void addTestData(DatasetGraph dsg) {
        Txn.executeWrite(dsg, () -> RDFParser.create().fromString(dataStr).lang(Lang.TRIG).parse(dsg));
    }

    public TestDatasetGraphFilteredView(String name, Creator<DatasetGraph> source) {
        this.basedsg = source.create();
        TestDatasetGraphFilteredView.addTestData(this.basedsg);
    }

    @Test
    public void filtered1() {
        Predicate<Quad> filter = x -> true;
        Txn.executeRead(this.basedsg, () -> {
            DatasetGraphFilteredView dsg = new DatasetGraphFilteredView(this.basedsg, filter, Iter.toList(this.basedsg.listGraphNodes()));
            this.assertSame(this.basedsg, dsg);
        });
    }

    @Test
    public void filtered2() {
        Predicate<Quad> filter = x -> x.getGraph().equals(g2);
        Txn.executeRead(this.basedsg, () -> {
            DatasetGraphFilteredView dsg = new DatasetGraphFilteredView(this.basedsg, filter, Collections.singleton(g1));
            long x0 = Iter.count(dsg.find(null, null, null, null));
            Assert.assertEquals((long)2L, (long)x0);
            long x1 = Iter.count(dsg.find(g2, null, null, null));
            Assert.assertEquals((long)2L, (long)x1);
            long x2 = Iter.count(dsg.find(null, s2, null, null));
            Assert.assertEquals((long)2L, (long)x2);
            long x3 = Iter.count(dsg.find(g1, null, null, null));
            Assert.assertEquals((long)0L, (long)x3);
            Assert.assertEquals((long)1L, (long)dsg.size());
        });
    }

    @Test
    public void filtered3() {
        Predicate<Quad> filter = x -> x.getSubject().equals(s2);
        Txn.executeRead(this.basedsg, () -> {
            DatasetGraphFilteredView dsg = new DatasetGraphFilteredView(this.basedsg, filter, Collections.singleton(g1));
            long x0 = Iter.count(dsg.find(null, null, null, null));
            Assert.assertEquals((long)2L, (long)x0);
            long x1 = Iter.count(dsg.find(g2, null, null, null));
            Assert.assertEquals((long)2L, (long)x1);
            long x2 = Iter.count(dsg.find(null, s2, null, null));
            Assert.assertEquals((long)2L, (long)x2);
            long x3 = Iter.count(dsg.find(g1, s2, null, null));
            Assert.assertEquals((long)0L, (long)x3);
            Assert.assertEquals((long)1L, (long)dsg.size());
        });
    }

    @Test
    public void filtered4() {
        Predicate<Quad> filter = x -> x.getSubject().equals(s2);
        Txn.executeRead(this.basedsg, () -> {
            DatasetGraphFilteredView dsg = new DatasetGraphFilteredView(this.basedsg, filter, Arrays.asList(g1, g2));
            long x0 = Iter.count(dsg.find(null, null, null, null));
            Assert.assertEquals((long)2L, (long)x0);
            long x1 = Iter.count(dsg.find(g2, null, null, null));
            Assert.assertEquals((long)2L, (long)x1);
            long x2 = Iter.count(dsg.find(null, s2, null, null));
            Assert.assertEquals((long)2L, (long)x2);
            long x3 = Iter.count(dsg.find(g1, s2, null, null));
            Assert.assertEquals((long)0L, (long)x3);
            Assert.assertEquals((long)2L, (long)dsg.size());
        });
    }

    @Test
    public void filtered5() {
        Predicate<Quad> filter = x -> x.getSubject().equals(s2) || x.getSubject().equals(s1);
        Txn.executeRead(this.basedsg, () -> {
            DatasetGraphFilteredView dsg = new DatasetGraphFilteredView(this.basedsg, filter, Arrays.asList(g1, g2));
            long x0 = Iter.count(dsg.find(null, null, null, null));
            Assert.assertEquals((long)3L, (long)x0);
            long x1 = Iter.count(dsg.find(g2, null, null, null));
            Assert.assertEquals((long)2L, (long)x1);
        });
    }

    private void assertSame(DatasetGraph dsg1, DatasetGraph dsg2) {
        Set<Quad> quads1 = Iter.toSet(dsg1.find());
        Set<Quad> quads2 = Iter.toSet(dsg2.find());
        Assert.assertEquals(quads1, quads2);
    }
}

