/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.Quad;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTestDataset {
    static Model model1 = ModelFactory.createDefaultModel();
    static Model model2 = ModelFactory.createDefaultModel();
    static Resource s1 = model1.createResource("s1");
    static Resource s2 = model1.createResource("s2");
    static Property p1 = model1.createProperty("p1");
    static Property p2 = model1.createProperty("p2");
    static Resource o1 = model1.createResource("o1");
    static Resource o2 = model1.createResource("o2");

    protected abstract Dataset createDataset();

    @Test
    public void dataset_01() {
        Dataset ds = this.createDataset();
        Assert.assertNotNull((Object)ds.getDefaultModel());
        Assert.assertNotNull((Object)ds.asDatasetGraph());
    }

    @Test
    public void dataset_02() {
        Dataset ds = this.createDataset();
        ds.getDefaultModel().add(s1, p1, o1);
        Assert.assertTrue((boolean)model1.isIsomorphicWith(ds.getDefaultModel()));
    }

    @Test
    public void dataset_03() {
        Dataset ds = this.createDataset();
        ds.setDefaultModel(model2);
        Assert.assertTrue((boolean)model2.isIsomorphicWith(ds.getDefaultModel()));
    }

    @Test
    public void dataset_04() {
        String graphName = "http://example/";
        Dataset ds = this.createDataset();
        ds.addNamedModel(graphName, model1);
        Assert.assertTrue((boolean)ds.containsNamedModel(graphName));
        List<String> x = Iter.toList(ds.listNames());
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertEquals((Object)graphName, (Object)x.get(0));
        Assert.assertFalse((boolean)model1.isIsomorphicWith(ds.getDefaultModel()));
        Model m = ds.getNamedModel(graphName);
        Assert.assertNotNull((Object)m);
        Assert.assertTrue((boolean)model1.isIsomorphicWith(m));
        ds.removeNamedModel(graphName);
        Assert.assertFalse((boolean)ds.containsNamedModel(graphName));
    }

    @Test
    public void dataset_05() {
        String graphName = "http://example/";
        Dataset ds = this.createDataset();
        ds.addNamedModel(graphName, model1);
        ds.replaceNamedModel(graphName, model2);
        Assert.assertTrue((boolean)ds.containsNamedModel(graphName));
        List<String> x = Iter.toList(ds.listNames());
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertEquals((Object)graphName, (Object)x.get(0));
        Assert.assertFalse((boolean)model1.isIsomorphicWith(ds.getNamedModel(graphName)));
        Assert.assertTrue((boolean)model2.isIsomorphicWith(ds.getNamedModel(graphName)));
    }

    @Test
    public void dataset_06() {
        String graphName = "http://example/";
        Dataset ds = this.createDataset();
        ds.addNamedModel(graphName, model1);
        Assert.assertFalse((String)"Dataset should not be empty after a named graph has been added!", (boolean)ds.isEmpty());
    }

    @Test
    public void dataset_07() {
        String graphName = "http://example/";
        Dataset ds = this.createDataset();
        ds.addNamedModel(graphName, model1);
        Assert.assertTrue((String)"Named graph not found", (boolean)ds.containsNamedModel(graphName));
    }

    @Test
    public void dataset_08() {
        Dataset ds = this.createDataset();
        Assert.assertTrue((String)"Union named graph not found", (boolean)ds.containsNamedModel(Quad.unionGraph.getURI()));
    }

    @Test
    public void dataset_09() {
        Dataset ds = this.createDataset();
        Assert.assertTrue((String)("Default graph not found using '<" + Quad.defaultGraphIRI.getURI() + ">'"), (boolean)ds.containsNamedModel(Quad.defaultGraphIRI.getURI()));
    }

    static {
        model1.add(s1, p1, o1);
        model2.add(s2, p2, o2);
    }
}

