/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.system.Txn;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractDatasetGraphTests {
    protected abstract DatasetGraph emptyDataset();

    @Test
    public void create_1() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Assert.assertNotNull((Object)dsg.getDefaultGraph());
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
    }

    @Test
    public void quad_01() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad = SSE.parseQuad("(quad <g> <s> <p> <o>)");
        dsg.add(quad);
        Assert.assertTrue((boolean)dsg.contains(quad));
        Iterator<Quad> iter = dsg.find(quad);
        Assert.assertTrue((boolean)iter.hasNext());
        Quad quad2 = iter.next();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((Object)quad, (Object)quad2);
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
        Assert.assertFalse((boolean)dsg.getGraph(NodeFactory.createURI("g")).isEmpty());
    }

    @Test
    public void quad_02() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad = SSE.parseQuad("(quad <g> <s> <p> <o>)");
        dsg.add(quad);
        dsg.containsGraph(NodeFactory.createURI("g"));
        dsg.delete(quad);
        Assert.assertTrue((boolean)dsg.isEmpty());
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
        Assert.assertTrue((boolean)dsg.getGraph(NodeFactory.createURI("g")).isEmpty());
    }

    @Test
    public void quad_03() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad1 = SSE.parseQuad("(quad <g> <s> <p> <o1>)");
        Quad quad2 = SSE.parseQuad("(quad <g> <s> <p> <o2>)");
        dsg.add(quad1);
        dsg.add(quad2);
        dsg.deleteAny(NodeFactory.createURI("g"), NodeFactory.createURI("s"), null, null);
        Assert.assertFalse((boolean)dsg.contains(quad1));
        Assert.assertFalse((boolean)dsg.contains(quad2));
    }

    @Test
    public void quad_04() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad1 = SSE.parseQuad("(quad <g> <s> <p> <o1>)");
        Quad quad2 = SSE.parseQuad("(quad <g> <s> <p> <o2>)");
        dsg.add(quad1);
        dsg.add(quad2);
        Iterator<Quad> iter = dsg.find(NodeFactory.createURI("g"), NodeFactory.createURI("s"), null, null);
        Assert.assertTrue((boolean)iter.hasNext());
        Set<Quad> x = Iter.iter(iter).toSet();
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(quad1));
        Assert.assertTrue((boolean)x.contains(quad2));
    }

    @Test
    public void quad_05() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad1 = SSE.parseQuad("(quad <g> <s> <p> <o1>)");
        Quad quad2 = SSE.parseQuad("(quad <g> <s> <p> <o2>)");
        Node g = SSE.parseNode("<g>");
        Node s = SSE.parseNode("<s>");
        Node p = SSE.parseNode("<p>");
        Node o1 = SSE.parseNode("<o1>");
        Node o2 = SSE.parseNode("<o2>");
        dsg.add(g, s, p, o1);
        Assert.assertTrue((boolean)dsg.contains(quad1));
        Assert.assertTrue((boolean)dsg.contains(g, s, p, o1));
        Assert.assertFalse((boolean)dsg.contains(g, s, p, o2));
    }

    @Test
    public void graph_00() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Node gn = NodeFactory.createURI("g");
        Graph g = GraphFactory.createDefaultGraph();
        g.add(SSE.parseTriple("(<s> <p> <o>)"));
        dsg.addGraph(gn, g);
        Assert.assertTrue((boolean)dsg.containsGraph(gn));
    }

    @Test
    public void graph_01() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Node g = NodeFactory.createURI("g");
        Triple t = SSE.parseTriple("(<s> <p> <o>)");
        dsg.getGraph(g).add(t);
        Assert.assertTrue((boolean)dsg.getGraph(g).contains(t));
        Quad quad = SSE.parseQuad("(quad <g> <s> <p> <o>)");
        Iterator<Quad> iter = dsg.find(null, null, null, null);
        Assert.assertTrue((boolean)iter.hasNext());
        Quad quad2 = iter.next();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((Object)quad, (Object)quad2);
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
        Assert.assertFalse((boolean)dsg.getGraph(NodeFactory.createURI("g")).isEmpty());
    }

    @Test
    public void graph_02() {
        Node g = NodeFactory.createURI("g");
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad = SSE.parseQuad("(quad <g> <s> <p> <o>)");
        dsg.add(quad);
        Triple t = SSE.parseTriple("(<s> <p> <o>)");
        dsg.getGraph(g).delete(t);
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
        Assert.assertTrue((boolean)dsg.getGraph(NodeFactory.createURI("g")).isEmpty());
        Assert.assertFalse((boolean)dsg.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY).hasNext());
    }

    @Test
    public void graph_03() {
        Node g = NodeFactory.createURI("g");
        DatasetGraph dsg = this.emptyDataset();
        Graph data = SSE.parseGraph("(graph (<s> <p> <o>))");
        dsg.addGraph(g, data);
        Quad quad = SSE.parseQuad("(quad <g> <s> <p> <o>)");
        Assert.assertTrue((boolean)dsg.contains(quad));
    }

    @Test
    public void find_01() {
        Node g1 = NodeFactory.createURI("g1");
        DatasetGraph dsg = this.emptyDataset();
        Quad quad1 = SSE.parseQuad("(quad <g1> <s1> <p1> <o1>)");
        Quad quad2 = SSE.parseQuad("(quad <g2> <s2> <p2> <o2>)");
        dsg.add(quad1);
        dsg.add(quad2);
        List<Quad> quads = Iter.toList(dsg.find(g1, null, null, null));
        Assert.assertEquals((long)1L, (long)quads.size());
        Quad q = quads.get(0);
        Assert.assertEquals((Object)quad1, (Object)q);
    }

    @Test
    public void deleteAny_01() {
        DatasetGraph dsg = this.emptyDataset();
        Node subject = NodeFactory.createURI("http://example/s");
        Node predicate = NodeFactory.createURI("http://example/p");
        Node object = NodeFactory.createBlankNode();
        dsg.add(new Quad(Quad.defaultGraphIRI, subject, predicate, object));
        dsg.deleteAny(Node.ANY, subject, null, null);
    }

    @Test
    public void deleteAny_02() {
        DatasetGraph dsg = this.emptyDataset();
        Node subject = NodeFactory.createURI("http://example/s");
        Node predicate = NodeFactory.createURI("http://example/p");
        Node object1 = NodeFactory.createBlankNode();
        Node object2 = NodeFactory.createBlankNode();
        Node graph = NodeFactory.createURI("http://example/g");
        dsg.add(graph, subject, predicate, object1);
        dsg.add(graph, subject, predicate, object2);
        dsg.deleteAny(Quad.defaultGraphIRI, null, null, null);
        List<Quad> quads = Iter.toList(dsg.find(graph, null, null, null));
        Assert.assertEquals((long)2L, (long)quads.size());
        dsg.deleteAny(graph, null, null, null);
        quads = Iter.toList(dsg.find(graph, null, null, null));
        Assert.assertEquals((long)0L, (long)quads.size());
    }

    @Test
    public void deleteAny_03() {
        DatasetGraph dsg = this.emptyDataset();
        Node subject = NodeFactory.createURI("http://example/s");
        Node predicate = NodeFactory.createURI("http://example/p");
        Node object1 = NodeFactory.createBlankNode();
        Node object2 = NodeFactory.createBlankNode();
        Node graph = NodeFactory.createURI("http://example/g");
        dsg.getDefaultGraph().add(Triple.create(subject, predicate, object1));
        dsg.getGraph(graph).add(Triple.create(subject, predicate, object2));
        dsg.deleteAny(Quad.defaultGraphIRI, null, null, null);
        List<Quad> quads = Iter.toList(dsg.find(Quad.defaultGraphIRI, null, null, null));
        Assert.assertEquals((long)0L, (long)quads.size());
        dsg.deleteAny(graph, null, null, null);
        quads = Iter.toList(dsg.find(graph, null, null, null));
        Assert.assertEquals((long)0L, (long)quads.size());
    }

    @Test
    public void deleteAny_04() {
        DatasetGraph dsg = this.emptyDataset();
        Node subject = NodeFactory.createURI("http://example/s");
        Node predicate = NodeFactory.createURI("http://example/p");
        Node object1 = NodeFactory.createBlankNode();
        Node object2 = NodeFactory.createBlankNode();
        Node graph = NodeFactory.createURI("http://example/g");
        Node graph2 = NodeFactory.createURI("http://example/abc");
        dsg.add(graph, subject, predicate, object1);
        dsg.add(graph, subject, predicate, object2);
        dsg.deleteAny(graph2, null, null, null);
        List<Quad> quads = Iter.toList(dsg.find(graph, null, null, null));
        Assert.assertEquals((long)2L, (long)quads.size());
        dsg.deleteAny(graph, null, null, null);
        quads = Iter.toList(dsg.find(graph, null, null, null));
        Assert.assertEquals((long)0L, (long)quads.size());
    }

    @Test
    public void clear_01() {
        DatasetGraph dsg = this.emptyDataset();
        Quad quad = SSE.parseQuad("(quad <g> <s> <p> <o>)");
        Node gn = SSE.parseNode("<g>");
        Assert.assertTrue((boolean)dsg.isEmpty());
        dsg.add(quad);
        Assert.assertFalse((boolean)dsg.isEmpty());
        Assert.assertTrue((boolean)dsg.containsGraph(gn));
        dsg.clear();
        Assert.assertTrue((boolean)dsg.isEmpty());
        Assert.assertFalse((boolean)dsg.containsGraph(gn));
    }

    @Test
    public void graph_clear_1() {
        DatasetGraph dsg = this.emptyDataset();
        if (!dsg.supportsTransactions()) {
            return;
        }
        Quad quad = SSE.parseQuad("(<g> <s> <p> 0)");
        Node gn = quad.getGraph();
        Txn.executeWrite(dsg, () -> {
            dsg.add(quad);
            dsg.getGraph(gn).clear();
            Assert.assertTrue((boolean)dsg.isEmpty());
        });
    }

    @Test
    public void graph_clear_2() {
        DatasetGraph dsg = this.emptyDataset();
        if (!dsg.supportsTransactions()) {
            return;
        }
        Quad quad = SSE.parseQuad("(<g> <s> <p> 0)");
        Node gn = quad.getGraph();
        Node gnx = NodeFactory.createURI("xyz");
        Txn.executeWrite(dsg, () -> {
            dsg.add(quad);
            dsg.getGraph(gnx).clear();
            Assert.assertFalse((boolean)dsg.isEmpty());
            Assert.assertFalse((boolean)dsg.getGraph(gn).isEmpty());
        });
    }

    @Test
    public void emptyGraph_1() {
        DatasetGraph dsg = this.emptyDataset();
        Node gn = NodeFactory.createURI("http://example/g");
        Quad q = SSE.parseQuad("(:g :s :p :o)");
        dsg.add(q);
        List<Node> nodes1 = Iter.toList(dsg.listGraphNodes());
        Assert.assertEquals((long)1L, (long)nodes1.size());
        dsg.delete(q);
        List<Node> nodes2 = Iter.toList(dsg.listGraphNodes());
        Assert.assertEquals((long)0L, (long)nodes2.size());
    }

    @Test
    public void emptyGraph_2() {
        DatasetGraph dsg = this.emptyDataset();
        Node gn = NodeFactory.createURI("http://example/g");
        Quad q = SSE.parseQuad("(:g :s :p :o)");
        dsg.add(q);
        Assert.assertTrue((boolean)dsg.containsGraph(gn));
        dsg.delete(q);
        Assert.assertFalse((boolean)dsg.containsGraph(gn));
    }

    @Test
    public void listGraphNodes_1() {
        DatasetGraph dsg = this.emptyDataset();
        Quad quad = SSE.parseQuad("(quad <g> <s> <p> <o>)");
        Node gn = SSE.parseNode("<g>");
        dsg.add(quad);
        List<Node> x = Iter.toList(dsg.listGraphNodes());
        Assert.assertEquals((long)1L, (long)x.size());
        Node gn2 = x.get(0);
        Assert.assertEquals((Object)gn, (Object)gn2);
    }

    @Test
    public void listGraphNodes_2() {
        DatasetGraph dsg = this.emptyDataset();
        Quad quad1 = SSE.parseQuad("(quad <g1> <s> <p> <o>)");
        Quad quad2 = SSE.parseQuad("(quad <g2> <s> <p> <o>)");
        Node gn1 = SSE.parseNode("<g1>");
        Node gn2 = SSE.parseNode("<g2>");
        dsg.add(quad1);
        dsg.add(quad2);
        List<Node> x = Iter.toList(dsg.listGraphNodes());
        List<Node> e2 = Arrays.asList(gn1, gn2);
        Assert.assertEquals((long)2L, (long)x.size());
        boolean b = ListUtils.equalsUnordered(e2, x);
        Assert.assertTrue((boolean)b);
    }

    @Test
    public void listGraphNodes_3() {
        DatasetGraph dsg = this.emptyDataset();
        Quad quad1 = SSE.parseQuad("(quad _ <s> <p> <o>)");
        Quad quad2 = SSE.parseQuad("(quad <g> <s> <p> <o>)");
        Node gn = SSE.parseNode("<g>");
        dsg.add(quad1);
        dsg.add(quad2);
        List<Node> x = Iter.toList(dsg.listGraphNodes());
        List<Node> e2 = Arrays.asList(gn);
        boolean b = ListUtils.equalsUnordered(e2, x);
        Assert.assertTrue((boolean)b);
    }
}

