/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.AssertExtra;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractDatasetGraphFindPatterns {
    static Quad q = SSE.parseQuad("(:g :s :p :o)");
    static Quad q_g = SSE.parseQuad("(:gx :s :p :o)");
    static Quad q_s = SSE.parseQuad("(:g :sx :p :o)");
    static Quad q_p = SSE.parseQuad("(:g :s :px :o)");
    static Quad q_o = SSE.parseQuad("(:g :s :p :ox)");
    static Quad q_gs = SSE.parseQuad("(:gx :sx :p :o)");
    static Quad q_gp = SSE.parseQuad("(:gx :s :px :o)");
    static Quad q_go = SSE.parseQuad("(:gx :s :p :ox)");
    static Quad q_sp = SSE.parseQuad("(:g :sx :px :o)");
    static Quad q_so = SSE.parseQuad("(:g :sx :p :ox)");
    static Quad q_po = SSE.parseQuad("(:g :s :px :ox)");
    static Quad q_gsp = SSE.parseQuad("(:gx :sx :px :o)");
    static Quad q_gpo = SSE.parseQuad("(:gx :s :px :ox)");
    static Quad q_gso = SSE.parseQuad("(:gx :sx :p :ox)");
    static Quad q_spo = SSE.parseQuad("(:g :sx :px :ox)");
    static Quad q_gspo = SSE.parseQuad("(:gx :sx :px :ox)");
    static List<Quad> dataPattern = Arrays.asList(q, q_g, q_s, q_p, q_o, q_gs, q_gp, q_go, q_sp, q_so, q_po, q_gsp, q_gpo, q_gso, q_spo, q_gspo);

    static void add(DatasetGraph data, Collection<Quad> quads) {
        for (Quad q : quads) {
            data.add(q);
        }
    }

    protected DatasetGraph create(Collection<Quad> data) {
        DatasetGraph dsg = this.create();
        AbstractDatasetGraphFindPatterns.add(dsg, data);
        return dsg;
    }

    protected abstract DatasetGraph create();

    private Node node(String str2) {
        return SSE.parseNode(str2);
    }

    @Test
    public void find_quad_00() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find());
        Assert.assertNotNull((String)"find()", quads1);
        List<Quad> quads2 = Iter.toList(dsg.find(null, null, null, null));
        Assert.assertNotNull((String)"find(null,null,null,null)", quads2);
        AssertExtra.assertEqualsUnordered((String)"find()", quads1, quads2);
    }

    @Test
    public void find_pattern_gspo() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find(this.node(":g"), this.node(":s"), this.node(":p"), this.node(":o")));
        Assert.assertNotNull((String)"find(g,s,p,o)", quads1);
        List<Quad> quads2 = Arrays.asList(q);
        AssertExtra.assertEqualsUnordered((String)"find(gspo)", quads1, quads2);
    }

    @Test
    public void find_pattern_g() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find(this.node(":gx"), null, null, null));
        List<Quad> quads2 = Arrays.asList(q_g, q_gs, q_gp, q_go, q_gsp, q_gso, q_gpo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(g)", quads1, quads2);
    }

    @Test
    public void find_pattern_s() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find(null, this.node(":sx"), null, null));
        List<Quad> quads2 = Arrays.asList(q_s, q_gs, q_sp, q_so, q_gsp, q_gso, q_spo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(s)", quads1, quads2);
    }

    @Test
    public void find_pattern_p() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find(null, null, this.node(":px"), null));
        List<Quad> quads2 = Arrays.asList(q_p, q_gp, q_sp, q_po, q_gsp, q_gpo, q_spo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(p)", quads1, quads2);
    }

    @Test
    public void find_pattern_o() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find(null, null, null, this.node(":ox")));
        List<Quad> quads2 = Arrays.asList(q_o, q_go, q_so, q_po, q_gpo, q_gso, q_spo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(o)", quads1, quads2);
    }

    @Test
    public void find_pattern_gs() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find(this.node(":gx"), this.node(":sx"), null, null));
        List<Quad> quads2 = Arrays.asList(q_gs, q_gsp, q_gso, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(gs)", quads1, quads2);
    }

    @Test
    public void find_pattern_gp() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find(this.node(":gx"), null, this.node(":px"), null));
        List<Quad> quads2 = Arrays.asList(q_gp, q_gsp, q_gpo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(gp)", quads1, quads2);
    }

    @Test
    public void find_pattern_go() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find(this.node(":gx"), null, null, this.node(":ox")));
        List<Quad> quads2 = Arrays.asList(q_go, q_gpo, q_gso, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(go)", quads1, quads2);
    }

    @Test
    public void find_pattern_sp() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find(null, this.node(":sx"), this.node(":px"), null));
        List<Quad> quads2 = Arrays.asList(q_sp, q_gsp, q_spo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(sp)", quads1, quads2);
    }

    @Test
    public void find_pattern_so() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find(null, this.node(":sx"), null, this.node(":ox")));
        List<Quad> quads2 = Arrays.asList(q_so, q_gso, q_spo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(so)", quads1, quads2);
    }

    @Test
    public void find_pattern_po() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find(null, null, this.node(":px"), this.node(":ox")));
        List<Quad> quads2 = Arrays.asList(q_po, q_gpo, q_spo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(po)", quads1, quads2);
    }

    @Test
    public void find_pattern_gsp() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find(this.node(":gx"), this.node(":sx"), this.node(":px"), null));
        List<Quad> quads2 = Arrays.asList(q_gsp, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(gsp)", quads1, quads2);
    }

    @Test
    public void find_pattern_gpo() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find(this.node(":gx"), null, this.node(":px"), this.node(":ox")));
        List<Quad> quads2 = Arrays.asList(q_gpo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(gpo)", quads1, quads2);
    }

    @Test
    public void find_pattern_gso() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find(this.node(":gx"), null, this.node(":px"), this.node(":ox")));
        List<Quad> quads2 = Arrays.asList(q_gpo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(gso)", quads1, quads2);
    }

    @Test
    public void find_pattern_spo() {
        DatasetGraph dsg = this.create(dataPattern);
        List<Quad> quads1 = Iter.toList(dsg.find(null, this.node(":sx"), this.node(":px"), this.node(":ox")));
        List<Quad> quads2 = Arrays.asList(q_spo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(spo)", quads1, quads2);
    }
}

