/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.AssertExtra;
import org.apache.jena.atlas.lib.StreamOps;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphBaseFind;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractDatasetGraphFind {
    static Node s = SSE.parseNode(":s");
    static Node p = SSE.parseNode(":p");
    static Node o = SSE.parseNode(":o");
    static Node g1 = SSE.parseNode(":g1");
    static Quad q1 = Quad.create(Quad.defaultGraphIRI, s, p, o);
    static Quad q2 = Quad.create(Quad.defaultGraphIRI, s, p, NodeConst.nodeZero);
    static Quad q3 = SSE.parseQuad("(:g1 :s :p :o)");
    static Quad q4 = SSE.parseQuad("(:g1 :s :p 1)");
    static Quad q5 = SSE.parseQuad("(:g2 :s :p :o)");
    static Quad q6 = SSE.parseQuad("(:g2 :s :p 1)");
    static Quad q7 = SSE.parseQuad("(:g2 :s :p 2)");
    static Quad q8 = SSE.parseQuad("(:g3 :s :p :o)");
    static Quad q9 = SSE.parseQuad("(:g3 :s :p 1)");
    static Quad q10 = SSE.parseQuad("(:g3 :s :p 2)");
    static List<Quad> data = Arrays.asList(q1, q2, q3, q4, q5, q6, q7, q8, q9, q10);
    private DatasetGraph dsg;

    static void add(DatasetGraph data, Collection<Quad> quads) {
        for (Quad q : quads) {
            data.add(q);
        }
    }

    protected DatasetGraph create(Collection<Quad> data) {
        DatasetGraph dsg = this.create();
        AbstractDatasetGraphFind.add(dsg, data);
        return dsg;
    }

    protected abstract DatasetGraph create();

    protected DatasetGraphBaseFind createFind(DatasetGraph dsg) {
        try {
            return (DatasetGraphBaseFind)dsg;
        }
        catch (ClassCastException ex) {
            Assert.fail((String)("Not a DatasetGraphBaseFind: " + dsg.getClass().getSimpleName()));
            return null;
        }
    }

    @Before
    public void setup() {
        this.dsg = this.create(data);
    }

    @Test
    public void find_quad_01() {
        List<Quad> x = Iter.toList(this.dsg.find());
        Assert.assertEquals((long)10L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q1));
        Assert.assertTrue((boolean)x.contains(q5));
    }

    @Test
    public void find_quad_02() {
        List<Quad> x = Iter.toList(this.dsg.find(null, s, p, o));
        Assert.assertEquals((long)4L, (long)x.size());
        Assert.assertFalse((boolean)x.contains(q2));
        Assert.assertFalse((boolean)x.contains(q4));
        Assert.assertTrue((boolean)x.contains(q5));
    }

    @Test
    public void find_ng_01() {
        List<Quad> x = Iter.toList(this.dsg.findNG(null, null, null, null));
        Assert.assertEquals((long)8L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q4));
        Assert.assertTrue((boolean)x.contains(q10));
        Assert.assertFalse((boolean)x.contains(q1));
    }

    @Test
    public void find_ng_02() {
        List<Quad> x = Iter.toList(this.dsg.findNG(null, s, p, o));
        Assert.assertEquals((long)3L, (long)x.size());
        Assert.assertFalse((boolean)x.contains(q4));
        Assert.assertFalse((boolean)x.contains(q1));
        Assert.assertTrue((boolean)x.contains(q3));
        Assert.assertTrue((boolean)x.contains(q5));
        Assert.assertTrue((boolean)x.contains(q8));
    }

    @Test
    public void find_specific_01() {
        List<Quad> x = Iter.toList(this.dsg.find(g1, null, null, null));
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q4));
        Assert.assertTrue((boolean)x.contains(q3));
    }

    @Test
    public void find_specific_02() {
        List<Quad> x = Iter.toList(this.dsg.find(g1, null, null, NodeConst.nodeOne));
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q4));
    }

    @Test
    public void find_dft_01() {
        List<Quad> x = Iter.toList(this.dsg.find(Quad.defaultGraphIRI, null, null, null));
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q1));
        Assert.assertTrue((boolean)x.contains(q2));
    }

    @Test
    public void find_dft_02() {
        List<Quad> x = Iter.toList(this.dsg.find(Quad.defaultGraphIRI, null, null, NodeConst.nodeOne));
        Assert.assertEquals((long)0L, (long)x.size());
    }

    @Test
    public void find_dft_03() {
        List<Quad> x = Iter.toList(this.dsg.find(Quad.defaultGraphIRI, null, null, NodeConst.nodeZero));
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q2));
    }

    @Test
    public void find_union_01() {
        List<Quad> x = Iter.toList(this.dsg.find(Quad.unionGraph, null, null, null));
        Assert.assertEquals((long)3L, (long)x.size());
        x.stream().allMatch(q -> q.getGraph().equals(Quad.unionGraph));
        List z = x.stream().map(Quad::asTriple).collect(Collectors.toList());
        Assert.assertTrue((boolean)z.contains(q4.asTriple()));
        Assert.assertTrue((boolean)z.contains(q5.asTriple()));
        Quad qx = Quad.create(Quad.unionGraph, q4.asTriple());
        Assert.assertTrue((boolean)x.contains(qx));
        Quad qz = Quad.create(Quad.unionGraph, q2.asTriple());
        Assert.assertFalse((boolean)x.contains(qz));
    }

    @Test
    public void find_union_02() {
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        Assert.assertNotNull((Object)dsgx.getUnionGraph());
        List<Triple> x = Iter.toList(dsgx.getUnionGraph().find(null, null, null));
        Assert.assertEquals((long)3L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q4.asTriple()));
        Assert.assertTrue((boolean)x.contains(q5.asTriple()));
        Assert.assertTrue((boolean)x.contains(q10.asTriple()));
    }

    @Test
    public void find_union_03() {
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        Assert.assertNotNull((Object)dsgx.getUnionGraph());
        Set<Triple> x1 = Iter.toSet(dsgx.getUnionGraph().find(null, null, null));
        Set<Triple> x2 = Iter.iter(this.dsg.find(Quad.unionGraph, null, null, null)).map(Quad::asTriple).toSet();
        Assert.assertEquals(x1, x2);
    }

    @Test(expected=AddDeniedException.class)
    public void find_union_04() {
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        dsgx.getUnionGraph().add(q4.asTriple());
    }

    @Test(expected=DeleteDeniedException.class)
    public void find_union_05() {
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        dsgx.getUnionGraph().delete(q4.asTriple());
    }

    @Test
    public void find_dsgFind_union_02() {
        Assume.assumeTrue((String)"Not a DatasetGraphBaseFind", (boolean)(this.dsg instanceof DatasetGraphBaseFind));
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        List<Triple> x = Iter.toList(dsgx.findInUnionGraph(null, null, null));
        Assert.assertEquals((long)3L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q4.asTriple()));
        Assert.assertTrue((boolean)x.contains(q5.asTriple()));
        Assert.assertTrue((boolean)x.contains(q10.asTriple()));
    }

    @Test
    public void find_dsgFind_union_03() {
        Assume.assumeTrue((String)"Not a DatasetGraphBaseFind", (boolean)(this.dsg instanceof DatasetGraphBaseFind));
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        List<Triple> x1 = Iter.toList(dsgx.findInUnionGraph(null, null, null));
        List<Triple> x2 = AbstractDatasetGraphFind.quadsToDistinctTriples(this.dsg.find(Quad.unionGraph, null, null, null));
        AssertExtra.assertEqualsUnordered(x1, x2);
        Assert.assertEquals((long)3L, (long)x2.size());
    }

    @Test
    public void find_dsgFind_union_04() {
        Assume.assumeTrue((String)"Not a DatasetGraphBaseFind", (boolean)(this.dsg instanceof DatasetGraphBaseFind));
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        List<Triple> x = Iter.toList(dsgx.findInUnionGraph(null, null, o));
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q3.asTriple()));
    }

    @Test
    public void find_dsgFind_union_05() {
        Assume.assumeTrue((String)"Not a DatasetGraphBaseFind", (boolean)(this.dsg instanceof DatasetGraphBaseFind));
        DatasetGraphBaseFind dsgx = (DatasetGraphBaseFind)this.dsg;
        List<Triple> x1 = Iter.toList(dsgx.findInUnionGraph(null, null, o));
        List<Triple> x2 = AbstractDatasetGraphFind.quadsToDistinctTriples(this.dsg.find(Quad.unionGraph, null, null, o));
        AssertExtra.assertEqualsUnordered(x1, x2);
        Assert.assertEquals((long)1L, (long)x2.size());
    }

    @Test
    public void stream_dsg_01() {
        List<Quad> x = StreamOps.toList(this.dsg.stream());
        Assert.assertEquals((long)10L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(q1));
        Assert.assertTrue((boolean)x.contains(q5));
    }

    @Test
    public void stream_dsg_02() {
        List<Quad> x = StreamOps.toList(this.dsg.stream(null, s, p, o));
        Assert.assertEquals((long)4L, (long)x.size());
        Assert.assertFalse((boolean)x.contains(q2));
        Assert.assertFalse((boolean)x.contains(q4));
        Assert.assertTrue((boolean)x.contains(q5));
    }

    static List<Triple> quadsToDistinctTriples(Iterator<Quad> iter) {
        return Iter.asStream(iter).map(Quad::asTriple).distinct().collect(Collectors.toList());
    }

    static void print(List<Quad> x) {
        ((Stream)x.stream().sequential()).forEach(System.out::println);
    }
}

