/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.api;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.base.Sys;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.sparql.api.TestQueryExecutionTimeout1;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.engine.binding.Binding;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestQueryExecutionTimeout2 {
    private static String prefix = "PREFIX f:       <http://example/ns#>\nPREFIX afn:     <http://jena.apache.org/ARQ/function#>\n";
    static Graph g = TestQueryExecutionTimeout1.makeGraph(10);
    static DatasetGraph dsg = DatasetGraphFactory.wrap(g);
    static Dataset ds = DatasetFactory.wrap(dsg);
    private static boolean mayBeErratic = Sys.isWindows || Sys.isMacOS;

    @Before
    public void beforeTest() {
        Assume.assumeFalse((boolean)Sys.isMacOS);
    }

    @Test
    public void timeout_30() {
        TestQueryExecutionTimeout2.test2(200L, 20L, this.timeout(50, 250), true);
    }

    @Test
    public void timeout_31() {
        TestQueryExecutionTimeout2.test2(200L, 100L, 20, false);
    }

    @Test
    public void timeout_32() {
        TestQueryExecutionTimeout2.test2(100L, 500L, 200, false);
    }

    @Test
    public void timeout_33() {
        TestQueryExecutionTimeout2.test2(150L, -1L, 200, false);
    }

    @Test
    public void timeout_34() {
        TestQueryExecutionTimeout2.test2(10L, 40L, this.timeout(100, 250), true);
    }

    @Test
    public void timeout_35() {
        TestQueryExecutionTimeout2.test2(-1L, 20L, this.timeout(50, 250), true);
    }

    @Test
    public void timeout_36() {
        TestQueryExecutionTimeout2.test2(-1L, 200L, 20, false);
    }

    @Test
    public void timeout_37() {
        TestQueryExecutionTimeout2.test2(200L, 200L, 50, false);
    }

    @Test
    public void timeout_38() {
        TestQueryExecutionTimeout2.test2(200L, -1L, 50, false);
    }

    private static void test2(long timeout1, long timeout2, int delay, boolean exceptionExpected) {
        QueryExecution qExec = QueryExecutionFactory.create(prefix + "SELECT * { ?s ?p ?o }", ds);
        try {
            qExec.setTimeout(timeout1, timeout2);
            ResultSet rs = qExec.execSelect();
            try {
                Binding binding = rs.nextBinding();
            }
            catch (QueryCancelledException ex) {
                Assert.fail((String)"QueryCancelledException not expected at start");
                if (qExec != null) {
                    qExec.close();
                }
                return;
            }
            Lib.sleep(delay);
            if (exceptionExpected) {
                TestQueryExecutionTimeout2.exceptionExpected(rs);
            } else {
                TestQueryExecutionTimeout2.noException(rs);
            }
        }
        finally {
            if (qExec != null) {
                try {
                    qExec.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private static void noException(ResultSet rs) {
        ResultSetFormatter.consume(rs);
    }

    private static void exceptionExpected(ResultSet rs) {
        try {
            ResultSetFormatter.consume(rs);
            Assert.fail((String)"QueryCancelledException expected");
        }
        catch (QueryCancelledException queryCancelledException) {
            // empty catch block
        }
    }

    private int timeout(int time1, int time2) {
        return mayBeErratic ? time2 : time1;
    }
}

