/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.api;

import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.base.Sys;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.function.library.wait;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.sse.SSE;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestQueryExecutionTimeout1 {
    static Graph g = TestQueryExecutionTimeout1.makeGraph(100);
    static DatasetGraph dsg = DatasetGraphFactory.wrap(g);
    static Dataset ds = DatasetFactory.wrap(dsg);
    private static final String ns = "http://example/ns#";
    private static boolean mayBeErratic = Sys.isWindows;
    private static String prefix = "PREFIX f:       <http://example/ns#>\nPREFIX afn:     <http://jena.apache.org/ARQ/function#>\n";

    @BeforeClass
    public static void beforeClass() {
        FunctionRegistry.get().put("http://example/ns#wait", wait.class);
    }

    static Graph makeGraph(int size) {
        Graph g = GraphFactory.createDefaultGraph();
        Node s = SSE.parseNode("<s>");
        Node p = SSE.parseNode("<p>");
        for (int i = 1; i < size; ++i) {
            Node o = SSE.parseNode("<o-" + i + ">");
            g.add(Triple.create(s, p, o));
        }
        return g;
    }

    @AfterClass
    public static void afterClass() {
        FunctionRegistry.get().remove("http://example/ns#wait");
    }

    private int timeout(int time1, int time2) {
        return mayBeErratic ? time2 : time1;
    }

    @Test
    public void timeout_01() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        QueryExecution qExec = QueryExecutionFactory.create(qs, ds);
        qExec.setTimeout(50L, TimeUnit.MILLISECONDS);
        ResultSet rs = qExec.execSelect();
        TestQueryExecutionTimeout1.exceptionExpected(rs, 100, 100, 500);
    }

    @Test
    public void timeout_02() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        QueryExecution qExec = QueryExecutionFactory.create(qs, ds);
        qExec.setTimeout(50L, TimeUnit.MILLISECONDS);
        ResultSet rs = qExec.execSelect();
        TestQueryExecutionTimeout1.exceptionExpected(rs, 10, 100, 1000);
    }

    @Test
    public void timeout_03() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        QueryExecution qExec = QueryExecutionFactory.create(qs, ds);
        qExec.setTimeout(100L, TimeUnit.MILLISECONDS);
        ResultSet rs = qExec.execSelect();
        ResultSetFormatter.consume(rs);
        qExec.close();
        qExec.abort();
    }

    @Test
    public void timeout_04() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        try (QueryExecution qExec = QueryExecutionFactory.create(qs, ds);){
            qExec.setTimeout(50L, TimeUnit.MILLISECONDS);
            ResultSet rs = qExec.execSelect();
            ResultSetFormatter.consume(rs);
            Lib.sleep(100);
            rs.hasNext();
        }
    }

    @Test
    public void timeout_06() {
        String qs = prefix + "SELECT * { ?s ?p ?o FILTER f:wait(1) }";
        try (QueryExecution qExec = QueryExecutionFactory.create(qs, ds);){
            qExec.setTimeout(100L, TimeUnit.MILLISECONDS);
            ResultSet rs = qExec.execSelect();
            ResultSetFormatter.consume(rs);
        }
    }

    @Test
    public void timeout_07() {
        String qs = prefix + "SELECT * { ?s ?p ?o FILTER f:wait(1) }";
        try (QueryExecution qExec = QueryExecutionFactory.create(qs, ds);){
            ResultSet rs = qExec.execSelect();
            ResultSetFormatter.consume(rs);
        }
    }

    @Test
    public void timeout_08() {
        String qs = prefix + "SELECT * { ?s ?p ?o FILTER f:wait(1) }";
        try (QueryExecution qExec = QueryExecutionFactory.create(qs, ds);){
            qExec.setTimeout(-1L, TimeUnit.MILLISECONDS);
            ResultSet rs = qExec.execSelect();
            ResultSetFormatter.consume(rs);
        }
    }

    @Test
    public void timeout_09() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        try (QueryExecution qExec = QueryExecutionFactory.create(qs, ds);){
            qExec.setTimeout(500L, TimeUnit.MILLISECONDS, -1L, TimeUnit.MILLISECONDS);
            ResultSet rs = qExec.execSelect();
            rs.next();
            rs.next();
            Assert.assertTrue((boolean)rs.hasNext());
            ResultSetFormatter.consume(rs);
        }
    }

    @Test
    public void timeout_10() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        try (QueryExecution qExec = QueryExecutionFactory.create(qs, ds);){
            qExec.setTimeout(100L, TimeUnit.MILLISECONDS, 100L, TimeUnit.MILLISECONDS);
            ResultSet rs = qExec.execSelect();
            rs.next();
            rs.next();
            Assert.assertTrue((boolean)rs.hasNext());
            TestQueryExecutionTimeout1.exceptionExpected(rs, 200, 100, 500);
        }
    }

    @Test
    public void timeout_11() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        try (QueryExecution qExec = QueryExecutionFactory.create(qs, ds);){
            qExec.setTimeout(-1L, TimeUnit.MILLISECONDS, 100L, TimeUnit.MILLISECONDS);
            ResultSet rs = qExec.execSelect();
            rs.next();
            rs.next();
            TestQueryExecutionTimeout1.exceptionExpected(rs, 200, 100, 500);
        }
    }

    @Test
    public void timeout_20() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        ARQ.getContext().set(ARQ.queryTimeout, "10");
        QueryExecution qExec = QueryExecutionFactory.create(qs, ds);
        ResultSet rs = qExec.execSelect();
        TestQueryExecutionTimeout1.exceptionExpected(rs, 50, 50, 150);
    }

    @Test
    public void timeout_21() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        ARQ.getContext().set(ARQ.queryTimeout, "20,10");
        QueryExecution qExec = QueryExecutionFactory.create(qs, ds);
        ResultSet rs = qExec.execSelect();
        TestQueryExecutionTimeout1.exceptionExpected(rs, 50, 50, 150);
    }

    @Test
    public void timeout_22() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        ARQ.getContext().set(ARQ.queryTimeout, "-1");
        try (QueryExecution qExec = QueryExecutionFactory.create(qs, ds);){
            ResultSet rs = qExec.execSelect();
            ResultSetFormatter.consume(rs);
        }
    }

    private static void exceptionExpected(ResultSet rs, int initialWait, int pollInterval, int maxWaitMillis) {
        int intervals = (maxWaitMillis - initialWait + 1) / pollInterval;
        if (initialWait > 0) {
            Lib.sleep(initialWait);
        }
        long start = System.currentTimeMillis();
        long endTime = start + (long)maxWaitMillis;
        long now2 = start;
        for (int i = 0; i < intervals && now2 - start <= (long)maxWaitMillis; ++i) {
            try {
                if (!rs.hasNext()) break;
                rs.next();
            }
            catch (QueryCancelledException ex) {
                return;
            }
            Lib.sleep(pollInterval);
            now2 = System.currentTimeMillis();
        }
        Assert.fail((String)"QueryCancelledException expected");
    }
}

