/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.api;

import org.apache.jena.query.Query;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.function.library.wait;
import org.apache.jena.sparql.graph.GraphFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestQueryExecutionCancel {
    private static final String ns = "http://example/ns#";
    static Model m = GraphFactory.makeJenaDefaultModel();
    static Resource r1 = m.createResource();
    static Property p1 = m.createProperty("http://example/ns#p1");
    static Property p2 = m.createProperty("http://example/ns#p2");
    static Property p3 = m.createProperty("http://example/ns#p3");

    @BeforeClass
    public static void beforeClass() {
        FunctionRegistry.get().put("http://example/ns#wait", wait.class);
    }

    @AfterClass
    public static void afterClass() {
        FunctionRegistry.get().remove("http://example/ns#wait");
    }

    @Test(expected=QueryCancelledException.class)
    public void test_Cancel_API_1() {
        try (QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");){
            ResultSet rs = qExec.execSelect();
            Assert.assertTrue((boolean)rs.hasNext());
            qExec.abort();
            Assert.assertTrue((boolean)rs.hasNext());
            rs.nextSolution();
            Assert.assertFalse((String)"Results not expected after cancel.", (boolean)rs.hasNext());
        }
    }

    @Test(expected=QueryCancelledException.class)
    public void test_Cancel_API_2() {
        try (QueryExecution qExec = this.makeQExec("PREFIX ex: <http://example/ns#> SELECT * {?s ?p ?o . FILTER ex:wait(100) }");){
            ResultSet rs = qExec.execSelect();
            Assert.assertTrue((boolean)rs.hasNext());
            qExec.abort();
            Assert.assertTrue((boolean)rs.hasNext());
            rs.nextSolution();
            Assert.assertFalse((String)"Results not expected after cancel.", (boolean)rs.hasNext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_Cancel_API_3() throws InterruptedException {
        QueryExecution qExec = this.makeQExec("PREFIX ex: <http://example/ns#> SELECT * { ?s ?p ?o . FILTER ex:wait(100) }");
        CancelThreadRunner thread = new CancelThreadRunner(qExec);
        thread.start();
        QueryExecution queryExecution = qExec;
        synchronized (queryExecution) {
            qExec.wait();
        }
        queryExecution = qExec;
        synchronized (queryExecution) {
            qExec.abort();
        }
        queryExecution = qExec;
        synchronized (queryExecution) {
            qExec.notify();
        }
        Assert.assertEquals((long)1L, (long)thread.getCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_Cancel_API_4() throws InterruptedException {
        QueryExecution qExec = this.makeQExec("PREFIX ex: <http://example/ns#> SELECT * { ?s ?p ?o } ORDER BY ex:wait(100)");
        CancelThreadRunner thread = new CancelThreadRunner(qExec);
        thread.start();
        QueryExecution queryExecution = qExec;
        synchronized (queryExecution) {
            qExec.wait();
        }
        queryExecution = qExec;
        synchronized (queryExecution) {
            qExec.abort();
        }
        queryExecution = qExec;
        synchronized (queryExecution) {
            qExec.notify();
        }
        Assert.assertEquals((long)1L, (long)thread.getCount());
    }

    private QueryExecution makeQExec(String queryString) {
        Query q = QueryFactory.create(queryString);
        QueryExecution qExec = QueryExecutionFactory.create(q, m);
        return qExec;
    }

    static {
        m.add(r1, p1, "x1");
        m.add(r1, p2, "X2");
        m.add(r1, p3, "y1");
    }

    class CancelThreadRunner
    extends Thread {
        private QueryExecution qExec = null;
        private int count = 0;

        public CancelThreadRunner(QueryExecution qExec) {
            this.qExec = qExec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                ResultSet rs = this.qExec.execSelect();
                while (rs.hasNext()) {
                    rs.nextSolution();
                    ++this.count;
                    QueryExecution queryExecution = this.qExec;
                    synchronized (queryExecution) {
                        this.qExec.notify();
                    }
                    queryExecution = this.qExec;
                    synchronized (queryExecution) {
                        this.qExec.wait();
                    }
                }
                return;
            }
            catch (QueryCancelledException rs) {
                return;
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
                return;
            }
            finally {
                this.qExec.close();
            }
        }

        public int getCount() {
            return this.count;
        }
    }
}

