/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.api;

import java.util.Iterator;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetCloseable;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.util.IsoMatcher;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;

public class TestAPI {
    private static final String ns = "http://example/ns#";
    static Model m = GraphFactory.makeJenaDefaultModel();
    static Resource r1 = m.createResource();
    static Property p1 = m.createProperty("http://example/ns#p1");
    static Property p2 = m.createProperty("http://example/ns#p2");
    static Property p3 = m.createProperty("http://example/ns#p3");
    static Model dft = GraphFactory.makeJenaDefaultModel();
    static Resource s = dft.createResource("http://example/ns#s");
    static Property p = dft.createProperty("http://example/ns#p");
    static Resource o = dft.createResource("http://example/ns#o");
    static Resource g1 = dft.createResource("http://example/ns#g1");
    static Dataset d = null;

    @Test
    public void testInitialBindingsConstruct1() {
        try (QueryExecution qExec = this.makeQExec("CONSTRUCT {?s ?p ?z} {?s ?p 'x1'}");){
            QuerySolutionMap init = new QuerySolutionMap();
            init.add("z", m.createLiteral("zzz"));
            qExec.setInitialBinding(init);
            Model r = qExec.execConstruct();
            Assert.assertTrue((String)"Empty model", (r.size() > 0L ? 1 : 0) != 0);
            Property p1 = m.createProperty("http://example/ns#p1");
            Assert.assertTrue((String)"Empty model", (boolean)r.contains(null, p1, init.get("z")));
        }
    }

    @Test
    public void testInitialBindingsConstruct2() {
        try (QueryExecution qExec = this.makeQExec("CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o }");){
            QuerySolutionMap init = new QuerySolutionMap();
            init.add("o", m.createLiteral("x1"));
            qExec.setInitialBinding(init);
            Model r = qExec.execConstruct();
            Assert.assertTrue((String)"Empty model", (r.size() > 0L ? 1 : 0) != 0);
            Property p1 = m.createProperty("http://example/ns#p1");
            Assert.assertTrue((String)"Empty model", (boolean)r.contains(null, p1, init.get("x1")));
        }
    }

    @Test
    public void test_API1() {
        try (QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");){
            ResultSet rs = qExec.execSelect();
            Assert.assertTrue((String)"No results", (boolean)rs.hasNext());
            QuerySolution qs = rs.nextSolution();
            Resource qr = qs.getResource("s");
            Set s1 = qr.getModel().listStatements().toSet();
            Set s2 = m.listStatements().toSet();
            Assert.assertEquals(s1, s2);
        }
    }

    @Test
    public void testInitialBindings0() {
        QuerySolutionMap smap1 = new QuerySolutionMap();
        QuerySolutionMap smap2 = new QuerySolutionMap();
        smap1.add("o", m.createLiteral("y1"));
        smap2.addAll(smap1);
        Assert.assertTrue((boolean)smap2.contains("o"));
        smap2.clear();
        Assert.assertFalse((boolean)smap2.contains("o"));
        Assert.assertTrue((boolean)smap1.contains("o"));
        QuerySolutionMap smap3 = new QuerySolutionMap();
        smap2.addAll((QuerySolution)smap1);
        Assert.assertTrue((boolean)smap2.contains("o"));
    }

    @Test
    public void testInitialBindings1() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("o", m.createLiteral("y1"));
        qExec.setInitialBinding(init);
        int count = this.queryAndCount(qExec);
        Assert.assertEquals((String)"Initial binding didn't restrict query properly", (long)1L, (long)count);
    }

    @Test
    public void testInitialBindings2() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("z", m.createLiteral("zzz"));
        qExec.setInitialBinding(init);
        int count = this.queryAndCount(qExec);
        Assert.assertEquals((String)"Initial binding restricted query improperly", (long)3L, (long)count);
    }

    @Test
    public void testInitialBindings3() {
        try (QueryExecution qExec = this.makeQExec("SELECT * {?s ?p 'x1'}");){
            QuerySolutionMap init = new QuerySolutionMap();
            init.add("z", m.createLiteral("zzz"));
            qExec.setInitialBinding(init);
            ResultSet rs = qExec.execSelect();
            QuerySolution qs = rs.nextSolution();
            Assert.assertTrue((String)"Initial setting not set correctly now", (boolean)qs.getLiteral("z").getLexicalForm().equals("zzz"));
        }
    }

    @Test
    public void testInitialBindings4() {
        String queryString = "PREFIX : <http://example/ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT * \nWHERE { \n    ?x :p1 ?z .    NOT EXISTS { \n        ?x rdfs:label ?z . \n    }\n}";
        Query query2 = QueryFactory.create(queryString, Syntax.syntaxARQ);
        try (QueryExecution qexec = QueryExecutionFactory.create(query2, m);){
            QuerySolutionMap map = new QuerySolutionMap();
            map.add("this", OWL.Thing);
            qexec.setInitialBinding(map);
            ResultSet rs = qexec.execSelect();
            while (rs.hasNext()) {
                QuerySolution querySolution = rs.nextSolution();
            }
        }
    }

    @Test
    public void testInitialBindings5() {
        Query query2 = QueryFactory.create("ASK\nWHERE {\n    FILTER (?a = <http://constant>) .\n}");
        Model model = ModelFactory.createDefaultModel();
        model.add(OWL.Thing, RDF.type, OWL.Class);
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("a", ResourceFactory.createResource("http://constant"));
        QueryExecution qexec = QueryExecutionFactory.create(query2, model, (QuerySolution)initialBinding);
        boolean result = qexec.execAsk();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testInitialBindings6() {
        Query query2 = QueryFactory.create("ASK\nWHERE {\n    FILTER (?a = ?b) .\n}");
        Model model = ModelFactory.createDefaultModel();
        model.add(OWL.Thing, RDF.type, OWL.Class);
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("a", ResourceFactory.createTypedLiteral(Boolean.TRUE));
        initialBinding.add("b", ResourceFactory.createTypedLiteral(Boolean.TRUE));
        QueryExecution qexec = QueryExecutionFactory.create(query2, model, (QuerySolution)initialBinding);
        boolean result = qexec.execAsk();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testInitialBindings7() {
        Query query2 = QueryFactory.create("SELECT DISTINCT ?x WHERE {}");
        Dataset ds = DatasetFactory.create();
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("a", ResourceFactory.createTypedLiteral(Boolean.TRUE));
        try (QueryExecution qexec = QueryExecutionFactory.create(query2, ds, (QuerySolution)initialBinding);){
            Assert.assertFalse((boolean)qexec.execSelect().next().contains("a"));
        }
    }

    @Test
    public void testReuseQueryObject1() {
        String queryString = "SELECT * {?s ?p ?o}";
        Query q = QueryFactory.create(queryString);
        QueryExecution qExec = QueryExecutionFactory.create(q, m);
        int count = this.queryAndCount(qExec);
        Assert.assertEquals((long)3L, (long)count);
        qExec = QueryExecutionFactory.create(q, m);
        count = this.queryAndCount(qExec);
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testReuseQueryObject2() {
        QuerySolution qs;
        ResultSet rs;
        String queryString = "SELECT (count(?o) AS ?c) {?s ?p ?o} GROUP BY ?s";
        Query q = QueryFactory.create(queryString);
        try (QueryExecution qExec = QueryExecutionFactory.create(q, m);){
            rs = qExec.execSelect();
            qs = rs.nextSolution();
            Assert.assertEquals((long)3L, (long)qs.getLiteral("c").getInt());
        }
        qExec = QueryExecutionFactory.create(q, m);
        try {
            rs = qExec.execSelect();
            qs = rs.nextSolution();
            Assert.assertEquals((long)3L, (long)qs.getLiteral("c").getInt());
        }
        finally {
            if (qExec != null) {
                qExec.close();
            }
        }
    }

    @Test
    public void testConstructRejectsBadTriples1() {
        String queryString = "CONSTRUCT { ?s ?p ?o } WHERE { ?o ?p ?s }";
        Query q = QueryFactory.create(queryString);
        QueryExecution qExec = QueryExecutionFactory.create(q, m);
        Model resultModel = qExec.execConstruct();
        Assert.assertEquals((long)0L, (long)resultModel.size());
    }

    @Test
    public void testConstructRejectsBadTriples2() {
        String queryString = "CONSTRUCT { ?s ?p ?o } WHERE { ?o ?p ?s }";
        Query q = QueryFactory.create(queryString);
        QueryExecution qExec = QueryExecutionFactory.create(q, m);
        Iterator<Triple> ts = qExec.execConstructTriples();
        long count = 0L;
        while (ts.hasNext()) {
            ++count;
            ts.next();
        }
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testARQConstructQuad_a_1() {
        String queryString = "CONSTRUCT { ?s ?p ?o } WHERE { GRAPH ?g { ?s ?p ?o } }";
        Query q = QueryFactory.create(queryString, Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create(q, d);
        Iterator<Triple> ts = qExec.execConstructTriples();
        Model result = ModelFactory.createDefaultModel();
        while (ts.hasNext()) {
            Triple t = ts.next();
            Statement stmt = ModelUtils.tripleToStatement(result, t);
            if (stmt == null) continue;
            result.add(stmt);
        }
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((boolean)m.isIsomorphicWith(result));
    }

    @Test
    public void testARQConstructQuad_b_2() {
        String queryString = "CONSTRUCT { GRAPH ?g1 {?s ?p ?o} } WHERE { ?s ?p ?o. GRAPH ?g1 {?s1 ?p1 'x1'} }";
        Query q = QueryFactory.create(queryString, Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create(q, d);
        Iterator<Quad> ts = qExec.execConstructQuads();
        DatasetGraph result = DatasetGraphFactory.create();
        long count = 0L;
        while (ts.hasNext()) {
            ++count;
            Quad qd = ts.next();
            result.add(qd);
        }
        DatasetGraph expected = DatasetGraphFactory.create();
        expected.add(g1.asNode(), s.asNode(), p.asNode(), o.asNode());
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertTrue((boolean)IsoMatcher.isomorphic(expected, result));
    }

    @Test
    public void testARQConstructQuad_a_2() {
        String queryString = "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o }";
        Query q = QueryFactory.create(queryString, Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create(q, d);
        Iterator<Quad> ts = qExec.execConstructQuads();
        DatasetGraph result = DatasetGraphFactory.create();
        long count = 0L;
        while (ts.hasNext()) {
            ++count;
            result.add(ts.next());
        }
        DatasetGraph expected = DatasetGraphFactory.create();
        expected.add(Quad.defaultGraphNodeGenerated, s.asNode(), p.asNode(), o.asNode());
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertTrue((boolean)IsoMatcher.isomorphic(expected, result));
    }

    @Test
    public void testARQConstructQuad_b_1() {
        String queryString = "CONSTRUCT { ?s ?p ?o GRAPH ?g1 { ?s1 ?p1 ?o1 } } WHERE { ?s ?p ?o. GRAPH ?g1 { ?s1 ?p1 ?o1 } }";
        Query q = QueryFactory.create(queryString, Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create(q, d);
        Iterator<Triple> ts = qExec.execConstructTriples();
        Model result = ModelFactory.createDefaultModel();
        while (ts.hasNext()) {
            Triple t = ts.next();
            Statement stmt = ModelUtils.tripleToStatement(result, t);
            if (stmt == null) continue;
            result.add(stmt);
        }
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)dft.isIsomorphicWith(result));
    }

    @Test
    public void testARQConstructQuad_bnodes() {
        String queryString = "PREFIX : <http://example/> CONSTRUCT { :s :p :o GRAPH _:a { :s :p :o1 } } WHERE { }";
        Query q = QueryFactory.create(queryString, Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create(q, d);
        Dataset ds = qExec.execConstructDataset();
        Assert.assertEquals((long)1L, (long)Iter.count(ds.asDatasetGraph().listGraphNodes()));
        Node n = ds.asDatasetGraph().listGraphNodes().next();
        Assert.assertTrue((boolean)n.isBlank());
        Graph g = ds.asDatasetGraph().getGraph(n);
        Assert.assertNotNull((Object)g);
        Assert.assertFalse((boolean)g.isEmpty());
    }

    @Test
    public void testARQConstructQuad_Duplicate_1() {
        String queryString = "CONSTRUCT { GRAPH ?g1 {?s ?p ?o} } WHERE { ?s ?p ?o. GRAPH ?g1 {?s1 ?p1 ?o1} }";
        Query q = QueryFactory.create(queryString, Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create(q, d);
        Iterator<Quad> ts = qExec.execConstructQuads();
        long count = 0L;
        Quad expected = Quad.create(g1.asNode(), s.asNode(), p.asNode(), o.asNode());
        while (ts.hasNext()) {
            ++count;
            Quad qd = ts.next();
            Assert.assertEquals((Object)expected, (Object)qd);
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testARQConstructQuad_Duplicate_2() {
        String queryString = "CONSTRUCT { GRAPH ?g1 {?s ?p ?o} } WHERE { ?s ?p ?o. GRAPH ?g1 {?s1 ?p1 ?o1} }";
        Query q = QueryFactory.create(queryString, Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create(q, d);
        Dataset result = qExec.execConstructDataset();
        DatasetGraph expected = DatasetGraphFactory.create();
        expected.add(g1.asNode(), s.asNode(), p.asNode(), o.asNode());
        Assert.assertEquals((long)1L, (long)result.asDatasetGraph().size());
        Assert.assertTrue((boolean)IsoMatcher.isomorphic(expected, result.asDatasetGraph()));
    }

    @Test
    public void testARQConstructQuad_Duplicate_3() {
        String queryString = "CONSTRUCT { GRAPH ?g1 {?s ?p ?o} GRAPH ?g1 {?s ?p ?o} } WHERE { ?s ?p ?o. GRAPH ?g1 {?s1 ?p1 ?o1} }";
        Query q = QueryFactory.create(queryString, Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create(q, d);
        Iterator<Quad> ts = qExec.execConstructQuads();
        long count = 0L;
        Quad expected = Quad.create(g1.asNode(), s.asNode(), p.asNode(), o.asNode());
        while (ts.hasNext()) {
            ++count;
            Quad qd = ts.next();
            Assert.assertEquals((Object)expected, (Object)qd);
        }
        Assert.assertEquals((long)6L, (long)count);
    }

    @Test
    public void testARQConstructQuad_Prefix() {
        String queryString = "PREFIX :   <http://example/ns#> CONSTRUCT { GRAPH :g1 { ?s :p ?o} } WHERE { ?s ?p ?o }";
        Query q = QueryFactory.create(queryString, Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create(q, d);
        Iterator<Quad> quads = qExec.execConstructQuads();
        DatasetGraph result = DatasetGraphFactory.create();
        long count = 0L;
        while (quads.hasNext()) {
            ++count;
            Quad qd = quads.next();
            result.add(qd);
        }
        DatasetGraph expected = DatasetGraphFactory.create();
        expected.add(g1.asNode(), s.asNode(), p.asNode(), o.asNode());
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertTrue((boolean)IsoMatcher.isomorphic(expected, result));
    }

    @Test
    public void testARQConstructQuad_ShortForm_1() {
        String queryString = "CONSTRUCT WHERE {?s ?p ?o }";
        Query q = QueryFactory.create(queryString, Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create(q, d);
        Model result = ModelFactory.createDefaultModel();
        qExec.execConstruct(result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)dft.isIsomorphicWith(result));
    }

    @Test
    public void testARQConstructQuad_ShortForm_2() {
        String queryString = "CONSTRUCT WHERE { GRAPH ?g {?s ?p ?o} }";
        Query q = QueryFactory.create(queryString, Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create(q, d);
        Dataset result = qExec.execConstructDataset();
        Dataset expected = DatasetFactory.createTxnMem();
        expected.addNamedModel(g1.getURI(), m);
        Assert.assertTrue((boolean)IsoMatcher.isomorphic(expected.asDatasetGraph(), result.asDatasetGraph()));
    }

    @Test
    public void testARQConstructQuad_ShortForm_3() {
        String queryString = "CONSTRUCT WHERE { ?s ?p ?o. GRAPH ?g1 {?s1 ?p1 ?o1} }";
        Query q = QueryFactory.create(queryString, Syntax.syntaxARQ);
        QueryExecution qExec = QueryExecutionFactory.create(q, d);
        Dataset result = qExec.execConstructDataset();
        Assert.assertTrue((boolean)IsoMatcher.isomorphic(d.asDatasetGraph(), result.asDatasetGraph()));
    }

    @Test
    public void testARQConstructQuad_ShortForm_bad() {
        String queryString = "CONSTRUCT WHERE { GRAPH ?g {?s ?p ?o. FILTER isIRI(?o)}  }";
        try {
            QueryFactory.create(queryString, Syntax.syntaxARQ);
        }
        catch (QueryParseException e2) {
            return;
        }
        Assert.fail((String)"Short form of construct quad MUST be simple graph patterns!");
    }

    @Test
    public void testResultSetCloseableGood() {
        String queryString = "SELECT * { ?s ?p ?o. }";
        Query q = QueryFactory.create(queryString);
        QueryExecution qExec = QueryExecutionFactory.create(q, d);
        try (ResultSetCloseable rs = ResultSetFactory.closeableResultSet(qExec);){
            int x = ResultSetFormatter.consume(rs);
            Assert.assertEquals((long)1L, (long)x);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResultSetCloseableBad() {
        String queryString = "ASK { ?s ?p ?o. }";
        Query q = QueryFactory.create(queryString);
        QueryExecution qExec = QueryExecutionFactory.create(q, d);
        try (ResultSetCloseable rs = ResultSetFactory.closeableResultSet(qExec);){
            int x = ResultSetFormatter.consume(rs);
            Assert.assertEquals((long)1L, (long)x);
        }
    }

    private QueryExecution makeQExec(String queryString) {
        Query q = QueryFactory.create(queryString);
        QueryExecution qExec = QueryExecutionFactory.create(q, m);
        return qExec;
    }

    private int queryAndCount(String queryString) {
        QueryExecution qExec = this.makeQExec(queryString);
        return this.queryAndCount(qExec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int queryAndCount(QueryExecution qExec) {
        try {
            ResultSet rs = qExec.execSelect();
            int n = ResultSetFormatter.consume(rs);
            return n;
        }
        finally {
            qExec.close();
        }
    }

    @Test
    public void testExecJson() {
        Query query2 = QueryFactory.create("JSON { \"s\": ?s , \"p\": ?p , \"o\" : ?o } WHERE { ?s ?p ?o }", Syntax.syntaxARQ);
        try (QueryExecution qexec = QueryExecutionFactory.create(query2, m);){
            JsonArray jsonArray = qexec.execJson();
            Assert.assertNotNull((Object)jsonArray);
            Assert.assertEquals((long)3L, (long)jsonArray.size());
        }
    }

    @Test
    public void testExecJsonItems() {
        Model model = ModelFactory.createDefaultModel();
        Resource r = model.createResource(AnonId.create("first"));
        Property p = model.getProperty("");
        Literal node = ResourceFactory.createTypedLiteral("123", XSDDatatype.XSDdecimal);
        model.add(r, p, node);
        r = model.createResource(AnonId.create("second"));
        p = model.getProperty("");
        node = ResourceFactory.createTypedLiteral("abc", XSDDatatype.XSDstring);
        model.add(r, p, node);
        r = model.createResource(AnonId.create("third"));
        p = model.getProperty("");
        node = ResourceFactory.createLangLiteral("def", "en");
        model.add(r, p, node);
        Query query2 = QueryFactory.create("JSON { \"s\": ?s , \"p\": ?p , \"o\" : ?o } WHERE { ?s ?p ?o }", Syntax.syntaxARQ);
        try (QueryExecution qexec = QueryExecutionFactory.create(query2, model);){
            Iterator<JsonObject> execJsonItems = qexec.execJsonItems();
            int size = 0;
            while (execJsonItems.hasNext()) {
                JsonObject next = execJsonItems.next();
                if (next.get("s").toString().contains("first")) {
                    Assert.assertEquals((long)123L, (long)next.get("o").getAsNumber().value().intValue());
                } else if (next.get("s").toString().contains("second")) {
                    Assert.assertEquals((Object)"abc", (Object)next.get("o").getAsString().value());
                } else if (next.get("s").toString().contains("third")) {
                    Assert.assertEquals((Object)"def", (Object)next.get("o").getAsString().value());
                }
                ++size;
            }
            Assert.assertEquals((long)3L, (long)size);
        }
    }

    static {
        m.add(r1, p1, "x1");
        m.add(r1, p2, "X2");
        m.add(r1, p3, "y1");
        dft.add(s, p, o);
        d = DatasetFactory.create(dft);
        d.addNamedModel(g1.getURI(), m);
    }
}

