/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.optimize.ExprTransformConstantFold;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestTransformConstantFolding {
    private ExprTransform transform = new ExprTransformConstantFold();

    private void testNoTransform(String input, ExprTransform transform) {
        this.test(input, null, transform);
    }

    private void test(String input, String expected, ExprTransform transform) {
        Op opOrig = SSE.parseOp(input);
        Op opExpected = SSE.parseOp(expected != null ? expected : input);
        Op opOptimized = Transformer.transform(new TransformCopy(), transform, opOrig);
        Assert.assertEquals((Object)opExpected, (Object)opOptimized);
    }

    @Test
    public void constant_fold_extend_01() {
        this.test("(extend (?x (+ 1 2)) (table unit))", "(extend (?x 3) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_extend_02() {
        this.test("(extend (?x (+ (+ 1 2) 3)) (table unit))", "(extend (?x 6) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_extend_03() {
        this.test("(extend (?x (/ 1 2)) (table unit))", "(extend (?x 0.5) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_extend_04() {
        this.testNoTransform("(extend (?x (/ 1 0)) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_extend_05() {
        this.test("(extend (?x (abs -1)) (table unit))", "(extend (?x 1) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_extend_06() {
        this.test("(extend (?x (regex 'something' 'thing')) (table unit))", "(extend (?x true) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_extend_07() {
        this.testNoTransform("(extend (?x (coalesce (/ 1 0) 0)) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_extend_08() {
        this.testNoTransform("(extend (?x (rand)))", this.transform);
        this.testNoTransform("(extend (?x (now)))", this.transform);
        this.testNoTransform("(extend (?x (uuid)))", this.transform);
        this.testNoTransform("(extend (?x (struuid)))", this.transform);
    }

    @Test
    public void constant_fold_filter_01() {
        this.test("(filter (exprlist (+ 1 2)) (table unit))", "(filter (exprlist 3) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_filter_02() {
        this.test("(filter (exprlist (+ (+ 1 2) 3)) (table unit))", "(filter (exprlist 6) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_filter_03() {
        this.test("(filter (exprlist (/ 1 2)) (table unit))", "(filter (exprlist 0.5) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_filter_04() {
        this.testNoTransform("(filter (exprlist (/ 1 0)) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_filter_05() {
        this.test("(filter (exprlist (abs -1)) (table unit))", "(filter (exprlist 1) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_filter_06() {
        this.test("(filter (regex 'something' 'thing') (table unit))", "(filter (exprlist true) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_filter_07() {
        this.testNoTransform("(filter (exprlist (coalesce (/ 1 0) 0)) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_filter_08() {
        this.test("(filter (exists (filter (exprlist (+ 1 2)) (table unit))) (table unit))", "(filter (exists (filter (exprlist 3) (table unit))) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_filter_09() {
        this.test("(filter (exprlist (= ?x (+ 1 2))) (table unit))", "(filter (exprlist (= ?x 3)) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_filter_10() {
        this.test("(filter (exprlist (+ 1 (* (+ 5 6 ) (+ 8 9)))) (table unit))", "(filter (exprlist 188) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_filter_11() {
        this.test("(filter (exprlist (* ?y (+ (* ?x 4) (* ?z 6 )))) (table unit))", null, this.transform);
    }

    @Test
    public void constant_fold_filter_12() {
        this.testNoTransform("(filter (exprlist (rand)) (table unit))", this.transform);
        this.testNoTransform("(filter (exprlist (now)) (table unit))", this.transform);
        this.testNoTransform("(filter (exprlist (uuid)) (table unit))", this.transform);
        this.testNoTransform("(filter (exprlist (struuid)) (table unit))", this.transform);
    }

    @Test
    public void constant_fold_group_01() {
        this.test("(project (?count) (extend ((?count ?.0)) (group () ((?.0 (count (+ 1 2)))) (table unit))))", "(project (?count) (extend ((?count ?.0)) (group () ((?.0 (count 3))) (table unit))))", this.transform);
    }

    @Test
    public void constant_fold_leftjoin_01() {
        this.test("(leftjoin (table unit) (table unit) (+ 1 2))", "(leftjoin (table unit) (table unit) (exprlist 3))", this.transform);
    }
}

