/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.main.QueryEngineMain;
import org.apache.jena.sparql.resultset.ResultSetCompare;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.Symbol;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSemanticEquivalence {
    private static Dataset implJoin;

    @BeforeClass
    public static void setup() {
        implJoin = DatasetFactory.createTxnMem();
        Node a = NodeFactory.createURI("http://a");
        Node b = NodeFactory.createURI("http://b");
        Node c = NodeFactory.createURI("http://c");
        Node p1 = NodeFactory.createURI("http://p1");
        Node p2 = NodeFactory.createURI("http://p2");
        Node pSelf = NodeFactory.createURI("http://self");
        Node o = NodeFactory.createLiteral("object");
        DatasetGraph dsg = implJoin.asDatasetGraph();
        dsg.add(Quad.defaultGraphNodeGenerated, a, p1, o);
        dsg.add(Quad.defaultGraphNodeGenerated, a, p2, o);
        dsg.add(Quad.defaultGraphNodeGenerated, b, p1, o);
        dsg.add(Quad.defaultGraphNodeGenerated, b, p2, o);
        dsg.add(Quad.defaultGraphNodeGenerated, c, p1, o);
        Assert.assertFalse((boolean)ARQ.isFalse(ARQ.optFilterImplicitJoin));
        Assert.assertFalse((boolean)ARQ.isFalse(ARQ.optImplicitLeftJoin));
    }

    @AfterClass
    public static void teardown() {
        if (implJoin != null) {
            implJoin.close();
            implJoin = null;
        }
        Assert.assertFalse((boolean)ARQ.isFalse(ARQ.optFilterImplicitJoin));
        Assert.assertFalse((boolean)ARQ.isFalse(ARQ.optImplicitLeftJoin));
    }

    @Test
    public void implicitJoinEvaluation1() {
        String query2 = "SELECT * WHERE { ?x <http://p1> ?o1 . ?y <http://p2> ?o2 . FILTER(?x = ?y) }";
        TestSemanticEquivalence.test(query2, implJoin, ARQ.optFilterImplicitJoin, 2);
        String alg1 = "(filter (= ?x ?y) (bgp (?x <http://p1> ?o1)(?y <http://p2> ?o2)))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optFilterImplicitJoin, 2);
        String alg2 = "(filter (= ?y ?x) (bgp (?x <http://p1> ?o1)(?y <http://p2> ?o2)))";
        TestSemanticEquivalence.testAsAlgebra(alg2, implJoin, ARQ.optFilterImplicitJoin, 2);
    }

    @Test
    public void implicitJoinEvaluation2() {
        String query2 = "SELECT * WHERE { ?x <http://p1> ?o1 . ?y <http://noSuchPredicate> ?o2 . FILTER(?x = ?y) }";
        TestSemanticEquivalence.test(query2, implJoin, ARQ.optFilterImplicitJoin, 0);
        String alg1 = "(filter (= ?x ?y) (bgp (?x <http://p1> ?o1)(?y <http://noSuchPredicate> ?o2)))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optFilterImplicitJoin, 0);
        String alg2 = "(filter (= ?y ?x) (bgp (?x <http://p1> ?o1)(?y <http://noSuchPredicate> ?o2)))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optFilterImplicitJoin, 0);
    }

    @Test
    public void implicitJoinEvaluation3() {
        String query2 = "SELECT * WHERE { ?x <http://p1> ?o1 . FILTER(?x = ?y) }";
        TestSemanticEquivalence.test(query2, implJoin, ARQ.optFilterImplicitJoin, 0);
        String alg1 = "(filter (= ?x ?y) (bgp (?x <http://p1> ?o1)))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optFilterImplicitJoin, 0);
        String alg2 = "(filter (= ?y ?x) (bgp (?x <http://p1> ?o1)))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optFilterImplicitJoin, 0);
    }

    @Test
    public void implicitLeftJoinEvaluation1() {
        String query2 = "SELECT * WHERE { ?x <http://p1> ?o1 . OPTIONAL { ?y <http://p2> ?o2 . FILTER(?x = ?y) } }";
        TestSemanticEquivalence.test(query2, implJoin, ARQ.optImplicitLeftJoin, 3);
        String alg1 = "(leftjoin (bgp (?x <http://p1> ?o1)) (bgp (?y <http://p2> ?o2)) (= ?x ?y))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optImplicitLeftJoin, 3);
        String alg2 = "(leftjoin (bgp (?x <http://p1> ?o1)) (bgp (?y <http://p2> ?o2)) (= ?y ?x))";
        TestSemanticEquivalence.testAsAlgebra(alg2, implJoin, ARQ.optImplicitLeftJoin, 3);
    }

    @Test
    public void implicitLeftJoinEvaluation2() {
        String query2 = "SELECT * WHERE { ?x <http://p1> ?o1 . OPTIONAL { ?y <http://p2> ?o2 . FILTER(?x = ?y && ?o1 >= ?o2) } }";
        TestSemanticEquivalence.test(query2, implJoin, ARQ.optImplicitLeftJoin, 3);
        String alg1 = "(leftjoin (bgp (?x <http://p1> ?o1)) (bgp (?y <http://p2> ?o2)) (&& (= ?x ?y)(> ?o1 ?o2)))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optImplicitLeftJoin, 3);
        String alg2 = "(leftjoin (bgp (?x <http://p1> ?o1)) (bgp (?y <http://p2> ?o2)) (&& (= ?y ?x)(> ?o1 ?o2)))";
        TestSemanticEquivalence.testAsAlgebra(alg2, implJoin, ARQ.optImplicitLeftJoin, 3);
    }

    @Test
    public void implicitLeftJoinEvaluation3() {
        String query2 = "SELECT * WHERE { ?x ?p ?o . OPTIONAL { ?y ?p1 ?o1 . ?y ?p2 ?z . FILTER(?x = ?y) FILTER(?x = ?z) FILTER(?y = ?z) } }";
        TestSemanticEquivalence.test(query2, implJoin, ARQ.optImplicitLeftJoin, 5);
        String alg1 = "(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1) (?y ?p2 ?z)) ((= ?x ?y) (= ?x ?z) (= ?y ?z)))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optImplicitLeftJoin, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(String queryStr, Dataset ds, Symbol opt, int expected) {
        Query q = QueryFactory.create(queryStr);
        if (!q.isSelectType()) {
            Assert.fail((String)"Only SELECT queries are testable with this method");
        }
        Op op = Algebra.compile(q);
        boolean isEnabled = ARQ.isTrue(opt);
        boolean isDisabled = ARQ.isFalse(opt);
        try {
            ResultSetRewindable rsOpt;
            ResultSetRewindable rs;
            ARQ.set(opt, false);
            try (QueryExecution qe = QueryExecutionFactory.create(q, ds);){
                rs = ResultSetFactory.makeRewindable(qe.execSelect());
                if (expected != rs.size()) {
                    System.err.println("Non-optimized results not as expected");
                    ResultSetFormatter.out((OutputStream)System.out, rs);
                    rs.reset();
                }
                Assert.assertEquals((long)expected, (long)rs.size());
            }
            ARQ.set(opt, true);
            try (QueryExecution qeOpt = QueryExecutionFactory.create(q, ds);){
                rsOpt = ResultSetFactory.makeRewindable(qeOpt.execSelect());
                if (expected != rsOpt.size()) {
                    System.err.println("Optimized results not as expected");
                    ResultSetFormatter.out((OutputStream)System.out, rsOpt);
                    rsOpt.reset();
                }
                Assert.assertEquals((long)expected, (long)rsOpt.size());
            }
            Assert.assertTrue((boolean)ResultSetCompare.isomorphic(rs, rsOpt));
        }
        finally {
            if (isEnabled) {
                ARQ.set(opt, true);
            } else if (isDisabled) {
                ARQ.set(opt, false);
            } else {
                ARQ.unset(opt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testAsAlgebra(String algStr, Dataset ds, Symbol opt, int expected) {
        Op op = SSE.parseOp(algStr);
        ArrayList<String> vars = new ArrayList<String>();
        for (Var v : OpVars.visibleVars(op)) {
            vars.add(v.getName());
        }
        boolean isEnabled = ARQ.isTrue(opt);
        boolean isDisabled = ARQ.isFalse(opt);
        try {
            ARQ.set(opt, false);
            QueryEngineMain engine = new QueryEngineMain(op, ds.asDatasetGraph(), BindingFactory.empty(), ARQ.getContext());
            QueryIterator iter = engine.eval(op, ds.asDatasetGraph(), BindingFactory.empty(), ARQ.getContext());
            ResultSetRewindable rs = ResultSetFactory.makeRewindable(new ResultSetStream(vars, ModelFactory.createDefaultModel(), iter));
            if (expected != rs.size()) {
                System.err.println("Non-optimized results not as expected");
                ResultSetFormatter.out((OutputStream)System.out, rs);
                rs.reset();
            }
            Assert.assertEquals((long)expected, (long)rs.size());
            iter.close();
            ARQ.set(opt, true);
            engine = new QueryEngineMain(op, ds.asDatasetGraph(), BindingFactory.empty(), ARQ.getContext());
            QueryIterator iterOpt = engine.eval(op, ds.asDatasetGraph(), BindingFactory.empty(), ARQ.getContext());
            ResultSetRewindable rsOpt = ResultSetFactory.makeRewindable(new ResultSetStream(vars, ModelFactory.createDefaultModel(), iterOpt));
            if (expected != rsOpt.size()) {
                System.err.println("Optimized results not as expected");
                ResultSetFormatter.out((OutputStream)System.out, rsOpt);
                rsOpt.reset();
            }
            Assert.assertEquals((long)expected, (long)rsOpt.size());
            iterOpt.close();
            Assert.assertTrue((boolean)ResultSetCompare.isomorphic(rs, rsOpt));
        }
        finally {
            if (isEnabled) {
                ARQ.set(opt, true);
            } else if (isDisabled) {
                ARQ.set(opt, false);
            } else {
                ARQ.unset(opt);
            }
        }
    }
}

