/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;

public abstract class AbstractTestTransform {
    public void testOptimize(String input, String ... output) {
        Query q = QueryFactory.create(input);
        Op op = Algebra.compile(q);
        AbstractTestTransform.check(op, StrUtils.strjoinNL(output));
    }

    public void testQuery(String input, Transform transform, String ... output) {
        Query q = QueryFactory.create(input);
        Op op = Algebra.compile(q);
        this.test(op, transform, output);
    }

    public void testOp(String input, Transform transform, String ... output) {
        Op op1 = SSE.parseOp(input);
        this.test(op1, transform, output);
    }

    public void test(Op op1, Transform transform, String ... output) {
        Op op2 = Transformer.transform(transform, op1);
        if (output == null) {
            Assert.assertEquals((Object)op1, (Object)op2);
            return;
        }
        Op op3 = SSE.parseOp(StrUtils.strjoinNL(output));
        Assert.assertEquals((Object)op3, (Object)op2);
    }

    public static void check(String queryString, String opExpectedString) {
        queryString = "PREFIX : <http://example/>\n" + (String)queryString;
        Query query2 = QueryFactory.create((String)queryString);
        Op opQuery = Algebra.compile(query2);
        Op op1 = Algebra.compile(query2);
        AbstractTestTransform.check(opQuery, opExpectedString);
        Assert.assertEquals((String)"Modification of input during optimization", (Object)op1, (Object)opQuery);
    }

    private static void check(Op opToOptimize, String opExpectedString) {
        Op opOptimize = Algebra.optimize(opToOptimize);
        Op opExpected = SSE.parseOp(opExpectedString);
        Assert.assertEquals((Object)opExpected, (Object)opOptimize);
    }

    public static void check(Op opToOptimize, Transform additionalOptimizer, String opExpectedString) {
        Op opOptimize = Algebra.optimize(opToOptimize);
        opOptimize = Transformer.transform(additionalOptimizer, opOptimize);
        Op opExpected = SSE.parseOp(opExpectedString);
        Assert.assertEquals((Object)opExpected, (Object)opOptimize);
    }

    public static void checkAlgebra(String algString, Transform additionalOptimizer, String opExpectedString) {
        Op algebra = SSE.parseOp(algString);
        Op algebra1 = SSE.parseOp(algString);
        Op optimized = Algebra.optimize(algebra);
        if (additionalOptimizer != null) {
            optimized = Transformer.transform(additionalOptimizer, optimized);
        }
        Op opExpected = SSE.parseOp(opExpectedString != null ? opExpectedString : algString);
        Assert.assertEquals((Object)opExpected, (Object)optimized);
        Assert.assertEquals((String)"Modification of input during optimization", (Object)algebra1, (Object)algebra);
    }

    public static void checkAlgebra(String algString, String opExpectedString) {
        AbstractTestTransform.checkAlgebra(algString, null, opExpectedString);
    }
}

