/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.main.VarFinder;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestVarFinder {
    @Test
    public void varfind_01_1() {
        TestVarFinder.varfindFixed("(bgp (?s <p> <o>))", "s");
    }

    @Test
    public void varfind_01_2() {
        TestVarFinder.varfindOpt("(bgp (?s <p> <o>))", new String[0]);
    }

    @Test
    public void varfind_01_3() {
        TestVarFinder.varfindFilter("(bgp (?s <p> <o>))", new String[0]);
    }

    @Test
    public void varfind_01_4() {
        TestVarFinder.varfindFilter("(bgp (?s <p> <o>))", new String[0]);
    }

    @Test
    public void varfind_02_1() {
        TestVarFinder.varfindFixed("(graph ?g (bgp (?s <p> <o>)))", "s", "g");
    }

    @Test
    public void varfind_02_2() {
        TestVarFinder.varfindOpt("(graph ?g (bgp (?s <p> <o>)))", new String[0]);
    }

    @Test
    public void varfind_02_3() {
        TestVarFinder.varfindFilter("(graph ?g (bgp (?s <p> <o>)))", new String[0]);
    }

    @Test
    public void varfind_02_4() {
        TestVarFinder.varfindFilterOnly("(graph ?g (bgp (?s <p> <o>)))", new String[0]);
    }

    @Test
    public void varfind_03_1() {
        TestVarFinder.varfindFixed("(filter (?s) (bgp (?s <p> <o>)))", "s");
    }

    @Test
    public void varfind_03_2() {
        TestVarFinder.varfindOpt("(filter (?s) (bgp (?s <p> <o>)))", new String[0]);
    }

    @Test
    public void varfind_03_3() {
        TestVarFinder.varfindFilter("(filter (?s) (bgp (?s <p> <o>)))", "s");
    }

    @Test
    public void varfind_03_4() {
        TestVarFinder.varfindFilterOnly("(filter (?s) (bgp (?s <p> <o>)))", new String[0]);
    }

    @Test
    public void varfind_03_5() {
        TestVarFinder.varfindFilterOnly("(filter (?z) (bgp (?s <p> <o>)))", "z");
    }

    @Test
    public void varfind_04_1() {
        TestVarFinder.varfindFixed("(leftjoin (bgp (?x <q> <v>)) (filter (?s) (bgp (?s <p> <o>))))", "x");
    }

    @Test
    public void varfind_04_2() {
        TestVarFinder.varfindOpt("(leftjoin (bgp (?x <q> <v>)) (filter (?s) (bgp (?s <p> <o>))))", "s");
    }

    @Test
    public void varfind_04_3() {
        TestVarFinder.varfindFilter("(leftjoin (bgp (?x <q> <v>)) (filter (?s) (bgp (?s <p> <o>))))", "s");
    }

    @Test
    public void varfind_04_4() {
        TestVarFinder.varfindFilterOnly("(leftjoin (bgp (?x <q> <v>)) (filter (?Z) (bgp (?s <p> <o>))))", "Z");
    }

    @Test
    public void varfind_04_5() {
        TestVarFinder.varfindFilterOnly("(leftjoin (bgp (?x <q> <v>)) (bgp (?s <p> <o>)) ?Z)", "Z");
    }

    @Test
    public void varfind_05_1() {
        TestVarFinder.varfindFixed("(propfunc :pf ?x (?y ?z) (table unit))", "x", "y", "z");
    }

    @Test
    public void varfind_05_2() {
        TestVarFinder.varfindFixed("(propfunc :pf ?x (?y ?z) (bgp (?x ?p ?o)))", "x", "y", "z", "p", "o");
    }

    @Test
    public void varfind_05_3() {
        TestVarFinder.varfindFixed("(propfunc :pf ?x (?y ?z) (leftjoin (table unit) (bgp (?x ?p ?o)) ))", "x", "y", "z");
    }

    @Test
    public void varfind_05_4() {
        TestVarFinder.varfindOpt("(propfunc :pf ?x (?y ?z) (leftjoin (table unit) (bgp (?x ?p ?o)) ))", "p", "o");
    }

    private static void varfindFixed(String string, String ... vars) {
        TestVarFinder.varfind(string, vars, null, null, null);
    }

    private static void varfindOpt(String string, String ... vars) {
        TestVarFinder.varfind(string, null, vars, null, null);
    }

    private static void varfindFilter(String string, String ... vars) {
        TestVarFinder.varfind(string, null, null, vars, null);
    }

    private static void varfindFilterOnly(String string, String ... vars) {
        TestVarFinder.varfind(string, null, null, null, vars);
    }

    private static void varfind(String string, String[] varsFixed, String[] varsOpt, String[] varsFilter, String[] varsFilterOnly) {
        Op op = SSE.parseOp(string);
        VarFinder vf = VarFinder.process(op);
        if (varsFixed != null) {
            TestVarFinder.check(varsFixed, vf.getFixed());
        }
        if (varsOpt != null) {
            TestVarFinder.check(varsOpt, vf.getOpt());
        }
        if (varsFilter != null) {
            TestVarFinder.check(varsFilter, vf.getFilter());
        }
        if (varsFilterOnly != null) {
            TestVarFinder.check(varsFilterOnly, vf.getFilterOnly());
        }
    }

    private static void check(String[] varsExpected, Set<Var> varsFound) {
        Var[] vars = new Var[varsExpected.length];
        for (int i = 0; i < varsExpected.length; ++i) {
            Var v;
            vars[i] = v = Var.alloc(varsExpected[i]);
        }
        List<Var> varList = Arrays.asList(vars);
        HashSet<Var> varSet = new HashSet<Var>();
        varSet.addAll(varList);
        Assert.assertEquals(varSet, varsFound);
    }
}

