/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestTransformQuads {
    @Test
    public void quads01() {
        TestTransformQuads.test("{ GRAPH ?g { ?s ?p ?o } }", "(quadpattern (quad ?g ?s ?p ?o))");
    }

    @Test
    public void quads02() {
        TestTransformQuads.test("{ GRAPH ?g { ?s ?p ?o } GRAPH ?g1 { ?s1 ?p1 ?o1 }  }", "(sequence    (quadpattern (quad ?g ?s ?p ?o))", "    (quadpattern (quad ?g1 ?s1 ?p1 ?o1)))");
    }

    @Test
    public void quads03() {
        TestTransformQuads.test("{ GRAPH ?g { ?s ?p ?o } GRAPH ?g { ?s1 ?p1 ?o1 }  }", "(sequence   (quadpattern (quad ?g ?s ?p ?o))   (quadpattern (quad ?g ?s1 ?p1 ?o1)))");
    }

    @Test
    public void quads04() {
        TestTransformQuads.test("{ GRAPH ?g { ?s ?p ?o GRAPH ?g1 { ?s1 ?p1 ?o1 }  } }", "(sequence   (quadpattern (quad ?g ?s ?p ?o))   (quadpattern (quad ?g1 ?s1 ?p1 ?o1)))");
    }

    @Test
    public void quads05() {
        TestTransformQuads.test("{ GRAPH ?g { ?s ?p ?o GRAPH ?g { ?s1 ?p1 ?o1 }  } }", "(assign ((?g ?*g0))   (sequence     (quadpattern (quad ?*g0 ?s ?p ?o))     (quadpattern (quad ?g ?s1 ?p1 ?o1))))");
    }

    @Test
    public void quadsFilter1() {
        TestTransformQuads.test("{ GRAPH ?g { ?s ?p ?o FILTER (str(?g) = 'graphURI') } }", "(assign ((?g ?*g0))   (filter (= (str ?g) 'graphURI')     (quadpattern (quad ?*g0 ?s ?p ?o))))");
    }

    @Test
    public void quadsFilter2() {
        TestTransformQuads.test("{ GRAPH ?g { ?s ?p ?o } FILTER (str(?g) = 'graphURI') }", "(filter (= (str ?g) 'graphURI')   (quadpattern (quad ?g ?s ?p ?o)))");
    }

    @Test
    public void quadsFilter3() {
        TestTransformQuads.test("{ GRAPH ?g { ?s ?p ?o GRAPH ?g1 { ?s1 ?p1 ?o1 FILTER (str(?g) = 'graphURI') } } }", "(assign ((?g ?*g0))    (sequence        (quadpattern (quad ?*g0 ?s ?p ?o))        (filter (= (str ?g) 'graphURI')          (quadpattern (quad ?g1 ?s1 ?p1 ?o1)))))");
    }

    @Test
    public void quadsFilter4() {
        TestTransformQuads.test("{ GRAPH ?g { ?s ?p ?o GRAPH ?g1 { ?s1 ?p1 ?o1 FILTER (str(?g1) = 'graphURI') } } }", "(sequence   (quadpattern (quad ?g ?s ?p ?o))   (assign ((?g1 ?*g0))     (filter (= (str ?g1) 'graphURI')       (quadpattern (quad ?*g0 ?s1 ?p1 ?o1)))))");
    }

    @Test
    public void quadsFilter5() {
        TestTransformQuads.test("{ GRAPH ?g { ?s ?p ?o FILTER (str(?g) = 'graphURI') }   GRAPH ?g { ?s ?p ?o FILTER (str(?g) = 'graphURI') } }", "(sequence   (assign ((?g ?*g0))     (filter (= (str ?g) 'graphURI')       (quadpattern (quad ?*g0 ?s ?p ?o))))   (assign ((?g ?*g1))     (filter (= (str ?g) 'graphURI')       (quadpattern (quad ?*g1 ?s ?p ?o)))))");
    }

    @Test
    public void quadsFilterNotExists1() {
        TestTransformQuads.test("{ GRAPH ?g { ?s ?p ?o FILTER NOT EXISTS { GRAPH ?g1 { ?s1 ?p ?o1 } } } }", "(filter (notexists", "   (quadpattern (quad ?g1 ?s1 ?p ?o1)))", "  (quadpattern (quad ?g ?s ?p ?o)))");
    }

    @Test
    public void quadsFilterNotExists2() {
        TestTransformQuads.test("{ ?s ?p ?o FILTER NOT EXISTS { GRAPH ?g1 { ?s1 ?p ?o1 } } }", "(filter (notexists", "   (quadpattern (quad ?g1 ?s1 ?p ?o1)))", "  (quadpattern (quad <urn:x-arq:DefaultGraphNode> ?s ?p ?o)))");
    }

    @Test
    public void quadsFilterNotExists3() {
        TestTransformQuads.test("{ ?s ?p ?o OPTIONAL { FILTER NOT EXISTS { ?x ?y ?z } } }", false, "(leftjoin", "   (quadpattern (quad <urn:x-arq:DefaultGraphNode> ?s ?p ?o))", "   (table unit)", "   (notexists", "     (quadpattern (quad <urn:x-arq:DefaultGraphNode> ?x ?y ?z))))");
    }

    @Test
    public void quadsFilterNotExists4() {
        TestTransformQuads.test("{ ?s ?p ?o OPTIONAL { FILTER NOT EXISTS { ?x ?y ?z } } }", "(conditional", "  (quadpattern (quad <urn:x-arq:DefaultGraphNode> ?s ?p ?o))", "  (filter (notexists", "             (quadpattern (quad <urn:x-arq:DefaultGraphNode> ?x ?y ?z)))", "    (table unit)))");
    }

    @Test
    public void quadsFilterNotExists5() {
        TestTransformQuads.test("{ ?s ?p ?o OPTIONAL { FILTER NOT EXISTS { GRAPH ?g { ?x ?y ?z } } } }", false, "(leftjoin", "   (quadpattern (quad <urn:x-arq:DefaultGraphNode> ?s ?p ?o))", "   (table unit)", "   (notexists", "     (quadpattern (?g ?x ?y ?z))))");
    }

    @Test
    public void quadsSubquery1() {
        TestTransformQuads.test("{ GRAPH ?g { { SELECT ?x WHERE { ?x ?p ?g } } } }", "(project (?x)", "  (quadpattern (quad ?g ?x ?/p ?/g)))");
    }

    @Test
    public void quadsBind1() {
        TestTransformQuads.test("{ GRAPH ?g { ?s ?p ?o . BIND(str(?g) as ?g1) } }", "(assign ((?g ?*g0))", "  (extend ((?g1 (str ?g) ))", "    (quadpattern (quad ?*g0 ?s ?p ?o))))");
    }

    @Test
    public void quadsBind2() {
        TestTransformQuads.test("{ BIND ( true && NOT EXISTS { GRAPH ?g { ?x ?y ?z } } AS ?X ) }", "(extend ((?X (&& true (notexists", "                         (quadpattern (quad ?g ?x ?y ?z))))))", "    (table unit))");
    }

    @Test
    public void quadsService1() {
        TestTransformQuads.test("{ {?s ?p ?o } UNION { SERVICE <http://host/endpoint> { GRAPH ?gr { ?sr ?pr ?or }}} }", "(union", "  (quadpattern (quad <urn:x-arq:DefaultGraphNode> ?s ?p ?o))", "  (service <http://host/endpoint>", "    (graph ?gr", "      (bgp (triple ?sr ?pr ?or))))", ")");
    }

    @Test
    public void quadsService2() {
        TestTransformQuads.test("{ { GRAPH ?g { ?s ?p ?o } } UNION { SERVICE <http://host/endpoint> { GRAPH ?gr { ?sr ?pr ?or }}} }", "(union", "  (quadpattern (?g ?s ?p ?o))", "  (service <http://host/endpoint>", "    (graph ?gr", "      (bgp (triple ?sr ?pr ?or))))", ")");
    }

    @Test
    public void quads40() {
        TestTransformQuads.test("{ GRAPH ?g { SERVICE <http://host/endpoint> { ?s ?p ?o }}}", "(service <http://host/endpoint> (bgp (triple ?s ?p ?o)))");
    }

    @Test
    public void quads41() {
        TestTransformQuads.test("{ GRAPH ?g1 { SERVICE <http://host/endpoint> { ?s ?p ?o } ?s1 ?p1 ?o1 } }", "(sequence", "   (service <http://host/endpoint> (bgp (triple ?s ?p ?o)))", "   (quadpattern (?g1 ?s1 ?p1 ?o1))", ")");
    }

    private static void test(String patternString, String ... strExpected) {
        TestTransformQuads.test(patternString, true, strExpected);
    }

    private static void test(String patternString, boolean optimize, String ... strExpected) {
        Query q = QueryFactory.create("SELECT * WHERE " + patternString);
        Op op = Algebra.compile(q);
        if (optimize) {
            op = Algebra.optimize(op);
        }
        op = Algebra.toQuadForm(op);
        Op op2 = SSE.parseOp(StrUtils.strjoinNL(strExpected));
        Assert.assertEquals((Object)op2, (Object)op);
    }
}

