/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.sparql.algebra.AlgebraQuad;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.writers.WriterOp;
import org.apache.jena.sparql.util.NodeIsomorphismMap;
import org.junit.Assert;
import org.junit.Test;

public class TestTransformOpExt {
    @Test
    public void textOpExtQuads() {
        String x = StrUtils.strjoinNL("(graph <g>", "    (join", "     (bgp (?s ?p ?o))", "      (graph <g2> (bgp (?s ?p ?o)))", "))");
        String y = StrUtils.strjoinNL("(join", "   (quadpattern (quad <g> ?s ?p ?o))", "   (quadpattern (quad <g2> ?s ?p ?o)))");
        Op op = SSE.parseOp(x);
        OpGraph opg = (OpGraph)op;
        Op op1 = opg.getSubOp();
        op1 = new OpExtTest(op1);
        op = new OpGraph(opg.getNode(), op1);
        Op op2 = AlgebraQuad.quadize(op);
        Assert.assertTrue((boolean)(op2 instanceof OpExt));
        Op opSub = ((OpExt)op2).effectiveOp();
        Op expectedSub = SSE.parseOp(y);
        Assert.assertEquals((Object)expectedSub, (Object)opSub);
    }

    @Test
    public void testOpExtMinus() {
        String sse2 = StrUtils.strjoinNL("(filter (= ?o 1)", "   (bgp (?s ?p ?o))", ")");
        Op op = SSE.parseOp(sse2);
        op = Transformer.transformSkipService(new OpExtTransform(), op);
        Set<Var> vars = OpVars.visibleVars(op);
        Assert.assertEquals((long)3L, (long)vars.size());
    }

    static class OpExtTransform
    extends TransformCopy {
        OpExtTransform() {
        }

        @Override
        public Op transform(OpFilter opFilter, Op subOp) {
            return new OpExtTest(opFilter);
        }
    }

    static class OpExtTest
    extends OpExt {
        private Op op;

        OpExtTest(Op op) {
            super("test");
            this.op = op;
        }

        @Override
        public Op apply(Transform transform, OpVisitor before, OpVisitor after) {
            Op opx = Transformer.transformSkipService(transform, null, this.op, before, after);
            return new OpExtTest(opx);
        }

        @Override
        public Op effectiveOp() {
            return this.op;
        }

        @Override
        public QueryIterator eval(QueryIterator input, ExecutionContext execCxt) {
            return null;
        }

        @Override
        public void outputArgs(IndentedWriter out, SerializationContext sCxt) {
            out.println();
            WriterOp.output(out, this.op, sCxt);
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
            return other instanceof OpExtTest;
        }
    }
}

