/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.resultset.ResultSetCompare;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.system.Txn;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTestAdditional {
    private static final String PREFIXES = StrUtils.strjoinNL("PREFIX : <http://example/>") + "\n";

    protected abstract Dataset dataset();

    @Test
    public void substitute_1() {
        Dataset dataset = this.dataset();
        String resultsStr = StrUtils.strjoinNL("(resultset (?s ?p ?o)", "(row (?s :s1) (?p :p) (?o :o))", ")");
        ResultSetRewindable expected = SSE.parseResultSet(resultsStr).rewindable();
        Txn.executeWrite(dataset, () -> {
            String data = StrUtils.strjoinNL("(dataset", "  (:g1 :s1 :p :o)", "  (:g1 :s2 :p :o)", "  (:g2 :s1 :p :o)", "  (:g2 :s2 :p :o)", ")");
            DatasetGraph dsg = SSE.parseDatasetGraph(data);
            dataset.asDatasetGraph().addAll(dsg);
            String qs = PREFIXES + "SELECT * { VALUES ?s { :s1 } GRAPH <" + Quad.unionGraph + "> { ?s ?p ?o } }";
            Query query2 = QueryFactory.create(qs);
            try (QueryExecution qExec = QueryExecutionFactory.create(query2, dataset);){
                ResultSetRewindable rs = qExec.execSelect().rewindable();
                AbstractTestAdditional.testRS(expected, rs);
            }
        });
    }

    private static void testRS(ResultSetRewindable rsExpected, ResultSetRewindable rsGot) {
        boolean b = ResultSetCompare.equalsByTerm(rsExpected, rsGot);
        if (!b) {
            rsExpected.reset();
            rsGot.reset();
            System.out.println(ResultSetFormatter.asText(rsExpected));
            System.out.println();
            System.out.println(ResultSetFormatter.asText(rsGot));
        }
        Assert.assertTrue((String)"result sets different", (boolean)b);
    }
}

