/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shex.expressions.NodeConstraint;
import org.apache.jena.shex.expressions.ShapeExprVisitor;
import org.apache.jena.shex.sys.ReportItem;
import org.apache.jena.shex.sys.ShexLib;
import org.apache.jena.shex.sys.ValidationContext;
import org.apache.jena.vocabulary.XSD;

public class DatatypeConstraint
extends NodeConstraint {
    private final Node datatype;
    private final String dtURI;
    private final RDFDatatype rdfDatatype;

    public DatatypeConstraint(Node dt) {
        this(dt.isURI() ? dt.getURI() : null, Objects.requireNonNull(dt));
        if (!dt.isURI()) {
            throw new IllegalArgumentException("Not a URI: " + dt);
        }
    }

    public DatatypeConstraint(String dt) {
        this(Objects.requireNonNull(dt), NodeFactory.createURI(dt));
    }

    private DatatypeConstraint(String dtURI, Node dt) {
        this.datatype = dt;
        this.dtURI = dtURI;
        this.rdfDatatype = NodeFactory.getType(dtURI);
    }

    public String getDatatypeURI() {
        return this.dtURI;
    }

    public RDFDatatype getRDFDatatype() {
        return this.rdfDatatype;
    }

    @Override
    public ReportItem nodeSatisfies(ValidationContext vCxt, Node n) {
        if (n.isLiteral() && this.dtURI.equals(n.getLiteralDatatypeURI())) {
            if (!this.rdfDatatype.isValid(n.getLiteralLexicalForm())) {
                String errMsg = this.toString() + " : Not valid value : Node " + ShexLib.displayStr(n);
                return new ReportItem(errMsg, n);
            }
            return null;
        }
        if (!n.isLiteral()) {
            return new ReportItem(this.toString() + " : Not a literal", n);
        }
        Node dt = NodeFactory.createURI(n.getLiteralDatatypeURI());
        String errMsg = this.toString() + " -- Wrong datatype: " + ShexLib.strDatatype(n) + " for focus node: " + ShexLib.displayStr(n);
        return new ReportItem(errMsg, n);
    }

    @Override
    public void print(IndentedWriter out, NodeFormatter nFmt) {
        out.print("Datatype[");
        if (this.datatype.isBlank()) {
            out.print("<_:");
            out.print(this.datatype.getBlankNodeLabel());
            out.print(">");
        } else if (this.datatype.isURI() && this.dtURI.startsWith(XSD.getURI())) {
            out.print("xsd:");
            out.print(this.datatype.getLocalName());
        } else {
            nFmt.format(out, this.datatype);
        }
        out.println("]");
    }

    @Override
    public void visit(ShapeExprVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        Object x = this.datatype.isURI() ? (this.dtURI.startsWith(XSD.getURI()) ? "xsd:" + this.datatype.getLocalName() : "<" + this.dtURI + ">") : (this.datatype.isBlank() ? "<_:" + this.datatype.getBlankNodeLabel() + ">" : ShexLib.displayStr(this.datatype));
        return "Datatype[" + (String)x + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.datatype, this.dtURI);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatatypeConstraint)) {
            return false;
        }
        DatatypeConstraint other = (DatatypeConstraint)obj;
        return Objects.equals(this.datatype, other.datatype) && Objects.equals(this.dtURI, other.dtURI);
    }
}

