/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.examples;

import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shex.Shex;
import org.apache.jena.shex.ShexMap;
import org.apache.jena.shex.ShexReport;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.ShexValidator;
import org.apache.jena.shex.sys.ShexLib;
import org.apache.jena.vocabulary.RDF;

public class Shex03_validate {
    public static void main(String ... args) {
        String SHAPES = "examples/schema.shex";
        String DATA = "examples/data.ttl";
        System.out.println("Read data");
        Graph dataGraph = RDFDataMgr.loadGraph(DATA);
        System.out.println("Read shapes");
        ShexSchema shapes = Shex.readSchema(SHAPES);
        Node myClass = NodeFactory.createURI("http://example/myClass");
        Triple instancesOfFoo = Triple.create(Shex.FOCUS, RDF.type.asNode(), myClass);
        Node shape1 = NodeFactory.createURI("http://example/shapes#shape1");
        ShexMap shapeMap = ShexMap.newBuilder().add(instancesOfFoo, shape1).build();
        ShexMap shapeMapAlt = ShexMap.record(instancesOfFoo, shape1);
        System.out.println();
        System.out.println("Validate");
        ShexReport report = ShexValidator.get().validate(dataGraph, shapes, shapeMap);
        System.out.println();
        ShexLib.printReport(report);
    }

    static {
        LogCtl.setLogging();
    }
}

