/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.examples;

import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shex.Shex;
import org.apache.jena.shex.ShexMap;
import org.apache.jena.shex.ShexReport;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.ShexValidator;
import org.apache.jena.shex.sys.ShexLib;

public class Shex02_validateNode {
    public static void main(String ... args) {
        String SHAPES = "examples/schema.shex";
        String SHAPES_MAP = "examples/shape-map.shexmap";
        String DATA = "examples/data.ttl";
        System.out.println("Read data");
        Graph dataGraph = RDFDataMgr.loadGraph(DATA);
        System.out.println("Read shapes");
        ShexSchema shapes = Shex.readSchema(SHAPES);
        System.out.println("Read shapes map");
        ShexMap shapeMap = Shex.readShapeMap(SHAPES_MAP);
        Node data1 = NodeFactory.createURI("http://example/x");
        Node data2 = NodeFactory.createURI("http://example/s");
        System.out.println();
        System.out.println("Validate 1");
        ShexReport report1 = ShexValidator.get().validate(dataGraph, shapes, shapeMap, data1);
        System.out.println();
        ShexLib.printReport(report1);
        System.out.println();
        System.out.println("Validate 2");
        ShexReport report2 = ShexValidator.get().validate(dataGraph, shapes, shapeMap, data2);
        System.out.println();
        ShexLib.printReport(report2);
    }

    static {
        LogCtl.setLogging();
    }
}

