/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.writer.DirectiveStyle;
import org.apache.jena.sparql.util.Context;
import org.junit.Assert;
import org.junit.Test;

public class TestTurtleWriter {
    static String cycle1 = "_:a <urn:xx:p> _:b . _:b <urn:xx:q> _:a .";
    static String cycle2 = "_:a <urn:xx:p> _:b . _:b <urn:xx:q> _:a . _:a <urn:xx:r> \"abc\" . ";
    static String base = "http://example.org/";
    static String basetester = "@base <" + base + "> .   @prefix rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .   @prefix foaf:  <http://xmlns.com/foaf/0.1/> .  <green-goblin> rdf:type foaf:Person .";
    static final Model baseTestData = ModelFactory.createDefaultModel();

    static void blankNodeLang(String testdata, RDFFormat lang) {
        StringReader r = new StringReader(testdata);
        Model m = ModelFactory.createDefaultModel();
        RDFDataMgr.read(m, r, null, RDFLanguages.NTRIPLES);
        Assert.assertTrue((m.size() > 0L ? 1 : 0) != 0);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)output, m, lang);
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        Model m2 = ModelFactory.createDefaultModel();
        RDFDataMgr.read(m2, (InputStream)input, lang.getLang());
        Assert.assertTrue((m2.size() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void bnode_cycles_01() {
        TestTurtleWriter.blankNodeLang(cycle1, RDFFormat.TURTLE);
    }

    @Test
    public void bnode_cycles_02() {
        TestTurtleWriter.blankNodeLang(cycle1, RDFFormat.TURTLE_BLOCKS);
    }

    @Test
    public void bnode_cycles_03() {
        TestTurtleWriter.blankNodeLang(cycle1, RDFFormat.TURTLE_FLAT);
    }

    @Test
    public void bnode_cycles_04() {
        TestTurtleWriter.blankNodeLang(cycle1, RDFFormat.TURTLE_PRETTY);
    }

    @Test
    public void bnode_cycles_05() {
        TestTurtleWriter.blankNodeLang(cycle2, RDFFormat.TURTLE);
    }

    @Test
    public void bnode_cycles_06() {
        TestTurtleWriter.blankNodeLang(cycle2, RDFFormat.TURTLE_BLOCKS);
    }

    @Test
    public void bnode_cycles_07() {
        TestTurtleWriter.blankNodeLang(cycle2, RDFFormat.TURTLE_FLAT);
    }

    @Test
    public void bnode_cycles_08() {
        TestTurtleWriter.blankNodeLang(cycle2, RDFFormat.TURTLE_PRETTY);
    }

    @Test
    public void bnode_cycles() {
        Model m = RDFDataMgr.loadModel("testing/DAWG-Final/construct/data-ident.ttl");
        Assert.assertTrue((m.size() > 0L ? 1 : 0) != 0);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)output, m, Lang.TURTLE);
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        Model m2 = ModelFactory.createDefaultModel();
        RDFDataMgr.read(m2, (InputStream)input, Lang.TURTLE);
        Assert.assertTrue((m2.size() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void test_base_1() {
        String result = this.modelToString(baseTestData, RDFFormat.TURTLE_FLAT, null);
        int count1 = StringUtils.countMatches((CharSequence)result, "@base");
        Assert.assertEquals((long)1L, (long)count1);
        int count2 = StringUtils.countMatches((CharSequence)result, "BASE");
        Assert.assertEquals((long)0L, (long)count2);
    }

    @Test
    public void test_base_2() {
        Context cxt = RIOT.getContext().copy();
        cxt.set(RIOT.symTurtleDirectiveStyle, (Object)DirectiveStyle.AT);
        String result = this.modelToString(baseTestData, RDFFormat.TURTLE_BLOCKS, null);
        int count1 = StringUtils.countMatches((CharSequence)result, "@base");
        Assert.assertEquals((long)1L, (long)count1);
        int count2 = StringUtils.countMatches((CharSequence)result, "BASE");
        Assert.assertEquals((long)0L, (long)count2);
    }

    @Test
    public void test_base_3() {
        Context cxt = RIOT.getContext().copy();
        cxt.set(RIOT.symTurtleDirectiveStyle, (Object)DirectiveStyle.SPARQL);
        String result = this.modelToString(baseTestData, RDFFormat.TURTLE_FLAT, cxt);
        int count1 = StringUtils.countMatches((CharSequence)result, "BASE");
        Assert.assertEquals((long)1L, (long)count1);
        int count2 = StringUtils.countMatches((CharSequence)result, "@base");
        Assert.assertEquals((long)0L, (long)count2);
    }

    @Test
    public void test_base_4() {
        Context cxt = RIOT.getContext().copy();
        cxt.set(RIOT.symTurtleDirectiveStyle, (Object)DirectiveStyle.SPARQL);
        String result = this.modelToString(baseTestData, RDFFormat.TURTLE_BLOCKS, cxt);
        int count1 = StringUtils.countMatches((CharSequence)result, "BASE");
        Assert.assertEquals((long)1L, (long)count1);
        int count2 = StringUtils.countMatches((CharSequence)result, "@base");
        Assert.assertEquals((long)0L, (long)count2);
    }

    private String modelToString(Model model, RDFFormat format, Context context2) {
        String string;
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        try {
            String result;
            RDFWriter.create().source(baseTestData).format(format).base(base).context(context2).output(o);
            string = result = Bytes.bytes2string(o.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    o.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                IO.exception(ex);
                return null;
            }
        }
        o.close();
        return string;
    }

    static {
        RDFParser.fromString(basetester).lang(Lang.TTL).parse(baseTestData);
    }
}

