/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.util.IsoMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestTriXWriter {
    static String DIR = "testing/RIOT/Lang/TriX";
    @Parameterized.Parameter(value=0)
    public String fTrix;
    @Parameterized.Parameter(value=1)
    public String fNQuads;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({DIR + "/trix-01.trix", DIR + "/trix-01.nq"}, {DIR + "/trix-02.trix", DIR + "/trix-02.nq"}, {DIR + "/trix-03.trix", DIR + "/trix-03.nq"}, {DIR + "/trix-04.trix", DIR + "/trix-04.nq"}, {DIR + "/trix-05.trix", DIR + "/trix-05.nq"}, {DIR + "/trix-06.trix", DIR + "/trix-06.nq"}, {DIR + "/trix-10.trix", DIR + "/trix-10.nq"}, {DIR + "/trix-11.trix", DIR + "/trix-11.nq"}, {DIR + "/trix-12.trix", DIR + "/trix-12.nq"}, {DIR + "/trix-13.trix", DIR + "/trix-13.nq"}, {DIR + "/trix-14.trix", DIR + "/trix-14.nq"}, {DIR + "/trix-15.trix", DIR + "/trix-15.nq"}, {DIR + "/trix-star-1.trix", DIR + "/trix-star-1.nq"}, {DIR + "/trix-star-2.trix", DIR + "/trix-star-2.nq"});
    }

    @Test
    public void trix_writer() {
        DatasetGraph dsg = RDFDataMgr.loadDatasetGraph(this.fNQuads);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)bout, dsg, Lang.TRIX);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        DatasetGraph dsg2 = DatasetGraphFactory.create();
        RDFDataMgr.read(dsg2, (InputStream)bin, Lang.TRIX);
        boolean b = IsoMatcher.isomorphic(dsg, dsg2);
        Assert.assertTrue((String)"Not isomorphic", (boolean)b);
    }
}

