/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.fasterxml.jackson.core.JsonParseException;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonString;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.JsonLDWriteContext;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.writer.JsonLDWriter;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;

public class TestJsonLDWriter {
    private static RDFFormat[] JSON_LD_FORMATS = new RDFFormat[]{RDFFormat.JSONLD_COMPACT_PRETTY, RDFFormat.JSONLD_FLATTEN_PRETTY, RDFFormat.JSONLD_EXPAND_PRETTY, RDFFormat.JSONLD_FRAME_PRETTY, RDFFormat.JSONLD_COMPACT_FLAT, RDFFormat.JSONLD_FLATTEN_FLAT, RDFFormat.JSONLD_EXPAND_FLAT, RDFFormat.JSONLD_FRAME_FLAT};

    @Test
    public final void prettyIsNotFlat() {
        String ns = "http://www.a.com/foo/";
        Model m = this.simpleModel(ns);
        m.setNsPrefix("ex", ns);
        String s = this.toString(m, RDFFormat.JSONLD_EXPAND_PRETTY, null);
        Assert.assertTrue((boolean)s.trim().contains("\n"));
        s = this.toString(m, RDFFormat.JSONLD_COMPACT_PRETTY, null);
        Assert.assertTrue((boolean)s.trim().contains("\n"));
        s = this.toString(m, RDFFormat.JSONLD_FLATTEN_PRETTY, null);
        Assert.assertTrue((boolean)s.trim().contains("\n"));
        s = this.toString(m, RDFFormat.JSONLD_EXPAND_FLAT, null);
        Assert.assertFalse((boolean)s.trim().contains("\n"));
        s = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, null);
        Assert.assertFalse((boolean)s.trim().contains("\n"));
        s = this.toString(m, RDFFormat.JSONLD_FLATTEN_FLAT, null);
        Assert.assertFalse((boolean)s.trim().contains("\n"));
        Assert.assertFalse((boolean)s.trim().contains("\n"));
    }

    @Test
    public final void contextOrNot() {
        String ns = "http://www.a.com/foo/";
        Model m = this.simpleModel(ns);
        m.setNsPrefix("ex", ns);
        String s = this.toString(m, RDFFormat.JSONLD_EXPAND_PRETTY, null);
        Assert.assertFalse((boolean)s.contains("@context"));
        s = this.toString(m, RDFFormat.JSONLD_EXPAND_FLAT, null);
        Assert.assertFalse((boolean)s.contains("@context"));
        s = this.toString(m, RDFFormat.JSONLD_COMPACT_PRETTY, null);
        Assert.assertTrue((boolean)s.contains("@context"));
        s = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, null);
        Assert.assertTrue((boolean)s.contains("@context"));
        s = this.toString(m, RDFFormat.JSONLD_FLATTEN_PRETTY, null);
        Assert.assertTrue((boolean)s.contains("@context"));
        s = this.toString(m, RDFFormat.JSONLD_FLATTEN_FLAT, null);
        Assert.assertTrue((boolean)s.contains("@context"));
    }

    private Model simpleModel(String ns) {
        Model m = ModelFactory.createDefaultModel();
        Resource s = m.createResource(ns + "s");
        Property p = m.createProperty(ns + "p");
        Resource o = m.createResource(ns + "o");
        m.add(s, p, o);
        return m;
    }

    @Test
    public final void roundTrip() {
        String ns = "http://www.a.com/foo/";
        Model m = this.simpleModel(ns);
        m.setNsPrefix("ex", ns);
        for (RDFFormat f : JSON_LD_FORMATS) {
            if (((RDFFormat.JSONLDVariant)f.getVariant()).isFrame()) continue;
            String s = this.toString(m, f, null);
            Model m2 = this.parse(s);
            Assert.assertTrue((boolean)m2.isIsomorphicWith(m));
        }
    }

    @Test
    public final void noEmptyPrefixInContext() {
        String ns = "http://www.a.com/foo/";
        Model m = this.simpleModel(ns);
        m.setNsPrefix("", ns);
        String jsonld = this.toString(m, RDFFormat.JSONLD_COMPACT_PRETTY, null);
        Assert.assertFalse((boolean)jsonld.contains("\"\""));
        Model m2 = this.parse(jsonld);
        Assert.assertTrue((boolean)m2.isIsomorphicWith(m));
    }

    @Test
    public void testSettingContextAsJsonString() {
        String ns = "http://www.a.com/foo/";
        Model m = this.simpleModel(ns);
        m.setNsPrefix("ex", ns);
        String s1 = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, null);
        String prefixStringInResult = "\"ex\":\"" + ns + "\"";
        Assert.assertTrue((boolean)s1.contains(prefixStringInResult));
        Model m1 = this.parse(s1);
        JsonObject obj = new JsonObject();
        obj.put("@id", ns + "p");
        obj.put("@type", "@id");
        JsonObject json2 = new JsonObject();
        json2.put("p", obj);
        json2.put("ex", ns);
        Object js = json2.toString();
        m.removeNsPrefix("ex");
        String s2 = this.toString(m, RDFFormat.JSONLD_COMPACT_PRETTY, null);
        Assert.assertFalse((boolean)s2.contains(prefixStringInResult));
        JsonLDWriteContext jenaCtx = new JsonLDWriteContext();
        jenaCtx.setJsonLDContext((String)js);
        String s3 = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, jenaCtx);
        Assert.assertTrue((s3.length() == s1.length() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s3.contains(prefixStringInResult));
        Model m3 = this.parse(s3);
        Assert.assertTrue((boolean)m3.isIsomorphicWith(m));
        Assert.assertTrue((boolean)m3.isIsomorphicWith(m1));
        js = "{\"@context\":" + (String)js + "}";
        jenaCtx.setJsonLDContext((String)js);
        String s4 = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, jenaCtx);
        Assert.assertTrue((s4.length() == s1.length() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s4.contains(prefixStringInResult));
        Model m4 = this.parse(s4);
        Assert.assertTrue((boolean)m4.isIsomorphicWith(m));
        Assert.assertTrue((boolean)m4.isIsomorphicWith(m1));
    }

    @Test
    public void testSettingContextAsObjectExpectedByJsonldAPI() {
        String ns = "http://www.a.com/foo/";
        Model m = this.simpleModel(ns);
        m.setNsPrefix("ex", ns);
        String s1 = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, null);
        String prefixStringInResult = "\"ex\":\"" + ns + "\"";
        Assert.assertTrue((boolean)s1.contains(prefixStringInResult));
        Model m1 = this.parse(s1);
        Object ctx = JsonLDWriter.createJsonldContext(m.getGraph());
        m.removeNsPrefix("ex");
        String s2 = this.toString(m, RDFFormat.JSONLD_COMPACT_PRETTY, null);
        Assert.assertFalse((boolean)s2.contains(prefixStringInResult));
        Context jenaCtx = new Context();
        jenaCtx.set(JsonLDWriter.JSONLD_CONTEXT, ctx);
        String s3 = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, jenaCtx);
        Assert.assertTrue((s3.length() == s1.length() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s3.contains(prefixStringInResult));
        Model m3 = this.parse(s3);
        Assert.assertTrue((boolean)m3.isIsomorphicWith(m));
        Assert.assertTrue((boolean)m3.isIsomorphicWith(m1));
    }

    @Test
    public final void testContextByUri() {
        Model m = ModelFactory.createDefaultModel();
        String ns = "http://schema.org/";
        Resource s = m.createResource();
        m.add(s, m.createProperty(ns + "name"), "Jane Doe");
        m.add(s, m.createProperty(ns + "url"), "http://www.janedoe.com");
        m.add(s, RDF.type, "Person");
        JsonLDWriteContext jenaContext = new JsonLDWriteContext();
        jenaContext.setJsonLDContext("{\"@context\" : \"http://schema.org/\"}");
        String jsonld = this.toString(m, RDFFormat.JSONLD, jenaContext);
        Model m2 = this.parse(jsonld);
        Assert.assertTrue((boolean)m2.isIsomorphicWith(m));
    }

    @Test
    public void testSubstitutingContext() {
        Model m = ModelFactory.createDefaultModel();
        String ns = "http://schema.org/";
        Resource person = m.createResource(ns + "Person");
        Resource s = m.createResource();
        m.add(s, m.createProperty(ns + "name"), "Jane Doe");
        m.add(s, m.createProperty(ns + "url"), "http://www.janedoe.com");
        m.add(s, m.createProperty(ns + "jobTitle"), "Professor");
        m.add(s, RDF.type, person);
        JsonLDWriteContext jenaCtx = new JsonLDWriteContext();
        jenaCtx.setJsonLDContextSubstitution(new JsonString(ns).toString());
        String jsonld = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, jenaCtx);
        String c = "\"@context\":\"http://schema.org/\"";
        Assert.assertTrue((boolean)jsonld.contains(c));
        String ctx = "{\"jobTitle\":{\"@id\":\"http://ex.com/jobTitle\"},\"url\":{\"@id\":\"http://ex.com/url\"},\"name\":{\"@id\":\"http://ex.com/name\"}}";
        jenaCtx.setJsonLDContextSubstitution(ctx);
        jsonld = this.toString(m, RDFFormat.JSONLD_COMPACT_FLAT, jenaCtx);
        Assert.assertTrue((boolean)jsonld.contains("http://ex.com/name"));
    }

    @Test
    public final void testFrames() throws JsonParseException, IOException {
        Model m = ModelFactory.createDefaultModel();
        String ns = "http://schema.org/";
        Resource person = m.createResource(ns + "Person");
        Resource s = m.createResource();
        m.add(s, m.createProperty(ns + "name"), "Jane Doe");
        m.add(s, m.createProperty(ns + "url"), "http://www.janedoe.com");
        m.add(s, m.createProperty(ns + "jobTitle"), "Professor");
        m.add(s, RDF.type, person);
        s = m.createResource();
        m.add(s, m.createProperty(ns + "name"), "Gado Salamatou");
        m.add(s, m.createProperty(ns + "url"), "http://www.salamatou.com");
        m.add(s, RDF.type, person);
        s = m.createResource();
        m.add(s, m.createProperty(ns + "name"), "Not a person");
        m.add(s, RDF.type, m.createResource(ns + "Event"));
        Context jenaCtx = new Context();
        JsonObject frame = new JsonObject();
        frame.put("@type", ns + "Person");
        jenaCtx.set(JsonLDWriter.JSONLD_FRAME, frame.toString());
        String jsonld = this.toString(m, RDFFormat.JSONLD_FRAME_PRETTY, jenaCtx);
        Model m2 = this.parse(jsonld);
        Assert.assertTrue((m2.listStatements((Resource)null, RDF.type, (RDFNode)null).toList().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((m2.listStatements((Resource)null, RDF.type, person).toList().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)jsonld.trim().contains("\n"));
        frame = new JsonObject();
        frame.put("http://schema.org/jobTitle", new JsonObject());
        jenaCtx.set(JsonLDWriter.JSONLD_FRAME, JsonUtils.fromString(frame.toString()));
        jsonld = this.toString(m, RDFFormat.JSONLD_FRAME_FLAT, jenaCtx);
        m2 = this.parse(jsonld);
        Assert.assertTrue((m2.listStatements((Resource)null, RDF.type, (RDFNode)null).toList().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((m2.listStatements((Resource)null, m.createProperty(ns + "jobTitle"), (RDFNode)null).toList().size() == 1 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)jsonld.trim().contains("\n"));
    }

    @Test
    public final void testStringPropsInContext() {
        Model m = ModelFactory.createDefaultModel();
        String ns = "http://www.a.com/foo/";
        Resource s = m.createResource(ns + "s");
        m.add(s, m.createProperty(ns + "plangstring"), "a langstring", "fr");
        m.add(s, m.createProperty(ns + "pint"), m.createTypedLiteral(42));
        m.add(s, m.createProperty(ns + "pfloat"), m.createTypedLiteral(1789.14f));
        m.add(s, m.createProperty(ns + "pstring"), m.createTypedLiteral("a TypedLiteral atring"));
        String jsonld = this.toString(m, RDFFormat.JSONLD_FLAT, null);
        String vv = "\"plangstring\":{\"@language\":\"fr\",\"@value\":\"a langstring\"}";
        Assert.assertTrue((boolean)jsonld.contains(vv));
    }

    @Test
    public final void clashOfPropLocalnames() {
        Model m = ModelFactory.createDefaultModel();
        Resource s = m.createResource();
        String ns1 = "http://schema.org/";
        String ns2 = "http://ex.com/";
        m.add(s, m.createProperty(ns1 + "name"), "schema.org name");
        m.add(s, m.createProperty(ns2 + "name"), "ex.com name");
        String jsonld = this.toString(m, RDFFormat.JSONLD, null);
        Assert.assertTrue((boolean)jsonld.contains("\"name\" : \""));
        Assert.assertTrue((boolean)jsonld.contains("/name\" : \""));
        m.setNsPrefix("ns1", ns1);
        m.setNsPrefix("ns2", "http://ex.com/");
        jsonld = this.toString(m, RDFFormat.JSONLD, null);
        Assert.assertTrue((boolean)jsonld.contains("\"name\" : \""));
        Assert.assertTrue((jsonld.contains("\"ns1:name\" : \"") || jsonld.contains("\"ns2:name\" : \"") ? 1 : 0) != 0);
    }

    @Test
    public final void jsonldOptions() {
        Model m = ModelFactory.createDefaultModel();
        String ns = "http://schema.org/";
        Resource s = m.createResource();
        m.add(s, m.createProperty(ns + "name"), "Jane Doe");
        m.add(s, m.createProperty(ns + "url"), "http://www.janedoe.com");
        m.add(s, m.createProperty(ns + "jobTitle"), "Professor");
        String jsonld = this.toString(m, RDFFormat.JSONLD, null);
        Assert.assertFalse((boolean)jsonld.contains("@graph"));
        Assert.assertTrue((boolean)jsonld.contains("\"jobTitle\" : \"Professor\""));
        JsonLDWriteContext jenaCtx = new JsonLDWriteContext();
        JsonLdOptions opts = new JsonLdOptions(null);
        opts.setCompactArrays(false);
        jenaCtx.setOptions(opts);
        jsonld = this.toString(m, RDFFormat.JSONLD, jenaCtx);
        Assert.assertTrue((boolean)jsonld.contains("@graph"));
        Assert.assertTrue((boolean)jsonld.contains("\"jobTitle\" : [ \"Professor\" ]"));
    }

    @Test
    public final void atVocab() throws JsonParseException, JsonLdError, IOException {
        Model m = ModelFactory.createDefaultModel();
        String ns = "http://schema.org/";
        Resource person = m.createResource(ns + "Person");
        Resource s = m.createResource("http://doe.com/jane");
        m.add(s, m.createProperty(ns + "name"), "Jane Doe");
        m.add(s, RDF.type, person);
        Resource s2 = m.createResource("http://doe.com/joe");
        m.add(s2, m.createProperty(ns + "name"), "John Doe");
        m.add(s2, RDF.type, person);
        m.add(s, m.createProperty(ns + "knows"), s2);
        m.setNsPrefix("", ns);
        String jsonld = this.toString(m, RDFFormat.JSONLD, null);
        Assert.assertTrue((boolean)jsonld.contains("@vocab"));
    }

    @Test
    public final void atVocabJENA1292() throws JsonParseException, JsonLdError, IOException {
        Model m = ModelFactory.createDefaultModel();
        String ns = "http://schema.org/";
        Resource person = m.createResource(ns + "Person");
        Resource s = m.createResource();
        m.add(s, m.createProperty(ns + "name"), "Jane Doe");
        m.add(s, m.createProperty(ns + "url"), "http://www.janedoe.com");
        m.add(s, m.createProperty(ns + "jobTitle"), "Professor");
        m.add(s, FOAF.nick, "jd");
        m.add(s, RDF.type, person);
        m.setNsPrefix("", ns);
        DatasetGraph g = DatasetFactory.wrap(m).asDatasetGraph();
        PrefixMap pm = g.prefixes();
        String base = null;
        Context jenaContext = null;
        Map map = (Map)JsonLDWriter.toJsonLDJavaAPI((RDFFormat.JSONLDVariant)RDFFormat.JSONLD.getVariant(), g, pm, base, jenaContext);
        Map ctx = (Map)map.get("@context");
        ArrayList<String> remove = new ArrayList<String>();
        for (Map.Entry e2 : ctx.entrySet()) {
            Object o = e2.getValue();
            if (o instanceof Map) {
                o = ((Map)o).get("@id");
            }
            if (o == null || !(o instanceof String) || !((String)o).equals(ns + (String)e2.getKey())) continue;
            remove.add((String)e2.getKey());
        }
        for (String key : remove) {
            ctx.remove(key);
        }
        ctx.put("@vocab", "http://schema.org/");
    }

    private String toString(Model m, RDFFormat f, Context jenaContext) {
        String string;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            RDFWriter.create(m).format(f).context(jenaContext).output(out);
            out.flush();
            string = out.toString("UTF-8");
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        out.close();
        return string;
    }

    private Model parse(String jsonld) {
        Model m = ModelFactory.createDefaultModel();
        StringReader reader = new StringReader(jsonld);
        m.read(reader, null, "JSON-LD");
        return m;
    }
}

