/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.web;

import org.apache.jena.riot.web.LangTag;
import org.junit.Assert;
import org.junit.Test;

public class TestLangTag {
    @Test
    public void parse_01() {
        TestLangTag.parseGood("en", "en", "en", null, null, null, null);
    }

    @Test
    public void parse_02() {
        TestLangTag.parseGood("en-uk", "en-UK", "en", null, "UK", null, null);
    }

    @Test
    public void parse_03() {
        TestLangTag.parseGood("es-419", "es-419", "es", null, "419", null, null);
    }

    @Test
    public void parse_04() {
        TestLangTag.parseGood("zh-Hant", "zh-Hant", "zh", "Hant", null, null, null);
    }

    @Test
    public void parse_05() {
        TestLangTag.parseGood("sr-Latn-CS", "sr-Latn-CS", "sr", "Latn", "CS", null, null);
    }

    @Test
    public void parse_06() {
        TestLangTag.parseGood("sl-nedis", "sl-nedis", "sl", null, null, "nedis", null);
    }

    @Test
    public void parse_07() {
        TestLangTag.parseGood("sl-IT-nedis", "sl-IT-nedis", "sl", null, "IT", "nedis", null);
    }

    @Test
    public void parse_08() {
        TestLangTag.parseGood("sl-Latn-IT-nedis", "sl-Latn-IT-nedis", "sl", "Latn", "IT", "nedis", null);
    }

    @Test
    public void parse_09() {
        TestLangTag.parseGood("de-CH-x-Phonebk", "de-CH-x-Phonebk", "de", null, "CH", null, "x-Phonebk");
    }

    @Test
    public void parse_10() {
        TestLangTag.parseGood("zh-cn-a-myExt-x-private", "zh-CN-a-myExt-x-private", "zh", null, "CN", null, "a-myExt-x-private");
    }

    @Test
    public void parse_bad_01() {
        TestLangTag.parseBad("i18n");
    }

    @Test
    public void parse_bad_02() {
        TestLangTag.parseBad("i@n");
    }

    @Test
    public void parse_bad_03() {
        TestLangTag.parseBad("123-abc");
    }

    @Test
    public void parse_bad_04() {
        TestLangTag.parseBad("en-");
    }

    private static void parseGood(String input, String ex_output, String ... ex_parts) {
        Object[] parts = LangTag.parse(input);
        Assert.assertArrayEquals((Object[])ex_parts, (Object[])parts);
        String output = LangTag.canonical(input);
        Assert.assertEquals((Object)ex_output, (Object)output);
        Assert.assertTrue((boolean)LangTag.check(input));
    }

    private static void parseBad(String input) {
        String[] parts = LangTag.parse(input);
        Assert.assertNull((Object)parts);
        String output = LangTag.canonical(input);
        Assert.assertEquals((Object)input, (Object)output);
        Assert.assertFalse((boolean)LangTag.check(input));
    }

    private void testCanonical(String input, String ex_output) {
        String output = LangTag.canonical(input);
        Assert.assertEquals((Object)ex_output, (Object)output);
    }

    @Test
    public void parseCanonical_10() {
        this.testCanonical("zh-hant", "zh-Hant");
    }

    @Test
    public void parseCanonical_11() {
        this.testCanonical("zh-latn-wadegile", "zh-Latn-wadegile");
    }

    @Test
    public void parseCanonical_12() {
        this.testCanonical("zh-latn-pinyin", "zh-Latn-pinyin");
    }

    @Test
    public void parseCanonical_13() {
        this.testCanonical("en-us", "en-US");
    }

    @Test
    public void parseCanonical_14() {
        this.testCanonical("EN-Gb", "en-GB");
    }

    @Test
    public void parseCanonical_15() {
        this.testCanonical("qqq-002", "qqq-002");
    }

    @Test
    public void parseCanonical_16() {
        this.testCanonical("ja-latn", "ja-Latn");
    }

    @Test
    public void parseCanonical_17() {
        this.testCanonical("x-local", "x-local");
    }

    @Test
    public void parseCanonical_18() {
        this.testCanonical("he-latn", "he-Latn");
    }

    @Test
    public void parseCanonical_19() {
        this.testCanonical("und", "und");
    }

    @Test
    public void parseCanonical_20() {
        this.testCanonical("nn", "nn");
    }

    @Test
    public void parseCanonical_21() {
        this.testCanonical("ko-latn", "ko-Latn");
    }

    @Test
    public void parseCanonical_22() {
        this.testCanonical("ar-latn", "ar-Latn");
    }

    @Test
    public void parseCanonical_23() {
        this.testCanonical("la-x-liturgic", "la-x-liturgic");
    }

    @Test
    public void parseCanonical_24() {
        this.testCanonical("fa-x-middle", "fa-x-middle");
    }

    @Test
    public void parseCanonical_25() {
        this.testCanonical("qqq-142", "qqq-142");
    }

    @Test
    public void parseCanonical_26() {
        this.testCanonical("bnt", "bnt");
    }

    @Test
    public void parseCanonical_27() {
        this.testCanonical("grc-x-liturgic", "grc-x-liturgic");
    }

    @Test
    public void parseCanonical_28() {
        this.testCanonical("egy-Latn", "egy-Latn");
    }

    @Test
    public void parseCanonical_29() {
        this.testCanonical("la-x-medieval", "la-x-medieval");
    }
}

