/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import org.apache.jena.JenaRuntime;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.ThriftConvert;
import org.apache.jena.riot.thrift.wire.RDF_BNode;
import org.apache.jena.riot.thrift.wire.RDF_IRI;
import org.apache.jena.riot.thrift.wire.RDF_Literal;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;
import org.junit.Assert;
import org.junit.Test;

public class TestThriftTerm {
    static PrefixMap prefixMap = PrefixMapFactory.create();

    @Test
    public void term_uri_01() {
        this.testTerm("<http://hostname/>");
    }

    @Test
    public void term_uri_02() {
        RDF_Term rt = this.testTerm("<http://example/>");
        Assert.assertTrue((boolean)rt.isSetPrefixName());
        Assert.assertEquals((Object)rt.getPrefixName().prefix, (Object)"");
        Assert.assertEquals((Object)rt.getPrefixName().localName, (Object)"");
    }

    @Test
    public void term_uri_03() {
        RDF_Term rt = this.testTerm("<http://namespace/ns#foobar>");
        Assert.assertTrue((boolean)rt.isSetPrefixName());
        Assert.assertEquals((Object)rt.getPrefixName().prefix, (Object)"ns");
        Assert.assertEquals((Object)rt.getPrefixName().localName, (Object)"foobar");
    }

    @Test
    public void term_uri_04() {
        RDF_Term rt = this.testTerm("rdf:type");
        Assert.assertTrue((boolean)rt.isSetPrefixName());
        Assert.assertEquals((Object)rt.getPrefixName().prefix, (Object)"rdf");
        Assert.assertEquals((Object)rt.getPrefixName().localName, (Object)"type");
    }

    @Test
    public void term_literal_01() {
        RDF_Term rt = this.testTerm("'foo'");
        Assert.assertFalse((boolean)rt.getLiteral().isSetDatatype());
        Assert.assertFalse((boolean)rt.getLiteral().isSetDtPrefix());
        Assert.assertFalse((boolean)rt.getLiteral().isSetLangtag());
    }

    @Test
    public void term_literal_02() {
        RDF_Term rt = this.testTerm("'foo'@en");
        Assert.assertFalse((boolean)rt.getLiteral().isSetDatatype());
        Assert.assertFalse((boolean)rt.getLiteral().isSetDtPrefix());
        Assert.assertTrue((boolean)rt.getLiteral().isSetLangtag());
    }

    @Test
    public void term_literal_03() {
        RDF_Term rt = this.testTerm("123");
        Assert.assertFalse((boolean)rt.getLiteral().isSetDatatype());
        Assert.assertTrue((boolean)rt.getLiteral().isSetDtPrefix());
        Assert.assertEquals((Object)rt.getLiteral().getDtPrefix().getPrefix(), (Object)"xsd");
        Assert.assertEquals((Object)rt.getLiteral().getDtPrefix().getLocalName(), (Object)"integer");
    }

    @Test
    public void term_literal_04() {
        RDF_Term rt = this.testTerm("'foo'^^<http://dataype/>");
        Assert.assertTrue((boolean)rt.getLiteral().isSetDatatype());
        Assert.assertFalse((boolean)rt.getLiteral().isSetDtPrefix());
        Assert.assertEquals((Object)rt.getLiteral().getDatatype(), (Object)"http://dataype/");
    }

    @Test
    public void term_literal_05() {
        RDF_Term rt = this.testTerm("'foo'^^<http://example/>");
        Assert.assertFalse((boolean)rt.getLiteral().isSetDatatype());
        Assert.assertTrue((boolean)rt.getLiteral().isSetDtPrefix());
        Assert.assertEquals((Object)rt.getLiteral().getDtPrefix().getPrefix(), (Object)"");
        Assert.assertEquals((Object)rt.getLiteral().getDtPrefix().getLocalName(), (Object)"");
    }

    @Test
    public void term_var_01() {
        this.testTerm("?var");
    }

    @Test
    public void term_bnode_01() {
        Node n = SSE.parseNode("_:blanknode");
        RDF_Term rt = this.testTerm(n);
        Assert.assertEquals((Object)rt.getBnode().getLabel(), (Object)n.getBlankNodeLabel());
    }

    @Test
    public void term_bnode_02() {
        String label = "abcdefghijklmn";
        Node n = NodeFactory.createBlankNode("abcdefghijklmn");
        RDF_Term rt = this.testTerm(n);
        Assert.assertTrue((boolean)rt.isSetBnode());
        Assert.assertEquals((Object)"abcdefghijklmn", (Object)rt.getBnode().getLabel());
    }

    @Test
    public void term_any_1() {
        RDF_Term rt = this.testTerm(Node.ANY);
        Assert.assertTrue((boolean)rt.isSetAny());
    }

    @Test
    public void term_value_01() {
        RDF_Term rt = this.testTermValue("123");
        Assert.assertTrue((boolean)rt.isSetValInteger());
        Assert.assertEquals((long)123L, (long)rt.getValInteger());
    }

    @Test
    public void term_value_02() {
        RDF_Term rt = this.testTermValue("'123'^^xsd:integer");
        Assert.assertTrue((boolean)rt.isSetValInteger());
        Assert.assertEquals((long)123L, (long)rt.getValInteger());
    }

    @Test
    public void term_value_03() {
        RDF_Term rt = this.testTermValue("'123'^^xsd:long");
        Assert.assertTrue((boolean)rt.isSetValInteger());
        Assert.assertEquals((long)123L, (long)rt.getValInteger());
    }

    @Test
    public void term_value_04() {
        RDF_Term rt = this.testTermValue("'123'^^xsd:int");
        Assert.assertTrue((boolean)rt.isSetValInteger());
        Assert.assertEquals((long)123L, (long)rt.getValInteger());
    }

    @Test
    public void term_value_05() {
        RDF_Term rt = this.testTermValue("'123'^^xsd:short");
        Assert.assertTrue((boolean)rt.isSetValInteger());
        Assert.assertEquals((long)123L, (long)rt.getValInteger());
    }

    @Test
    public void term_value_06() {
        RDF_Term rt = this.testTermValue("'123'^^xsd:byte");
        Assert.assertTrue((boolean)rt.isSetValInteger());
        Assert.assertEquals((long)123L, (long)rt.getValInteger());
    }

    @Test
    public void term_value_10() {
        RDF_Term rt = this.testTermValue("123.6");
        Assert.assertTrue((boolean)rt.isSetValDecimal());
        Assert.assertEquals((long)1236L, (long)rt.getValDecimal().getValue());
        Assert.assertEquals((long)1L, (long)rt.getValDecimal().getScale());
    }

    @Test
    public void term_value_11() {
        RDF_Term rt = this.testTermValue("0.005");
        Assert.assertTrue((boolean)rt.isSetValDecimal());
        Assert.assertEquals((long)5L, (long)rt.getValDecimal().getValue());
        Assert.assertEquals((long)3L, (long)rt.getValDecimal().getScale());
    }

    @Test
    public void term_value_12() {
        RDF_Term rt = this.testTermValue("50.0");
        Assert.assertTrue((boolean)rt.isSetValDecimal());
        Assert.assertEquals((long)500L, (long)rt.getValDecimal().getValue());
        Assert.assertEquals((long)1L, (long)rt.getValDecimal().getScale());
    }

    @Test
    public void term_value_13() {
        RDF_Term rt = this.testTermValue("50.05");
        Assert.assertTrue((boolean)rt.isSetValDecimal());
        Assert.assertEquals((long)5005L, (long)rt.getValDecimal().getValue());
        Assert.assertEquals((long)2L, (long)rt.getValDecimal().getScale());
    }

    @Test
    public void term_value_20() {
        RDF_Term rt = this.testTermValue("50e6");
        Assert.assertTrue((boolean)rt.isSetValDouble());
        Assert.assertEquals((double)5.0E7, (double)rt.getValDouble(), (double)0.001);
    }

    @Test
    public void term_value_21() {
        RDF_Term rt = this.testTermValue("50e-6");
        Assert.assertTrue((boolean)rt.isSetValDouble());
        Assert.assertEquals((double)5.0E-5, (double)rt.getValDouble(), (double)1000.0);
    }

    private RDF_Term testTermValue(String str2) {
        RDF_Term rt = this.testTerm(SSE.parseNode(str2), prefixMap, true);
        return rt;
    }

    private RDF_Term testTerm(String str2) {
        RDF_Term rt = this.testTerm(SSE.parseNode(str2), prefixMap, false);
        return rt;
    }

    private RDF_Term testTerm(Node node) {
        return this.testTerm(node, null, false);
    }

    private RDF_Term testTerm(Node node, PrefixMap pmap, boolean asValue) {
        RDF_Term rt = ThriftConvert.convert(node, pmap, asValue);
        Assert.assertTrue((boolean)rt.isSet());
        if (node == null) {
            Assert.assertTrue((boolean)rt.isSetUndefined());
        } else if (node.isURI()) {
            Assert.assertTrue((rt.isSetIri() || rt.isSetPrefixName() ? 1 : 0) != 0);
            if (rt.isSetIri()) {
                RDF_IRI iri2 = rt.getIri();
                Assert.assertEquals((Object)node.getURI(), (Object)iri2.getIri());
            }
            if (rt.isSetPrefixName()) {
                Assert.assertTrue((boolean)rt.getPrefixName().isSetPrefix());
                Assert.assertTrue((boolean)rt.getPrefixName().isSetLocalName());
            }
        } else {
            if (rt.isSetValDecimal() || rt.isSetValDouble() || rt.isSetValInteger()) {
                return rt;
            }
            if (node.isLiteral()) {
                Assert.assertTrue((boolean)rt.isSetLiteral());
                RDF_Literal lit = rt.getLiteral();
                Assert.assertTrue((boolean)lit.isSetLex());
                Assert.assertEquals((Object)node.getLiteralLexicalForm(), (Object)lit.getLex());
                if (JenaRuntime.isRDF11) {
                    if (Util.isSimpleString(node)) {
                        Assert.assertFalse((boolean)lit.isSetDatatype());
                        Assert.assertFalse((boolean)lit.isSetDtPrefix());
                        Assert.assertFalse((boolean)lit.isSetLangtag());
                    } else if (Util.isLangString(node)) {
                        Assert.assertFalse((boolean)lit.isSetDatatype());
                        Assert.assertFalse((boolean)lit.isSetDtPrefix());
                        Assert.assertTrue((boolean)lit.isSetLangtag());
                    } else {
                        Assert.assertTrue((lit.isSetDatatype() || lit.isSetDtPrefix() ? 1 : 0) != 0);
                        Assert.assertFalse((boolean)lit.isSetLangtag());
                    }
                } else if (node.getLiteralDatatype() == null) {
                    if (Util.isLangString(node)) {
                        Assert.assertFalse((boolean)lit.isSetDatatype());
                        Assert.assertFalse((boolean)lit.isSetDtPrefix());
                        Assert.assertTrue((boolean)lit.isSetLangtag());
                    } else {
                        Assert.assertFalse((boolean)lit.isSetDatatype());
                        Assert.assertFalse((boolean)lit.isSetDtPrefix());
                        Assert.assertFalse((boolean)lit.isSetLangtag());
                    }
                } else {
                    Assert.assertTrue((lit.isSetDatatype() || lit.isSetDtPrefix() ? 1 : 0) != 0);
                }
            } else if (node.isBlank()) {
                Assert.assertTrue((boolean)rt.isSetBnode());
                RDF_BNode bnode2 = rt.getBnode();
                Assert.assertEquals((Object)node.getBlankNodeLabel(), (Object)bnode2.getLabel());
            } else if (node.isVariable()) {
                Assert.assertTrue((boolean)rt.isSetVariable());
                Assert.assertEquals((Object)node.getName(), (Object)rt.getVariable().getName());
            } else if (Node.ANY.equals(node)) {
                Assert.assertTrue((boolean)rt.isSetAny());
            } else {
                Assert.fail((String)"Unknown node type");
            }
        }
        Node n2 = ThriftConvert.convert(rt, pmap);
        Assert.assertEquals((Object)node, (Object)n2);
        return rt;
    }

    @Test
    public void rdfterm_01() {
        RDF_Term rt = TRDF.tANY;
        Node n = ThriftConvert.convert(rt);
        Assert.assertEquals((Object)Node.ANY, (Object)n);
    }

    @Test
    public void rdfterm_02() {
        RDF_Term rt = TRDF.tUNDEF;
        Node n = ThriftConvert.convert(rt);
        Assert.assertNull((Object)n);
    }

    @Test
    public void round_trip_01() {
        this.testTerm(null, null, false);
    }

    @Test
    public void round_trip_02() {
        this.testTerm(Node.ANY, null, false);
    }

    @Test
    public void round_trip_03() {
        this.testTerm(NodeFactory.createVariable("x"), null, false);
    }

    @Test
    public void round_trip_bytes_01() {
        this.testTermBytes(NodeFactory.createURI("http://example/"));
    }

    @Test
    public void round_trip_bytes_02() {
        this.testTermBytes(NodeFactory.createLiteral("value"));
    }

    @Test
    public void round_trip_bytes_03() {
        this.testTermBytes(NodeFactory.createBlankNode("0123456"));
    }

    private void testTermBytes(Node node) {
        RDF_Term rt = ThriftConvert.convert(node, false);
        byte[] b = ThriftConvert.termToBytes(rt);
        RDF_Term rt2 = ThriftConvert.termFromBytes(b);
        Node node2 = ThriftConvert.convert(rt2);
        Assert.assertEquals((Object)node, (Object)node2);
    }

    static {
        prefixMap.add("rdf", RDF.getURI());
        prefixMap.add("xsd", XSD.getURI());
        prefixMap.add("rdfs", RDFS.getURI());
        prefixMap.add("ex", "http://example.org/");
        prefixMap.add("", "http://example/");
        prefixMap.add("ns", "http://namespace/ns#");
    }
}

