/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sys.JenaSystem;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSerializable {
    @BeforeClass
    public static void beforeClass() {
        JenaSystem.init();
    }

    private static <X> X roundTrip(X n) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(n);
        byte[] b = out.toByteArray();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(b));
        Object x = ois.readObject();
        return (X)x;
    }

    @Test
    public void serialize_node_01() throws Exception {
        Node n = SSE.parseNode("<http://example/>");
        Node n1 = TestSerializable.roundTrip(n);
        Assert.assertTrue((boolean)n1.isURI());
        Assert.assertEquals((Object)n, (Object)n1);
    }

    @Test
    public void serialize_node_02() throws Exception {
        Node n = SSE.parseNode("123");
        Node n1 = TestSerializable.roundTrip(n);
        Assert.assertTrue((boolean)n1.isLiteral());
        Assert.assertEquals((Object)n, (Object)n1);
    }

    @Test
    public void serialize_node_03() throws Exception {
        Node n = SSE.parseNode("_:b");
        Node n1 = TestSerializable.roundTrip(n);
        Assert.assertTrue((boolean)n1.isBlank());
        Assert.assertEquals((Object)n, (Object)n1);
    }

    @Test
    public void serialize_node_04() throws Exception {
        Node n = Node.ANY;
        Node n1 = TestSerializable.roundTrip(n);
        Assert.assertEquals((Object)n, (Object)n1);
        Assert.assertSame((Object)n, (Object)n1);
    }

    @Test
    public void serialize_node_05() throws Exception {
        Var v = Var.alloc("X");
        Var v1 = TestSerializable.roundTrip(v);
        Assert.assertEquals((Object)v, (Object)v1);
    }

    @Test
    public void serialize_node_06() throws Exception {
        Node v = NodeFactory.createVariable("Foo");
        Node v1 = TestSerializable.roundTrip(v);
        Assert.assertEquals((Object)v, (Object)v1);
    }

    @Test
    public void serialize_triple_01() throws Exception {
        Triple t = SSE.parseTriple("(:s :p :o)");
        Triple t1 = TestSerializable.roundTrip(t);
        Assert.assertEquals((Object)t, (Object)t1);
    }

    @Test
    public void serialize_triple_02() throws Exception {
        Triple t = SSE.parseTriple("(:x :x :x)");
        Triple t1 = TestSerializable.roundTrip(t);
        Assert.assertEquals((Object)t, (Object)t1);
        Assert.assertEquals((Object)t1.getSubject(), (Object)t1.getObject());
    }

    @Test
    public void serialize_triple_03() throws Exception {
        Triple t = SSE.parseTriple("(?a _:b 123)");
        Triple t1 = TestSerializable.roundTrip(t);
        Assert.assertEquals((Object)t, (Object)t1);
    }

    @Test
    public void serialize_triple_04() throws Exception {
        Triple t = SSE.parseTriple("(_:b _:b _:c)");
        Triple t1 = TestSerializable.roundTrip(t);
        Assert.assertEquals((Object)t, (Object)t1);
        Assert.assertEquals((Object)t1.getSubject(), (Object)t1.getPredicate());
        Assert.assertNotEquals((Object)t1.getSubject(), (Object)t1.getObject());
        Assert.assertTrue((boolean)t1.getSubject().isBlank());
    }

    @Test
    public void serialize_quad_01() throws Exception {
        Quad q = SSE.parseQuad("(:g :s :p :o)");
        Quad q1 = TestSerializable.roundTrip(q);
        Assert.assertEquals((Object)q, (Object)q1);
    }

    @Test
    public void serialize_quad_02() throws Exception {
        Quad q = SSE.parseQuad("(_ :s :p :o)");
        Quad q1 = TestSerializable.roundTrip(q);
        Assert.assertEquals((Object)q, (Object)q1);
        Assert.assertNotEquals((Object)q.getSubject(), (Object)q1.getObject());
    }

    @Test
    public void serialize_quad_03() throws Exception {
        Quad q = SSE.parseQuad("(<_:abc> ?y ?x <_:abc>)");
        Quad q1 = TestSerializable.roundTrip(q);
        Assert.assertEquals((Object)q, (Object)q1);
        Assert.assertEquals((Object)q.getGraph(), (Object)q1.getObject());
    }

    @Test
    public void serialize_quad_04() throws Exception {
        Quad q = SSE.parseQuad("(<_:abc> <_:abc> <_:def> <_:abc>)");
        Quad q1 = TestSerializable.roundTrip(q);
        Assert.assertEquals((Object)q, (Object)q1);
        Assert.assertEquals((Object)q.getSubject(), (Object)q1.getObject());
        Assert.assertNotEquals((Object)q.getSubject(), (Object)q1.getPredicate());
    }
}

