/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriterRegistry;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestLangRegistration {
    private String name;
    private Lang lang;
    private boolean istriples;
    private boolean isquads;

    @Parameterized.Parameters(name="{0} -- {1} {2} {3}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> x = new ArrayList<Object[]>();
        TestLangRegistration.add("NULL", x, Lang.RDFNULL, true, true);
        TestLangRegistration.add("RDFXML", x, Lang.RDFXML, true, false);
        TestLangRegistration.add("NTRIPLES", x, Lang.NTRIPLES, true, false);
        TestLangRegistration.add("NT", x, Lang.NT, true, false);
        TestLangRegistration.add("N3", x, Lang.N3, true, false);
        TestLangRegistration.add("TURTLE", x, Lang.TURTLE, true, false);
        TestLangRegistration.add("TTL", x, Lang.TTL, true, false);
        TestLangRegistration.add("JSONLD", x, Lang.JSONLD, true, true);
        TestLangRegistration.add("RDFJSON", x, Lang.RDFJSON, true, false);
        TestLangRegistration.add("NQUADS", x, Lang.NQUADS, false, true);
        TestLangRegistration.add("NQ", x, Lang.NQ, false, true);
        TestLangRegistration.add("TRIG", x, Lang.TRIG, false, true);
        TestLangRegistration.add("TRIX", x, Lang.TRIX, true, true);
        TestLangRegistration.add("TRDF", x, Lang.RDFTHRIFT, true, true);
        return x;
    }

    private static void add(String name, List<Object[]> x, Lang lang, boolean istriples, boolean isquads) {
        x.add(new Object[]{name, lang, istriples, isquads});
    }

    public TestLangRegistration(String name, Lang lang, boolean istriples, boolean isquads) {
        this.name = name;
        this.lang = lang;
        this.istriples = istriples;
        this.isquads = isquads;
    }

    @Test
    public void jenaSystem_read_1() {
        Assert.assertTrue((boolean)RDFLanguages.isRegistered(this.lang));
        if (this.istriples) {
            Assert.assertTrue((boolean)RDFLanguages.isTriples(this.lang));
        } else {
            Assert.assertFalse((boolean)RDFLanguages.isTriples(this.lang));
        }
        if (this.isquads) {
            Assert.assertTrue((boolean)RDFLanguages.isQuads(this.lang));
        } else {
            Assert.assertFalse((boolean)RDFLanguages.isQuads(this.lang));
        }
    }

    @Test
    public void jenaSystem_read_2() {
        if (!Lang.RDFNULL.equals(this.lang)) {
            Assert.assertTrue((boolean)RDFParserRegistry.isRegistered(this.lang));
            Assert.assertNotNull((Object)RDFParserRegistry.getFactory(this.lang));
        }
    }

    @Test
    public void jenaSystem_write_1() {
        Assert.assertTrue((boolean)RDFWriterRegistry.contains(this.lang));
    }

    @Test
    public void jenaSystem_write_2() {
        if (this.istriples) {
            Assert.assertNotNull((Object)RDFWriterRegistry.getWriterGraphFactory(this.lang));
        }
        if (this.isquads) {
            Assert.assertNotNull((Object)RDFWriterRegistry.getWriterDatasetFactory(this.lang));
        }
        Assert.assertNotNull((Object)RDFWriterRegistry.defaultSerialization(this.lang));
    }
}

