/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFParserBuilder;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.CatchParserOutput;
import org.apache.jena.riot.system.ErrorHandler;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestIRIxRIOT {
    private static final Optional<Boolean> TRUE = Optional.of(true);
    private static final Optional<Boolean> FALSE = Optional.of(false);
    private static final Optional<Boolean> UNSET = Optional.empty();

    @Test
    public void irix_http_1_nt() {
        TestIRIxRIOT.testDft("<http://example/>", Lang.NT, 0, 0);
    }

    @Test
    public void irix_http_1_nt_check() {
        TestIRIxRIOT.testNT("<http://example/>", TRUE, UNSET, 0, 0);
    }

    @Test
    public void irix_http_1_ttl() {
        TestIRIxRIOT.testDft("<http://example/>", Lang.TTL, 0, 0);
    }

    @Test
    public void irix_http_2_nt() {
        TestIRIxRIOT.testDft("<HTTP://example/>", Lang.NT, 0, 0);
    }

    @Test
    public void irix_http_2_nt_check() {
        TestIRIxRIOT.testLang("<HTTP://example/>", Lang.NT, UNSET, TRUE, 0, 1);
    }

    @Test
    public void irix_http_2_ttl() {
        TestIRIxRIOT.testDft("<HTTP://example/>", Lang.TTL, 0, 1);
    }

    @Test
    public void irix_http_3_nt() {
        TestIRIxRIOT.testDft("<http://EXAMPLE/>", Lang.NT, 0, 0);
    }

    @Test
    public void irix_http_3_nt_check() {
        TestIRIxRIOT.testLang("<http://EXAMPLE/>", Lang.NT, UNSET, TRUE, 0, 0);
    }

    @Test
    public void irix_http_3_ttl() {
        TestIRIxRIOT.testDft("<http://EXAMPLE/>", Lang.TTL, 0, 0);
    }

    @Test
    public void irix_http_4_nt() {
        TestIRIxRIOT.testDft("<http://user:pw@host/>", Lang.NT, 0, 0);
    }

    @Test
    public void irix_http_4_nt_check() {
        TestIRIxRIOT.testLang("<http://user:pw@host/>", Lang.NT, UNSET, TRUE, 0, 2);
    }

    @Test
    public void irix_http_4_ttl() {
        TestIRIxRIOT.testDft("<http://user:pw@host/>", Lang.TTL, 0, 2);
    }

    @Test
    public void irix_uuid_1_nt() {
        TestIRIxRIOT.testDft("<urn:uuid:6cd401dc-a8d2-11eb-9192-1f162b53dc79>", Lang.NT, 0, 0);
    }

    @Test
    public void irix_uuid_1_nt_check() {
        TestIRIxRIOT.testLang("<urn:uuid:6cd401dc-a8d2-11eb-9192-1f162b53dc79>", Lang.NT, UNSET, TRUE, 0, 0);
    }

    @Test
    public void irix_uuid_1_ttl() {
        TestIRIxRIOT.testDft("<urn:uuid:6cd401dc-a8d2-11eb-9192-1f162b53dc79>", Lang.TTL, 0, 0);
    }

    @Test
    public void irix_uuid_2_nt() {
        TestIRIxRIOT.testDft("<urn:uuid:bad>", Lang.NT, 0, 1);
    }

    @Test
    public void irix_uuid_2_nt_check() {
        TestIRIxRIOT.testLang("<urn:uuid:bad>", Lang.NT, UNSET, TRUE, 0, 1);
    }

    @Test
    public void irix_uuid_2_ttl() {
        TestIRIxRIOT.testDft("<urn:uuid:bad>", Lang.TTL, 0, 1);
    }

    @Test
    public void irix_uuid_3_nt() {
        TestIRIxRIOT.testDft("<urn:uuid:bad>", Lang.NT, 0, 1);
    }

    @Test
    public void irix_uuid_3_nt_check() {
        TestIRIxRIOT.testLang("<urn:uuid:bad>", Lang.NT, UNSET, TRUE, 0, 1);
    }

    @Test
    public void irix_uuid_3_ttl() {
        TestIRIxRIOT.testDft("<urn:uuid:bad>", Lang.TTL, 0, 1);
    }

    @Test
    public void irix_uuid_4_nt() {
        TestIRIxRIOT.testDft("<uuid:bad>", Lang.NT, 0, 1);
    }

    @Test
    public void irix_uuid_4_nt_check() {
        TestIRIxRIOT.testLang("<uuid:bad>", Lang.NT, UNSET, TRUE, 0, 1);
    }

    @Test
    public void irix_uuid_4_ttl() {
        TestIRIxRIOT.testDft("<uuid:bad>", Lang.TTL, 0, 1);
    }

    @Test
    public void irix_urn_1_nt() {
        TestIRIxRIOT.testDft("<urn:ab:c>", Lang.NT, 0, 0);
    }

    @Test
    public void irix_urn_1_nt_check() {
        TestIRIxRIOT.testLang("<urn:ab:c>", Lang.NT, UNSET, TRUE, 0, 0);
    }

    @Test
    public void irix_urn_1_ttl() {
        TestIRIxRIOT.testDft("<urn:ab:c>", Lang.TTL, 0, 0);
    }

    @Test
    public void irix_urn_2_nt() {
        TestIRIxRIOT.testDft("<urn:x:c>", Lang.NT, 0, 0);
    }

    @Test
    public void irix_urn_2_nt_check() {
        TestIRIxRIOT.testLang("<urn:x:c>", Lang.NT, UNSET, TRUE, 0, 1);
    }

    @Test
    public void irix_urn_2_ttl() {
        TestIRIxRIOT.testDft("<urn:x:c>", Lang.TTL, 0, 1);
    }

    @Test
    public void irix_urn_3_nt() {
        TestIRIxRIOT.testDft("<urn:00:c>", Lang.NT, 0, 0);
    }

    @Test
    public void irix_urn_3_nt_check() {
        TestIRIxRIOT.testLang("<urn:00:c>", Lang.NT, UNSET, TRUE, 0, 0);
    }

    @Test
    public void irix_urn_3_ttl() {
        TestIRIxRIOT.testDft("<urn:00:c>", Lang.TTL, 0, 0);
    }

    @Test
    public void irix_err_1_nt() {
        TestIRIxRIOT.testDft("<http://host/bad path/>", Lang.NT, 1, 1);
    }

    @Test
    public void irix_err_1_nt_check() {
        TestIRIxRIOT.testLang("<http://host/bad path/>", Lang.NT, UNSET, TRUE, 1, 1);
    }

    @Test
    public void irix_err_1_ttl() {
        TestIRIxRIOT.testDft("<http://host/bad path/>", Lang.TTL, 1, 1);
    }

    @Test
    public void irix_relative_nt() {
        TestIRIxRIOT.testNT("<relative>", UNSET, UNSET, 0, 0);
    }

    @Test
    public void irix_relative_nt_check() {
        TestIRIxRIOT.testNT("<relative>", UNSET, TRUE, 0, 1);
    }

    @Test
    public void irix_relative_nt_strict() {
        TestIRIxRIOT.testNT("<relative>", TRUE, UNSET, 1, 0);
    }

    @Test
    public void irix_relative_nt_strict_check() {
        TestIRIxRIOT.testNT("<relative>", TRUE, TRUE, 1, 0);
    }

    @Test
    public void irix_relative_nt_strict_nocheck() {
        TestIRIxRIOT.testNT("<relative>", TRUE, FALSE, 1, 0);
    }

    @Test
    public void irix_relative_3_ttl() {
        Assume.assumeTrue((IRIs.getBaseStr() != null ? 1 : 0) != 0);
        TestIRIxRIOT.testTTL("<relative>", UNSET, UNSET, 0, 0);
    }

    @Test
    public void irix_ttl_resolver_0() {
        IRIxResolver resolver = IRIxResolver.create().noBase().build();
        TestIRIxRIOT.testTTL("<relative>", resolver, 0, 1);
    }

    @Test
    public void irix_ttl_resolver_1() {
        IRIxResolver resolver = IRIxResolver.create().noBase().allowRelative(false).build();
        TestIRIxRIOT.testTTL("<relative>", resolver, 1, 0);
    }

    @Test
    public void irix_ttl_resolver_2() {
        IRIxResolver resolver = IRIxResolver.create().noBase().resolve(false).allowRelative(false).build();
        TestIRIxRIOT.testTTL("<relative>", resolver, 1, 0);
    }

    @Test
    public void irix_ttl_resolver_3() {
        IRIxResolver resolver = IRIxResolver.create().noBase().resolve(true).allowRelative(true).build();
        TestIRIxRIOT.testTTL("<relative>", resolver, 0, 1);
    }

    @Test
    public void irix_ttl_resolver_4() {
        IRIxResolver resolver = IRIxResolver.create().noBase().resolve(false).allowRelative(true).build();
        TestIRIxRIOT.testTTL("<relative>", resolver, 0, 1);
    }

    @Test
    public void irix_ttl_resolver_5() {
        IRIxResolver resolver = IRIxResolver.create().noBase().resolve(false).allowRelative(true).build();
        TestIRIxRIOT.testTTL("<relative>", resolver, 0, 1);
    }

    private static void testDft(String iri2, Lang lang, int numErrors, int numWarnings) {
        TestIRIxRIOT.testLang(iri2, lang, null, UNSET, UNSET, numErrors, numWarnings);
    }

    private static void testLang(String iri2, Lang lang, Optional<Boolean> strict, Optional<Boolean> checking, int numErrors, int numWarnings) {
        TestIRIxRIOT.testLang(iri2, lang, null, strict, checking, numErrors, numWarnings);
    }

    private static void testNT(String iri2, Optional<Boolean> strict, Optional<Boolean> checking, int numErrors, int numWarnings) {
        TestIRIxRIOT.testLang(iri2, Lang.NT, null, strict, checking, numErrors, numWarnings);
    }

    private static void testTTL(String iri2, Optional<Boolean> strict, Optional<Boolean> checking, int numErrors, int numWarnings) {
        TestIRIxRIOT.testLang(iri2, Lang.TTL, "http://base/", strict, checking, numErrors, numWarnings);
    }

    private static void testTTL(String iri2, IRIxResolver resolver, int numErrors, int numWarnings) {
        InputStream in = TestIRIxRIOT.generateSource(iri2);
        RDFParserBuilder builder = RDFParser.source(in).forceLang(Lang.TTL).resolver(resolver);
        TestIRIxRIOT.runTest(builder, iri2, numErrors, numWarnings);
    }

    private static void testLang(String iri2, Lang lang, String base, Optional<Boolean> strict, Optional<Boolean> checking, int numErrors, int numWarnings) {
        InputStream in = TestIRIxRIOT.generateSource(iri2);
        RDFParserBuilder builder = RDFParser.source(in).forceLang(lang);
        builder.base(base);
        if (strict.isPresent()) {
            builder.strict(strict.get());
        }
        if (checking.isPresent()) {
            builder.checking(checking.get());
        }
        TestIRIxRIOT.runTest(builder, iri2, numErrors, numWarnings);
    }

    private static void runTest(RDFParserBuilder builder, String iri2, int numErrors, int numWarnings) {
        CatchParserOutput dest = new CatchParserOutput();
        ErrorHandlerCollector eh = new ErrorHandlerCollector();
        builder.errorHandler(eh);
        builder.build().parse(dest);
        int numErrorsActual = eh.errors.size();
        int numWarningsActual = eh.warnings.size();
        String msg = "Errors=(" + numErrors + ",got=" + numErrorsActual + ") Warnings=(" + numWarnings + ",got=" + numWarningsActual + ")";
        if (numErrors != numErrorsActual || numWarnings != numWarningsActual) {
            System.err.println("== " + iri2);
            System.err.println("-- " + msg);
            if (numErrorsActual == 0) {
                System.err.println("Errors: None");
            } else {
                eh.errors.forEach(m -> System.err.println("Error: " + m));
            }
            if (numWarningsActual == 0 && numWarnings >= 0) {
                System.err.println("Warnings: None");
            } else {
                eh.warnings.forEach(m -> System.err.println("Warnings: " + m));
            }
        }
        Assert.assertEquals((String)("Errors (" + msg + ")"), (long)numErrors, (long)numErrorsActual);
        if (numWarnings >= 0) {
            Assert.assertEquals((String)("Warnings (" + msg + ")"), (long)numWarnings, (long)numWarningsActual);
        }
    }

    private static InputStream generateSource(String iri2) {
        String TEXT = iri2 + " <x:p> <x:o> .";
        ByteArrayInputStream inText = new ByteArrayInputStream(Bytes.string2bytes(TEXT));
        return inText;
    }

    static class ErrorHandlerCollector
    implements ErrorHandler {
        List<String> warnings = new ArrayList<String>();
        List<String> errors = new ArrayList<String>();
        List<String> fatals = new ArrayList<String>();

        ErrorHandlerCollector() {
        }

        @Override
        public void warning(String message, long line, long col) {
            this.warnings.add(message);
        }

        @Override
        public void error(String message, long line, long col) {
            this.errors.add(message);
        }

        @Override
        public void fatal(String message, long line, long col) {
            this.fatals.add(message);
            throw new RiotException(message);
        }
    }
}

