/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFWriterRegistry;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestFormatRegistration {
    private String name;
    private RDFFormat format;
    private boolean istriples;
    private boolean isquads;

    @Parameterized.Parameters(name="{0} -- {1} {2} {3}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> x = new ArrayList<Object[]>();
        TestFormatRegistration.add("NULL", x, RDFFormat.RDFNULL, false, false);
        TestFormatRegistration.add("RDFXML", x, RDFFormat.RDFXML, true, false);
        TestFormatRegistration.add("RDFXML", x, RDFFormat.RDFXML_ABBREV, true, false);
        TestFormatRegistration.add("RDFXML", x, RDFFormat.RDFXML_PLAIN, true, false);
        TestFormatRegistration.add("RDFXML", x, RDFFormat.RDFXML_PLAIN, true, false);
        TestFormatRegistration.add("NTRIPLES", x, RDFFormat.NTRIPLES, true, false);
        TestFormatRegistration.add("NT", x, RDFFormat.NT, true, false);
        TestFormatRegistration.add("TURTLE", x, RDFFormat.TURTLE, true, false);
        TestFormatRegistration.add("TTL", x, RDFFormat.TTL, true, false);
        TestFormatRegistration.add("JSONLD", x, RDFFormat.JSONLD, true, true);
        TestFormatRegistration.add("RDFJSON", x, RDFFormat.RDFJSON, true, false);
        TestFormatRegistration.add("NQUADS", x, RDFFormat.NQUADS, true, true);
        TestFormatRegistration.add("NQ", x, RDFFormat.NQ, true, true);
        TestFormatRegistration.add("TRIG", x, RDFFormat.TRIG, true, true);
        TestFormatRegistration.add("TRIX", x, RDFFormat.TRIX, true, true);
        TestFormatRegistration.add("TRDF", x, RDFFormat.RDF_THRIFT, true, true);
        TestFormatRegistration.add("TRDF", x, RDFFormat.RDF_THRIFT_VALUES, true, true);
        return x;
    }

    private static void add(String name, List<Object[]> x, RDFFormat format, boolean istriples, boolean isquads) {
        x.add(new Object[]{name, format, istriples, isquads});
    }

    public TestFormatRegistration(String name, RDFFormat format, boolean istriples, boolean isquads) {
        this.name = name;
        this.format = format;
        this.istriples = istriples;
        this.isquads = isquads;
    }

    @Test
    public void jenaSystem_write_1() {
        Assert.assertTrue((boolean)RDFWriterRegistry.contains(this.format));
    }

    @Test
    public void jenaSystem_write_2() {
        Assert.assertTrue((boolean)RDFWriterRegistry.registeredGraphFormats().contains(this.format));
        if (this.istriples) {
            Assert.assertNotNull((Object)RDFWriterRegistry.getWriterGraphFactory(this.format));
        }
        if (this.isquads) {
            Assert.assertNotNull((Object)RDFWriterRegistry.getWriterDatasetFactory(this.format));
        }
    }

    @Test
    public void xjenaSystem_write_3() {
        RDFWriterRegistry.contains(this.format);
        if (this.istriples) {
            Assert.assertTrue((boolean)RDFWriterRegistry.registeredGraphFormats().contains(this.format));
        }
        if (this.isquads) {
            Assert.assertTrue((boolean)RDFWriterRegistry.registeredDatasetFormats().contains(this.format));
        }
    }
}

