/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.graph.Node;
import org.apache.jena.riot.ErrorHandlerTestLib;
import org.apache.jena.riot.system.Checker;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.shared.impl.JenaParameters;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestChecker {
    private boolean b;
    private static ErrorHandler errorHandler = new ErrorHandlerTestLib.ErrorHandlerEx();

    @Before
    public void before() {
        this.b = JenaParameters.enableWhitespaceCheckingOfTypedLiterals;
    }

    @After
    public void after() {
        JenaParameters.enableWhitespaceCheckingOfTypedLiterals = this.b;
    }

    @Test
    public void checker_uri_01() {
        TestChecker.check("<http://example/x>");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker_uri_02() {
        TestChecker.check("<x>");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker_uri_03() {
        TestChecker.check("<urn:abc>");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker_uri_04() {
        TestChecker.check("<urn:x:bc>");
    }

    @Test
    public void checker_uri_05() {
        TestChecker.check("<urn:abc:y>");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker_uri_06() {
        TestChecker.check("<URN:abc:y>");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker_uri_07() {
        TestChecker.check("<http://example:80/>");
    }

    @Test
    public void checker01() {
        TestChecker.check("''");
    }

    @Test
    public void checker02() {
        TestChecker.check("''@en");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker10() {
        TestChecker.check("''^^xsd:dateTime");
    }

    @Test
    public void checker11() {
        TestChecker.check("'  2010-05-19T01:01:01.01+01:00'^^xsd:dateTime");
    }

    @Test
    public void checker12() {
        TestChecker.check("'\\n2010-05-19T01:01:01.01+01:00\\t\\r  '^^xsd:dateTime");
    }

    @Test
    public void checker13() {
        TestChecker.check("' 123'^^xsd:integer");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker14() {
        TestChecker.check("'12 3'^^xsd:integer");
    }

    @Test
    public void checker15() {
        TestChecker.check("'\\n123'^^xsd:integer");
    }

    @Test
    public void checker16() {
        TestChecker.check("'123.0  '^^xsd:float");
    }

    @Test
    public void checker17() {
        TestChecker.check("'123.0\\n'^^xsd:double");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker18() {
        TestChecker.check("'\\b123.0\\n'^^xsd:double");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker20() {
        TestChecker.check("'XYZ'^^xsd:integer");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker21() {
        TestChecker.check("'XYZ'@abcdefghijklmn");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker30() {
        TestChecker.check("<http://base/[]iri>");
    }

    @Test
    public void checker40() {
        TestChecker.check("\"<x></x>\"^^rdf:XMLLiteral");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker41() {
        TestChecker.check("\"<x>\"^^rdf:XMLLiteral");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker42() {
        TestChecker.check("\"<x><y></x></y>\"^^rdf:XMLLiteral");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker43() {
        TestChecker.check("\"<x/>\"^^rdf:XMLLiteral");
    }

    @Test
    public void checker44() {
        TestChecker.check("'''<x xmlns=\"http://example/ns#\" attr=\"foo\"></x>'''^^rdf:XMLLiteral");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void checker45() {
        TestChecker.check("'''<x attr=\"foo\" xmlns=\"http://example/ns#\"></x>'''^^rdf:XMLLiteral");
    }

    private static void check(String string) {
        Node n = NodeFactoryExtra.parseNode(string);
        Checker.check(n, errorHandler, -1L, -1L);
    }
}

